<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<header id="kopa-header" class="header-2">
    <div class="kopa-header-top">
        <div class="container">
            <div class="menu-second pull-left">
                <?php if ( has_nav_menu( 'top-nav' ) ): ?>
                <?php wp_nav_menu( array(
                    'theme_location'  => 'top-nav',
                    'container'       => false,
                    'items_wrap' => '<ul id="top-menu" class="list-unstyled clearfix">%3$s</ul>',
                    'depth'           => -1,
                )); ?>
                <?php endif; ?>
                <!-- top-nav -->
            </div>
            <div class="kopa-social pull-right">
                <?php
                $target = get_theme_mod('karo_light_options_social_links_target');
                $rss_url = get_theme_mod ( 'karo_light_options_social_links_rss_url', '' );
                $rss_nofolow = true;
                if (empty($rss_url)){
                    $rss_url = get_bloginfo('rss2_url');
                    $rss_nofolow = false;
                }
                ?>

                <?php if( $rss_url != 'HIDE') :?>
                <a href="<?php echo esc_url($rss_url); ?>" class="fa fa-rss" target="<?php echo esc_attr($target); ?>" title="Rss" <?php if ($rss_nofolow) echo 'rel="nofollow"'; ?>></a>
                <?php endif; ?>

                <?php if(get_theme_mod( 'karo_light_options_social_links_facebook_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_facebook_url' )); ?>" class="fa fa-facebook" target="<?php echo esc_attr($target); ?>" title="Facebook"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_twitter_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_twitter_url' )); ?>" class="fa fa-twitter" target="<?php echo esc_attr($target); ?>" title="Twitter" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_google_plus_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_google_plus_url' )); ?>" class="fa fa-google-plus" target="<?php echo esc_attr($target); ?>" title="Google+" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_skype' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_skype' )); ?>" class="fa fa-skype" target="<?php echo esc_attr($target); ?>" title="Skype" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_dribbble_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_dribbble_url' )); ?>" class="fa fa-dribbble" target="<?php echo esc_attr($target); ?>" title="Dribbble" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_tumblr_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_tumblr_url' )); ?>" class="fa fa-tumblr" target="<?php echo esc_attr($target); ?>" title="Tumblr" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_pinterest_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_pinterest_url' )); ?>" class="fa fa-pinterest" target="<?php echo esc_attr($target); ?>" title="Pinterest" rel="nofollow"></a>
                <?php endif; ?>

                <?php if(get_theme_mod ( 'karo_light_options_social_links_linkedin_url' )) :?>
                <a href="<?php echo esc_url(get_theme_mod ( 'karo_light_options_social_links_linkedin_url' )); ?>" class="fa fa-linkedin" target="<?php echo esc_attr($target); ?>" title="Linkedin" rel="nofollow"></a>
                <?php endif; ?>
            </div>
            <!-- social -->
        </div>
    </div>
    <!-- kopa header top -->
    <div class="kopa-header-middle">
        <div class="container">
            <?php
                $logo_url =  get_theme_mod('karo_light_options_logo');
                $banner_url =  get_theme_mod('karo_light_options_top_banner');
                $banner_link = get_theme_mod('karo_light_options_top_banner_link');
                if( !$banner_link ){
                    $banner_link = home_url();
                }
                $target = get_theme_mod('karo_light_options_top_banner_target', '_blank');
            ?>
            <div class="kopa-logo pull-left">
                <?php if( $logo_url ) : ?>
                    <a href="<?php echo esc_url(home_url());?>" title="<?php bloginfo('name'); ?>"><img id="logo-image" src="<?php echo esc_url( $logo_url ); ?>" alt="<?php bloginfo('name'); ?>"></a>
                <?php else : ?>
                    <h1 class="kopa-header-text"><a id="name" href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php bloginfo( 'name' ); ?></a></h1>
                <?php endif; ?>
            </div>
            <!-- logo -->
            <?php if($banner_url) : ?>
                <div class="kopa-baner pull-right">
                    <a href="<?php echo esc_url($banner_link);?>" title="<?php bloginfo('name'); ?>" target="<?php echo esc_attr($target); ?>"><img src="<?php echo esc_url( $banner_url ); ?>" alt="<?php bloginfo('name'); ?>"></a>
                </div>
                <!-- banner -->
            <?php endif; ?>
        </div>
        <!-- container -->
    </div>
    <!-- kopa header middle -->
    <?php if ( has_nav_menu( 'main-nav' )): ?>
        <div class="kopa-header-bottom">
            <div class="container">
                <div class="main-menu">
                    <span class="mobile-menu-icon fa fa-align-justify"></span>
                    <?php
                        wp_nav_menu( array(
                            'theme_location'  => 'main-nav',
                            'container'       => '',
                            'menu_id'         => 'main-menu',
                            'menu_class'      => 'kopa-menu sf-menu',
                        ));

                        wp_nav_menu( array(
                            'theme_location'  => 'main-nav',
                            'container'       => '',
                            'menu_id'         => 'kopa-mobile-menu',
                            'menu_class'      => 'kopa-menu mobile-menu',
                        ));
                    ?>
                </div>
                <!-- main-menu -->
            </div>
        </div>
    <?php endif; ?>
    <!-- kopa header bottom -->
    <div class="kopa-head-line clearfix">
        <div class="container">
            <?php kopa_light_get_headline(); ?>
            <!-- widget news carousel -->
            <?php get_search_form(); ?>
            <!-- search box -->
        </div>
        <!-- container -->
    </div>
    <!-- kopa head line -->
</header>
<!-- page header -->