<?php
if ('comments.php' == basename($_SERVER['SCRIPT_FILENAME'])) {
    die(__('Please do not load this page directly. Thanks!', 'karo-light'));
}

// check if post is pwd protected
if ( post_password_required() )
    return;

if (is_singular() && 'open' != get_option('default_comment_status', 'open'))
    return;

if ( have_comments() ) { ?>
<div id="comments">
    <h3 class="comments-title"><?php comments_number(__('No Comment', 'karo-light'), esc_attr__('1 Comment', 'karo-light'), esc_attr__('% Comments', 'karo-light')); ?></h3>
    <ul class="comment-list">
        <?php
        wp_list_comments(array(
            'walker' => null,
            'style' => 'ul',
            'callback' => 'kopa_comments_callback',
            'end-callback' => null,
            'type' => 'all'
        ));
        ?>
    </ul>

    <?php
    // whether or not display paginate comments link
    $prev_comments_link = get_previous_comments_link();
    $next_comments_link = get_next_comments_link();

    if ( '' !== $prev_comments_link . $next_comments_link ) { ?>

        <div class="pagination kopa-comment-pagination">
            <?php paginate_comments_links(); ?>
        </div>
        <!-- pagination -->
        <?php } // endif ?>
</div>
<?php } elseif ( ! comments_open() && post_type_supports(get_post_type(), 'comments') ) {
    return;
} // endif

comment_form(kopa_comment_form_args());

/*
 * Comments call back function
 */
function kopa_comments_callback($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;

    if ( 'pingback' == get_comment_type() || 'trackback' == get_comment_type() ) { ?>

    <li id="comment-<?php comment_ID(); ?>" <?php comment_class( 'comment' ); ?>>
        <article class="comment-body">
            <figure class="pull-left">
                <?php echo get_avatar( $comment, 50 ); ?>
            </figure>
            <div class="comment-content item-right">
                <header class="clearfix">
                    <h4><?php esc_attr_e( 'Pingback', 'karo-light' ); ?></h4>
                    <p class="kopa-metadata"><?php comment_date( get_option( 'date_format' ) ); ?> <?php esc_attr_e('at', 'karo-light'); ?> <?php comment_date(get_option('time_format')); ?></p>
                    <p class="reply-edit">
                        <?php if ( current_user_can( 'moderate_comments' ) ) {
                        edit_comment_link( esc_attr__( 'Edit', 'karo-light' ) );
                    } ?>
                    </p>
                </header>
                <p><a href="<?php if ( get_comment_author_url() ) { echo get_comment_author_url(); }?>" target="_blank" title="<?php esc_attr_e('Pingback', 'karo-light');?>"><?php if ( get_comment_author_url() ) { echo get_comment_author_url(); }?></a></p>
            </div><!--comment-body -->
        </article>
    </li>

    <?php } elseif ( 'comment' == get_comment_type() ) { ?>

    <li id="comment-<?php comment_ID(); ?>" <?php comment_class( 'comment' ); ?>>
        <article class="comment-body">
            <figure class="pull-left">
                <?php if ( get_comment_author_url() ) { ?>
                        <a href="<?php comment_author_url(); ?>">
                    <?php } ?>

                <?php echo get_avatar( $comment->comment_author_email, 50 ); ?>

                <?php if ( get_comment_author_url() ) { ?>
                        </a>
                    <?php } ?>
            </figure>

            <div class="comment-content item-right">
                <header class="clearfix">
                    <h4>
                        <?php if ( get_comment_author_url() ) { ?>
                                <a href="<?php comment_author_url(); ?>">
                            <?php } ?>

                        <?php comment_author(); ?>

                        <?php if ( get_comment_author_url() ) { ?>
                                </a>
                            <?php } ?>
                    </h4>
                    <p class="kopa-metadata"><?php comment_date( get_option( 'date_format' ) ); ?> <?php esc_attr_e('at', 'karo-light'); ?> <?php comment_date(get_option('time_format')); ?></p>
                    <p class="reply-edit">
                        <?php if ( current_user_can( 'moderate_comments' ) ) {
                        edit_comment_link( esc_attr__( 'Edit', 'karo-light' ) );
                    } ?> /
                        <?php comment_reply_link(array_merge($args, array('depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                    </p>
                </header>
                <div class="entry-content">
                    <?php comment_text(); ?>
                </div>
            </div><!--comment-body -->
        </article>
    </li>

    <?php
    } // endif check comment type
}

function kopa_comment_form_args() {
    global $user_identity;
    $commenter = wp_get_current_commenter();

    $commeter_author = esc_attr($commenter['comment_author']);
    $commenter_author_email = esc_attr($commenter['comment_author_email']);
    $commenter_author_url = esc_attr($commenter['comment_author_url']);

    $fields = array(
        'author' => '<div class="row">
                    <div class="col-lg-5 col-md-5 col-sm-5 col-xs-12">
                    <div class="form-group">
                    <input id="comment_name" name="author" value="'. $commeter_author . '" placeholder="' . esc_attr__('Name (required)', 'karo-light') . '" type="text">
                    </div>',
        'email' => '<div class="form-group">
                        <input id="comment_email" name="email" value="'. $commenter_author_email . '"  type="email" placeholder="' . esc_attr__('Email (required)', 'karo-light') .'">
                    </div>',
        'url'   => '<div class="form-group">
                    <input id="comment_url" type="text" name="url" value="' . $commenter_author_url .'" placeholder="' . esc_attr__('Website', 'karo-light') . '">
                    </div></div>'
    );

    if ( ! is_user_logged_in() ) {
        $comment_field = '<div class="col-lg-7 col-md-7 col-sm-7 col-xs-12">'.
            '<div class="form-group">'.
            '<textarea id="comment_message" name="comment" style="overflow:auto;resize:vertical ;" placeholder="' . esc_attr__('Your comment (required)', 'karo-light') . '"></textarea>'.
            '</div>'.
            '</div></div>';
    } else {
        $comment_field = '<p class="textarea-block"><textarea id="comment_message" name="comment" style="overflow:auto;resize:vertical ;" placeholder="' . esc_attr__('Your comment (required)', 'karo-light') . '"></textarea></p><div class="clear"></div>';
    }

    $args = array(
        'fields' => apply_filters('comment_form_default_fields', $fields),
        'comment_field' => $comment_field,
        'comment_notes_before' => '<p class="comment-notes">'.__('Your email address will not be published. Required fields are marked', 'karo-light').' <span>( '.__('required', 'karo-light') . ' )</span></p>',
        'comment_notes_after' => '',
        'id_form' => 'comments-form',
        'id_submit' => 'submit-comment',
        'title_reply' => '<h3 class="comment-reply-title">'.__('LEAVE A REPLY', 'karo-light').'</h3>',
        // 'title_reply_to' => esc_attr__('Reply to %s', 'karo-light'),
        // 'cancel_reply_link' => '<span class="title-text">'.__('Cancel', 'karo-light').'</span>',
        'label_submit' =>__('Post Comment', 'karo-light'),
    );

    return $args;
}
