<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package kafal
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'kafal' ); ?></a>
	<?php get_template_part( 'template-parts/header', 'nav' ) ?>
	<header id="masthead" class="site-header intro-header" role="banner" >

		<div class="container">
            <div class="row">
                <div id="header-text" class="col-lg-8 col-lg-offset-2 col-md-10 col-md-offset-1">
                    <?php kafal_header_title();?>
                </div>
            </div>
        </div>

	</header><!-- #masthead -->

	<div id="content" class="site-content container">