<?php
/**
 * Header Builder Options
 *
 * @package Kadence
 */

namespace Kadence;

use Kadence\Theme_Customizer;
use function Kadence\kadence;
ob_start(); ?>
<div class="kadence-compontent-description">
<h2><?php echo esc_html__( 'Social Network Links', 'kadence' ); ?></h2>
</div>
<?php
$compontent_description = ob_get_clean();
$settings               = [
	'social_settings'           => [
		'control_type' => 'kadence_blank_control',
		'section'      => 'general_social',
		'settings'     => false,
		'priority'     => 1,
		'description'  => $compontent_description,
	],
	'social_links_open_new_tab' => [
		'control_type' => 'kadence_switch_control',
		'sanitize'     => 'kadence_sanitize_toggle',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'social_links_open_new_tab' ),
		'label'        => esc_html__( 'Open Social Links in New Tab', 'kadence' ),
	],
	'facebook_link'             => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'facebook_link' ),
		'label'        => esc_html__( 'Facebook', 'kadence' ),
	],
	'twitter_link'              => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'twitter_link' ),
		'label'        => esc_html__( 'X formerly Twitter', 'kadence' ),
	],
	'youtube_link'              => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'youtube_link' ),
		'label'        => esc_html__( 'YouTube', 'kadence' ),
	],
	'instagram_link'            => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'instagram_link' ),
		'label'        => esc_html__( 'Instagram', 'kadence' ),
	],
	'pinterest_link'            => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'pinterest_link' ),
		'label'        => esc_html__( 'Pinterest', 'kadence' ),
	],
	'500px_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( '500px_link' ),
		'label'        => esc_html__( '500PX', 'kadence' ),
	],
	'amazon_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'amazon_link' ),
		'label'        => esc_html__( 'Amazon', 'kadence' ),
	],
	'anchor_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'anchor_link' ),
		'label'        => esc_html__( 'Anchor', 'kadence' ),
	],
	'apple_podcasts_link'       => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'apple_podcasts_link' ),
		'label'        => esc_html__( 'Apple Podcast', 'kadence' ),
	],
	'bandcamp_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'bandcamp_link' ),
		'label'        => esc_html__( 'Bandcamp', 'kadence' ),
	],
	'behance_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'behance_link' ),
		'label'        => esc_html__( 'Behance', 'kadence' ),
	],
	'bluesky_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'bluesky_link' ),
		'label'        => esc_html__( 'Bluesky', 'kadence' ),
	],
	'bookbub_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'bookbub_link' ),
		'label'        => esc_html__( 'Bookbub', 'kadence' ),
	],
	'discord_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'discord_link' ),
		'label'        => esc_html__( 'Discord', 'kadence' ),
	],
	'dribbble_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'dribbble_link' ),
		'label'        => esc_html__( 'Dribbble', 'kadence' ),
	],
	'email_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'sanitize_text_field',
		'default'      => kadence()->default( 'email_link' ),
		'label'        => esc_html__( 'Email', 'kadence' ),
	],
	'facebook_group_link'       => [
		'control_type' => 'kadence_text_control',
		'sanitize'     => 'esc_url_raw',
		'section'      => 'general_social',
		'default'      => kadence()->default( 'facebook_group_link' ),
		'label'        => esc_html__( 'Facebook Group', 'kadence' ),
	],
	'flickr_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'flickr_link' ),
		'label'        => esc_html__( 'Flickr', 'kadence' ),
	],
	'flipboard_link'            => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'flipboard_link' ),
		'label'        => esc_html__( 'Flipboard', 'kadence' ),
	],
	'fstoppers_link'            => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'fstoppers_link' ),
		'label'        => esc_html__( 'Fstoppers', 'kadence' ),
	],
	'github_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'github_link' ),
		'label'        => esc_html__( 'GitHub', 'kadence' ),
	],
	'goodreads_link'            => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'goodreads_link' ),
		'label'        => esc_html__( 'Goodreads', 'kadence' ),
	],
	'google_reviews_link'       => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'google_reviews_link' ),
		'label'        => esc_html__( 'Google Reviews', 'kadence' ),
	],
	'imdb_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'imdb_link' ),
		'label'        => esc_html__( 'IMDB', 'kadence' ),
	],
	'imgur_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'imgur_link' ),
		'label'        => esc_html__( 'Imgur', 'kadence' ),
	],
	'line_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'line_link' ),
		'label'        => esc_html__( 'Line', 'kadence' ),
	],
	'linkedin_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'linkedin_link' ),
		'label'        => esc_html__( 'Linkedin', 'kadence' ),
	],
	'mastodon_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'mastodon_link' ),
		'label'        => esc_html__( 'Mastodon', 'kadence' ),
	],
	'medium_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'medium_link' ),
		'label'        => esc_html__( 'medium', 'kadence' ),
	],
	'mewe_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'mewe_link' ),
		'label'        => esc_html__( 'MeWe', 'kadence' ),
	],
	'parler_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'parler_link' ),
		'label'        => esc_html__( 'Parler', 'kadence' ),
	],
	'patreon_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'patreon_link' ),
		'label'        => esc_html__( 'Patreon', 'kadence' ),
	],
	'phone_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'sanitize_text_field',
		'default'      => kadence()->default( 'phone_link' ),
		'label'        => esc_html__( 'Phone', 'kadence' ),
	],
	'quora_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'quora_link' ),
		'label'        => esc_html__( 'Quora', 'kadence' ),
	],
	'ravelry_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'ravelry_link' ),
		'label'        => esc_html__( 'Ravelry', 'kadence' ),
	],
	'reddit_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'reddit_link' ),
		'label'        => esc_html__( 'Reddit', 'kadence' ),
	],
	'rss_link'                  => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'rss_link' ),
		'label'        => esc_html__( 'RSS', 'kadence' ),
	],
	'rumble_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'rumble_link' ),
		'label'        => esc_html__( 'Rumble', 'kadence' ),
	],
	'snapchat_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'snapchat_link' ),
		'label'        => esc_html__( 'Snapchat', 'kadence' ),
	],
	'soundcloud_link'           => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'soundcloud_link' ),
		'label'        => esc_html__( 'SoundCloud', 'kadence' ),
	],
	'spotify_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'spotify_link' ),
		'label'        => esc_html__( 'Spotify', 'kadence' ),
	],
	'steam_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'steam_link' ),
		'label'        => esc_html__( 'Steam', 'kadence' ),
	],
	'strava_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'strava_link' ),
		'label'        => esc_html__( 'Strava', 'kadence' ),
	],
	'telegram_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'telegram_link' ),
		'label'        => esc_html__( 'Telegram', 'kadence' ),
	],
	'threads_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'threads_link' ),
		'label'        => esc_html__( 'Threads', 'kadence' ),
	],
	'tiktok_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'tiktok_link' ),
		'label'        => esc_html__( 'Tiktok', 'kadence' ),
	],
	'trip_advisor_link'         => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'trip_advisor_link' ),
		'label'        => esc_html__( 'Trip Advisor', 'kadence' ),
	],
	'tumblr_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'tumblr_link' ),
		'label'        => esc_html__( 'Tumblr', 'kadence' ),
	],
	'twitch_link'               => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'twitch_link' ),
		'label'        => esc_html__( 'Twitch', 'kadence' ),
	],
	'vero_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'vero_link' ),
		'label'        => esc_html__( 'Vero', 'kadence' ),
	],
	'vimeo_link'                => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'vimeo_link' ),
		'label'        => esc_html__( 'Vimeo', 'kadence' ),
	],
	'vk_link'                   => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'vk_link' ),
		'label'        => esc_html__( 'VK', 'kadence' ),
	],
	'whatsapp_link'             => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'whatsapp_link' ),
		'label'        => esc_html__( 'WhatsApp', 'kadence' ),
	],
	'wordpress_link'            => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'wordpress_link' ),
		'label'        => esc_html__( 'WordPress', 'kadence' ),
	],
	'xing_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'xing_link' ),
		'label'        => esc_html__( 'Xing', 'kadence' ),
	],
	'yelp_link'                 => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'yelp_link' ),
		'label'        => esc_html__( 'Yelp', 'kadence' ),
	],
	'custom1_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'custom1_link' ),
		'label'        => esc_html__( 'Custom 1', 'kadence' ),
	],
	'custom2_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'custom2_link' ),
		'label'        => esc_html__( 'Custom 2', 'kadence' ),
	],
	'custom3_link'              => [
		'control_type' => 'kadence_text_control',
		'section'      => 'general_social',
		'sanitize'     => 'esc_url_raw',
		'default'      => kadence()->default( 'custom3_link' ),
		'label'        => esc_html__( 'Custom 3', 'kadence' ),
	],
];

Theme_Customizer::add_settings( $settings );
