<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;


function joyas_decor_shop_theme_setup(){

    // Make theme available for translation.
    load_theme_textdomain( 'joyas-decor-shop', get_stylesheet_directory_uri() . '/languages' );
    
    add_theme_support( 'custom-header', apply_filters( 'joyas_decor_shop_custom_header_args', array(
        'default-image' => get_stylesheet_directory_uri() . '/assets/images/custom-header.jpg',
        'default-text-color'     => '000000',
        'width'                  => 1000,
        'height'                 => 350,
        'flex-height'            => true,
        'wp-head-callback'       => 'joyas_shop_header_style',
    ) ) );
    
    register_default_headers( array(
        'default-image' => array(
        'url' => '%s/assets/images/custom-header.jpg',
        'thumbnail_url' => '%s/assets/images/custom-header.jpg',
        'description' => esc_html__( 'Default Header Image', 'joyas-decor-shop' ),
        ),
    ));

}
add_action( 'after_setup_theme', 'joyas_decor_shop_theme_setup' );

if ( ! function_exists( 'joyas_decor_shop_script' ) ) :
    function joyas_decor_shop_script() {
        // Enqueue the child theme's stylesheet
        wp_enqueue_style( 
            'joyas-decor-shop', 
            trailingslashit( get_template_directory_uri() ) . 'style.css', 
            array( 
                'joyas-shop-google-fonts', 
                'bootstrap', 
                'bi-icons', 
                'icofont', 
                'scrollbar', 
                'joyas-shop-common', 
                'joyas-shop-style' 
            ), 
            wp_get_theme()->get('Version') // Optional versioning for cache busting
        );

        $custom_css = ':root {--primary-color:'.esc_attr( get_theme_mod('__primary_color','#6c757d') ).'!important; --secondary-color: '.esc_attr( get_theme_mod('__secondary_color','#1F526B') ).'!important; --nav-h-color:'.esc_attr( get_theme_mod('__secondary_color','#1F526B') ).'!important;--nav-h-bg:'.esc_attr( get_theme_mod('__secondary_color','#1F526B') ).'!important;}';


        
        wp_add_inline_style( 'joyas-decor-shop', $custom_css );
        wp_enqueue_style( 'aos-next', get_stylesheet_directory_uri() . '/assets/aos-next/aos.css');
        wp_enqueue_script( 'aos-next-js', get_stylesheet_directory_uri() . '/assets/aos-next/aos.js',0, '3.3.7', true );

 wp_enqueue_script( 'joyas-decor-shop', get_theme_file_uri( '/assets/joyas-decor-shop.js'), array(),  wp_get_theme()->get('Version'), true);
    }
endif;

add_action( 'wp_enqueue_scripts', 'joyas_decor_shop_script', 999 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function joyas_decor_shop_widgets_init() {
	register_sidebar( array(
		'name'          => esc_html__( 'WooCommerce', 'joyas-decor-shop' ),
		'id'            => 'woocommerce',
		'description'   => esc_html__( 'Add widgets here.', 'joyas-decor-shop' ),
		'before_widget' => '<section id="%1$s" class="widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h3 class="widget-title"><span>',
		'after_title'   => '</span></h3>',
	) );
	
}
add_action( 'widgets_init', 'joyas_decor_shop_widgets_init' );

if ( ! function_exists('joyas_decor_shop_disable_from_parent') ) :

    add_action('init', 'joyas_decor_shop_disable_from_parent', 10);

    function joyas_decor_shop_disable_from_parent() {
        
        global $joyas_shop_header_layout;
        
        remove_action('joyas_shop_site_header', array($joyas_shop_header_layout, 'site_header_layout'), 30);
        remove_action('joyas_shop_site_header', array($joyas_shop_header_layout, 'site_header_top_bar'), 10);

        remove_action( 'woocommerce_before_main_content', 'joyas_shop_woocommerce_wrapper_before' );
        remove_action( 'woocommerce_after_main_content', 'joyas_shop_woocommerce_wrapper_after' );
     	
     	global $joyas_shop_footer_layout;
        remove_action('joyas_shop_site_footer', array( $joyas_shop_footer_layout, 'site_footer_info' ), 80 );  
    }

endif;

// END ENQUEUE PARENT ACTION

if( !function_exists('joyas_decor_shop_header_layout') ) : 
	function joyas_decor_shop_header_layout(){
	?>
	<div class="container center-layout-wrap">
		<div class="row align-items-center">
		    <div class="col-lg-4 col-md-4 col-sm-4 col-12 logo-wrap">
		    <?php
			    echo '<ul class="social-links">';
				
				if( joyas_shop_get_option('__fb_pro_link') != "" ): 
					echo '<li class="social-item-facebook"><a href="'.esc_url( joyas_shop_get_option('__fb_pro_link') ).'" target="_blank" rel="nofollow"><i class="icofont-facebook"></i></a></li>';				
				endif;
				
				if( joyas_shop_get_option('__tw_pro_link') != "" ): 
					echo '<li class="social-item-twitter"><a href="'.esc_url( joyas_shop_get_option('__tw_pro_link') ).'" target="_blank" rel="nofollow"><i class="icofont-twitter"></i></a></li>';
				endif;
				if( joyas_shop_get_option('__you_pro_link') != "" ): 
					echo '<li class="social-item-youtube"><a href="'.esc_url( joyas_shop_get_option('__you_pro_link') ).'" target="_blank" rel="nofollow"><i class="icofont-youtube"></i></a></li>';
				 endif;
						
				echo '</ul>';
			?>
		    </div>
		    <div class="col-lg-4 col-md-3 col-sm-6 col-12 text-center">
		      	<?php do_action('joyas_shop_header_layout_1_branding');?>
		    </div>
		    <div class="col-lg-4 col-md-4 col-sm-6 col-12 text-end">
					<ul class="header-icon d-flex justify-content-end ">
					<li class="flex-fill flex-grow-1"><a href="javascript:void(0)" class="searchbar-action"> <i class="icofont-ui-search"></i></a></li>
					<?php if ( class_exists( 'WooCommerce' ) ) :?>
					<li><?php joyas_shop_woocommerce_cart_link(); ?></li>
					<?php endif;?>
					<li class="toggle-list"><button class="joyas-shop-rd-navbar-toggle" tabindex="0" autofocus="true"><i class="icofont-navigation-menu"></i></button></li>
					</ul>
		    </div>
		</div>
	</div>
	<div id="nav_bar_wrap">
		<div class="container"> 
           <div class="row align-items-center text-center"> 
           	 <?php do_action('joyas_shop_header_layout_1_navigation'); ?>
           </div>
        </div>   	
	</div>
	<?php
	}
    add_action('joyas_shop_site_header', 'joyas_decor_shop_header_layout', 30 );
endif;

if( !function_exists('joyas_decor_shop_header_top_bar') ) : 
add_action('joyas_shop_site_header', 'joyas_decor_shop_header_top_bar', 10 );
function joyas_decor_shop_header_top_bar(){
		if ( has_nav_menu( 'topbar' ) || !empty(joyas_shop_get_option('__dialogue'))  ) :
		echo '<div class="top-bar-menu">
		<div class="container"><div class="left-menu">';
		
		if( joyas_shop_get_option('__dialogue') ) : 
			echo esc_html( joyas_shop_get_option('__dialogue') );
		endif;
		echo '</div><div class="right-menu"><div class="top-bar-menu">';

		wp_nav_menu( array(
			'theme_location'    => 'topbar',
			'depth'             => 2,
			'menu_class'  		=> 'menu',
			'menu_id'  			=> 'menu-store',
			'container'			=> 'ul',
			'fallback_cb'       => 'joyas_shop_navwalker::fallback_2',
		) );
		
		echo '</div>';

		echo '</div></div>
		</div>';
		endif;
		//echo wp_kses( $html , $this->alowed_tags() );
	}

endif;

if ( ! function_exists( 'joyas_decor_shop_woocommerce_wrapper_before' ) ) {
	/**
	 * Before Content.
	 *
	 * Wraps all WooCommerce content in wrappers which match the theme markup.
	 *
	 * @return void
	 */
	function joyas_decor_shop_woocommerce_wrapper_before() {
		/**
		* Hook - joyas_shop_container_wrap_start 	
		*
		* @hooked joyas_shop_container_wrap_start	- 5
		*/
		if( is_product() ){
		 do_action( 'joyas_shop_container_wrap_start', 'no-sidebar');
		}else{
		 do_action( 'joyas_shop_container_wrap_start', 'content-sidebar');
		}
	}
}
add_action( 'woocommerce_before_main_content', 'joyas_decor_shop_woocommerce_wrapper_before' );

if ( ! function_exists( 'joyas_decor_shop_woocommerce_wrapper_after' ) ) {
	/**
	 * After Content.
	 *
	 * Closes the wrapping divs.
	 *
	 * @return void
	 */
	function joyas_decor_shop_woocommerce_wrapper_after() {
		/**
		* Hook - joyas_shop_container_wrap_end	
		*
		* @hooked container_wrap_end - 999
		*/
		do_action( 'joyas_shop_container_wrap_end', 'content-sidebar');
	}
}
add_action( 'woocommerce_after_main_content', 'joyas_decor_shop_woocommerce_wrapper_after' );



add_filter( 'woocommerce_cross_sells_columns', 'joyas_decor_shop_change_cross_sells_columns',999 );
function joyas_decor_shop_change_cross_sells_columns( $columns ) {
	return 3;
}
/**
 * Default loop columns on product archives.
 *
 * @return integer products per row.
 */
function joyas_decor_shop_woocommerce_loop_columns() {
	return 3;
}
add_filter( 'loop_shop_columns', 'joyas_decor_shop_woocommerce_loop_columns',999 );


function joyas_decor_shop_search_modal() {

	echo '<div class="search-bar-modal" id="search-bar"><div class="modal-wrap">
	<button class="button appw-modal-close-button" type="button"><i class="bi bi-x-lg"></i></button>';
		if( class_exists('APSW_Product_Search_Finale_Class_Pro') && class_exists( 'WooCommerce' ) ){
			do_action('apsw_search_bar_preview');
		}else if( class_exists('APSW_Product_Search_Finale_Class') && class_exists( 'WooCommerce' ) ){
			do_action('apsw_search_bar_preview');
		}else{
			echo '<form role="search" method="get" id="searchform" class="search-form" action="' . home_url( '/' ) . '" >
			<input type="search" value="' . get_search_query() . '" name="s" id="s" placeholder="'.esc_html__('Search …','joyas-decor-shop').'" />
			<button type="submit" class="search-submit">'.esc_html__( 'Search', 'joyas-decor-shop' ).'</button>
			</form>';
		}
	echo'</div></div>';

}
add_filter( 'joyas_shop_site_footer', 'joyas_decor_shop_search_modal',999 );



function joyas_decor_shop_footer_info (){
    $text ='';
    $html = '<div class="container site_info">
                <div class="row">';
        $html .= '<div class="col-12 ">';
        
        if( get_theme_mod('copyright_text') != '' ) 
        {
            $text .= esc_html(  get_theme_mod('copyright_text') );
        }else
        {
            /* translators: 1: Current Year, 2: Blog Name  */
            $text .= sprintf( esc_html__( 'Copyright &copy; %1$s %2$s. All Right Reserved.', 'joyas-decor-shop' ), date_i18n( _x( 'Y', 'copyright date format', 'joyas-decor-shop' ) ), esc_html( get_bloginfo( 'name' ) ) );

        
            
        }

        
        $html  .= apply_filters( 'joyas_shop_footer_copywrite_filter', $text );
            
        /* translators: 1: developer website, 2: WordPress url  */
        $html  .= '<span class="dev_info">'.sprintf( esc_html__( ' %1$s theme by %2$s.', 'joyas-decor-shop' ), '<a href="'. esc_url( 'https://wordpress.org/themes/joyas-decor-shop/' ) .'" target="_blank">'.esc_html_x( 'Joyas Decor Shop', 'credit - theme', 'joyas-decor-shop' ).'</a>',  '<a  href="'.esc_url( __( 'https://athemeart.com', 'joyas-decor-shop' ) ).'" target="_blank" rel="nofollow">'.esc_html_x( 'aThemeArt', 'credit to developer', 'joyas-decor-shop' ).'</a>' ).'</span>';
        
        $html .= '</div>';
        
        
        
        
    $html .= '  </div>
            </div>';
    
    
            
    echo wp_kses( $html, joyas_shop_alowed_tags() );

}
add_action('joyas_shop_site_footer', 'joyas_decor_shop_footer_info', 30 );