<?php
/**
 * Template part for displaying results in search pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Journal_Blog
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="journal-entry ">

		<?php if( has_post_thumbnail() ){?>
				<img src="<?php the_post_thumbnail_url('journal-featured'); ?>" alt="<?php the_title(); ?>">
			<?php } else { ?>
					<img src="<?php echo esc_url(JOURNAL_DIRECTORY_URI); ?>/assets/images/project-2.jpg" alt="<?php the_title(); ?>">
		<?php }?>


		<div>
			<?php if ( 'post' === get_post_type() ) : ?>
				<span class="journal-post-date">
					<?php the_date(); ?>
				</span><!-- .entry-meta -->
			<?php
			endif; ?>

			<?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );?>
			<p><?php the_excerpt(); ?></p>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->


