<?php
/**
 * Journal Blog Theme Customizer.
 *
 * @package Journal Blog
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

function journal_blog_customizer( $wp_customize ) {
class WP_Pro_Customize_Control extends WP_Customize_Control {
    public $type = 'new_menu';
    /**
    * Render the control's content.
    */
    public function render_content() {
    ?>
    <div style="border-bottom: 1px solid #ddd;">

	<div class="lite-box" style="text-align:center">
		<a class="button" id="rate-theme" style="margin: 20px auto;" href="<?php echo esc_url('https://wordpress.org/support/theme/journal-blog/reviews/#postform'); ?>" class="button" target="_blank"><?php esc_html_e('RATE THIS THEME','journal-blog');?>
	</a>

		<a id="docs-theme" style="margin: 20px 10px 0px;" href="<?php echo esc_url('http://wpthemestutorial.com/');?>" class="button" target="_blank"><?php esc_html_e('GET SUPPORT','journal-blog');?></a>
	</div>

	
	<div style="text-align:center">
		<?php _e('<div class="support-box">
		<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
			<input type="hidden" name="cmd" value="_s-xclick">
			<input type="hidden" name="hosted_button_id" value="6BWRCXKT5MDQG">
			<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online!">
			<img alt="" border="0" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif" width="1" height="1">
			</form>
		</div>', 'journal-blog'); ?>
	</div>

	</div>
	 <div class="pro-vesrion">
	 <?php esc_html_e('Your review on WordPress.org will highly be appreciated as it encourages us to keep updating and supporting this Theme.','journal-blog');?>
	 </div>
    <?php
    }
}
$wp_customize->add_section( 'journal_blog_section' , array(
		'title'      => __('SUPPORT', 'journal-blog'),
		'priority'   => 1,
   	) );

$wp_customize->add_setting(
    'journal_blog_support',
    array(
        'default' => '',
		'capability'     => 'edit_theme_options',
		'sanitize_callback' => 'sanitize_text_field',
    )	
);
$wp_customize->add_control( new WP_Pro_Customize_Control( 
	$wp_customize, 
		'journal_blog_support', array(
		'label' => __('Discover Journal Blog','journal-blog'),
        'section' => 'journal_blog_section',
		'setting' => 'journal_blog_support',
    ))
);

}
add_action( 'customize_register', 'journal_blog_customizer' );


//Loading Customizer Styles
function journal_blog_customizer_inline_css() {
?>
	<style type="text/css">
		li#accordion-section-journal_blog_section > h3.accordion-section-title:before
		{
			content: "\f111";
			font-family: dashicons;
			padding: 3px;
		}
		#demo-theme {
		  background: #008EC2;
		  border-color: #0085BA #0085BA #0085BA;
		  color: #ffffff;
		  -webkit-box-shadow: 0 1px 0 #006799;
		  box-shadow: 0 1px 0 #006799;
		  text-shadow: 0 -1px 1px #006799, -1px 0 1px #006799, 0 1px 1px #006799, 1px 0 1px #0085BA;
		}
		#docs-theme {
		  background: #008EC2;
		  border-color: #0085BA #0085BA #0085BA;
		  color: #ffffff;
		  -webkit-box-shadow: 0 1px 0 #006799;
		  box-shadow: 0 1px 0 #006799;
		  text-shadow: 0 -1px 1px #006799, -1px 0 1px #006799, 0 1px 1px #006799, 1px 0 1px #006799;
		}
		#rate-theme {
		  background: #038764;
		  border-color: #037758 #015238 #015238;
		  color: #ffffff;
		  -webkit-box-shadow: 0 1px 0 #015238;
		  box-shadow: 0 1px 0 #015238;
		  text-shadow: 0 -1px 1px #015238, -1px 0 1px #015238, 0 1px 1px #015238, 1px 0 1px #015238;
		}

	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'journal_blog_customizer_inline_css' );



?>