<?php
/**
 * Customizer Theme Options Fields
 *
 * @link http://wpthemestutorial.com
 *
 * @package Journal Blog
 */

function journal_blog_customizers_options( $config ) {
    return wp_parse_args( array(
        'logo_image'   => JOURNAL_DIRECTORY_URI .'/inc/images/wpthemestutorial.png',
        'color_accent' => '#016489',
        'color_back'   => '#FFFFFF',
    ), $config );
}
add_filter( 'kirki/config', 'journal_blog_customizers_options' );

WPThemes_Customizer::add_config( 
    'journal-blog', 
        array(
        	'capability'  => 'edit_theme_options',
        	'option_type' => 'theme_mod',
) );

/** General Settings **/
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'radio-buttonset',
            'settings'    => 'journal_blog_sidebar_display',
            'label'       => __( 'Sidebar Option', 'journal-blog' ),
            'description' => esc_html__( 'Show or hide the sidebar on posts ', 'journal-blog' ),
            'section'     => 'journal_blog_general_section',
            'default'     => 'show',
            'priority'    => 10,
            'choices'     => array(
                'show' => esc_html__( 'Show Sidebar', 'journal-blog' ),
                'hide' => esc_html__( 'Hide Sidebar', 'journal-blog' ),              
            ),
) );

/** Typography**/
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'typography',
            'settings'    => 'journal_blog_title_typography',
            'label'       => esc_html__( 'Titles Font', 'journal-blog' ),
            'description' => esc_html__( 'Select the font family for the posts and header titles', 'journal-blog' ),
            'section'     => 'journal_blog_typography_section',
            'default'     => array(
                'font-family'    => 'Work Sans',
                'variant'        => '500',
                'font-size'      => '30px',
                //'color'          => '#212121',
                'text-transform' => 'none',
            ),
            'priority'    => 10,
            'output'      => array(
                array(
                    'element'  => 'h1, h2, h3, h4, h5, h6',
                    'property' => 'font-family',
                ),
            ),
          
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'typography',
            'settings'    => 'journal_blog_body_typography',
            'label'       => esc_html__( 'Body Font', 'journal-blog' ),
            'description' => esc_html__( 'Select the font settings for the body', 'journal-blog' ),
            'section'     => 'journal_blog_typography_section',
            'default'     => array(
                'font-family'    => 'Work Sans',
                'variant'        => '400',
                'font-size'      => '16px',
                'color'          => '#828282',
                'text-transform' => 'none',
            ),
            'priority'    => 10,          
) );



/*--- Social Media */
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_facebook',
            'label'       => esc_html__( 'Facebook', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Facebook page/profile URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_twitter',
            'label'       => esc_html__( 'Twitter', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Twitter page URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_gplus',
            'label'       => esc_html__( 'Google Plus', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Google Plus profile URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_youtube',
            'label'       => esc_html__( 'YourTube', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your YourTube channel URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_instagram',
            'label'       => esc_html__( 'Instagram', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Instagram page URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_pinterest',
            'label'       => esc_html__( 'Pinterest', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Pinterest page URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_social_rssfeed',
            'label'       => esc_html__( 'RSS Feed', 'journal-blog' ),
            'description' => esc_html__( 'Enter website RSS Feed page URL', 'journal-blog' ),
            'section'     => 'journal_blog_social_media',
            'priority'    => 10,
) );


/** Theme Color **/
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'color',
            'settings'    => 'header_textcolor',
            'label'       => esc_html__( 'Header Color', 'journal-blog' ),
            'description' => esc_html__( 'Select Header Color for site title text and site description', 'journal-blog' ),
            'section'     => 'colors',
            'default'     => 'ffffff',
            'priority'    => 10,
            'choices'     => array(
                'alpha' => true,
            ),
            
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'color',
            'settings'    => 'journal_blog_default_color',
            'label'       => esc_html__( 'Main Color', 'journal-blog' ),
            'description' => esc_html__( 'Select main site hover color for titles', 'journal-blog' ),
            'section'     => 'colors',
            'default'     => 'FC5185',
            'priority'    => 10,
            'choices'     => array(
                'alpha' => true,
            ),
            
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'color',
            'settings'    => 'background_color',
            'label'       => esc_html__( 'Background Color', 'journal-blog' ),
            'description' => esc_html__( 'Note: when you upload background image, this color will not take effect', 'journal-blog' ),
            'section'     => 'colors',
            'default'     => '',
            'priority'    => 10,
            'choices'     => array(
                'alpha' => true,
            ),
            
) );

WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'color',
            'settings'    => 'journal_blog_button_colors',
            'label'       => esc_html__( 'Button Color', 'journal-blog' ),
            'description' => esc_html__( 'Select color for the buttons in the comments form and contact forms', 'journal-blog' ),
            'section'     => 'colors',
            'default'     => 'FC5185',
            'priority'    => 10,
            'choices'     => array(
                'alpha' => true,
            ),
            
) );
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'color',
            'settings'    => 'journal_blog_button_hover_colors',
            'label'       => esc_html__( 'Button Hover Color', 'journal-blog' ),
            'description' => esc_html__( 'Select color for the button hover', 'journal-blog' ),
            'section'     => 'colors',
            'default'     => 'EA396E',
            'priority'    => 10,
            'choices'     => array(
                'alpha' => true,
            ),
            
) );

/** Footer **/
//Copyright
WPThemes_Customizer::add_field( 
    'journal-blog', 
        array(
            'type'        => 'text',
            'settings'    => 'journal_blog_footer_copyright',
            'label'       => esc_html__( 'Copyright', 'journal-blog' ),
            'description' => esc_html__( 'Enter Your Copyright info', 'journal-blog' ),
            'section'     => 'journal_blog_footer_section',
            'priority'    => 10,
) );


/** Footer End **/



function journal_blog_wp3_customize_css() {

    $header_text_color = get_header_textcolor();
    $bg_color       = get_theme_mod('background_color','');
    $default_color  = get_theme_mod('journal_blog_default_color','#FC5185');
    $btn_color      = get_theme_mod('journal_blog_button_colors','#FC5185');
    $btn_hv_color   = get_theme_mod('journal_blog_button_hover_colors','#EA396E');
    $body_font      = get_theme_mod( 'journal_blog_body_typography', array() );

    ?>
    <style type="text/css">
    <?php if ( isset( $body_font['font-family'] ) ) {?>
        body {font-family: <?php echo esc_attr($body_font['font-family']); ?>}
    <?php }  ?>
    <?php if ( isset( $body_font['font-size'] ) ) { ?>
       body {font-size: <?php echo esc_attr($body_font['font-size']); ?>}
    <?php } ?>
    <?php if ( isset( $body_font['color'] ) ) { ?>
       body {color: <?php echo esc_attr($body_font['color']); ?>}
    <?php } ?>
    <?php if ( isset( $body_font['text-transform'] ) ) { ?>
       body {text-transform: <?php echo esc_attr($body_font['text-transform']); ?>}
    <?php } ?>
    <?php if ( isset( $body_font['variant'] ) ) { ?>
       body {font-weight: <?php echo esc_attr($body_font['variant']); ?>}
    <?php } ?>
    <?php if ( isset( $bg_color ) ) { ?>
        body{ background: <?php echo esc_attr($bg_color); ?>;}
    <?php } ?>
    <?php if ( isset( $header_text_color ) ) { ?>
        .site-title,.site-description,#journal-aside .featured h2 {color: <?php echo esc_attr($header_text_color); ?>;}
    <?php } ?>

    <?php if ( isset( $default_color ) ) { ?>
        a, a:hover, a:active, a:focus,.journal-post .journal-entry > div a:hover {color: <?php echo esc_attr($default_color); ?>; }

        input[type="search"]:focus,input[type="text"]:focus,input[type="email"]:focus,input[type="url"]:focus,input[type="password"]:focus,select:focus,textarea:focus {border: solid 2px <?php echo esc_attr($default_color); ?>; }
   
        .header a:after {border-bottom: 2px solid <?php echo esc_attr($default_color); ?>; }
        .main-navigation li.current-menu-item > a,.main-navigation li.current_page_item > a,.main-navigation li.current-menu-parent > a,.main-navigation li.current_page_parent > a,.main-navigation li.current-menu-ancestor > a,.main-navigation li.current_page_ancestor > a {
              color: <?php echo esc_attr($default_color); ?>!important; }
        .social a:hover{ background: <?php echo esc_attr($default_color); ?>; }
        ::selection{ background: <?php echo esc_attr($default_color); ?>; }
        ::-moz-selection{ background: <?php echo esc_attr($default_color); ?>; }
        ::-webkit-selection{ background: <?php echo esc_attr($default_color); ?>; }
        blockquote {border-left: 5px solid <?php echo esc_attr($default_color); ?>;}
    <?php } ?> 

    <?php if ( isset( $btn_color ) ) { ?>
        input[type="button"],input[type="submit"],input[type="reset"],button{background: <?php echo esc_attr($btn_color); ?>;}
    <?php } ?>
    <?php if ( isset( $btn_hv_color ) ) { ?>
        input[type="button"]:hover,input[type="submit"]:hover,input[type="reset"]:hover,button:hover,input[type="button"]:active,input[type="submit"]:active,input[type="reset"]:active,button:active,.search-overlay button:hover{background: <?php echo esc_attr($btn_hv_color); ?>;}
    <?php } ?>
    </style>

    <?php

}
add_action( 'wp_head', 'journal_blog_wp3_customize_css');

