<?php
/**
 * Journal Blog Scripts
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Journal_Blog
 */


/**
 * Enqueue scripts and styles.
 */
function journal_blog_scripts() {

	wp_enqueue_style( 'journal-blog-style', get_stylesheet_uri() );

	wp_enqueue_style( 'work-sans', '//fonts.googleapis.com/css?family=Work+Sans:300,400,500,700,800' );
	wp_enqueue_style( 'animate', JOURNAL_DIRECTORY_URI . '/assets/css/animate.css' );
	wp_enqueue_style( 'font-awesome', JOURNAL_DIRECTORY_URI .'/font-awesome/css/font-awesome.css' );
	wp_enqueue_style( 'bootstrap', JOURNAL_DIRECTORY_URI . '/assets/css/bootstrap.css' );
	wp_enqueue_style( 'journal-menu', JOURNAL_DIRECTORY_URI . '/assets/css/menu.css' );

	wp_enqueue_style( 'journal-style', JOURNAL_DIRECTORY_URI . '/assets/css/style.css' );

	wp_enqueue_script( 'bootstrap-min', JOURNAL_DIRECTORY_URI . '/assets/js/bootstrap.min.js', array(), '', true );
	wp_enqueue_script( 'jquery-easing', JOURNAL_DIRECTORY_URI . '/assets/js/jquery.easing.1.3.js', array(), '', true );
	wp_enqueue_script( 'jquery-stellar', JOURNAL_DIRECTORY_URI . '/assets/js/jquery.stellar.min.js', array(), '', true );
	wp_enqueue_script( 'jquery-waypoints', JOURNAL_DIRECTORY_URI . '/assets/js/jquery.waypoints.min.js', array(), '', true );
	wp_enqueue_script( 'modernizr', JOURNAL_DIRECTORY_URI . '/assets/js/modernizr-2.6.2.min.js', array(), '', true );


	wp_enqueue_script( 'main', JOURNAL_DIRECTORY_URI . '/assets/js/main.js', array('jquery'), '', true );

	wp_enqueue_script( 'journal-blog-navigation', JOURNAL_DIRECTORY_URI . '/assets/js/navigation.js', array(), '20151215', true );

	wp_enqueue_script( 'journal-blog-skip-link-focus-fix', JOURNAL_DIRECTORY_URI . '/assets/js/skip-link-focus-fix.js', array(), '20151215', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'journal_blog_scripts' );


?>