<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Journal Blog
 */

$header_url = get_header_image();

if ( $header_url != '' ){
	$header_img = get_header_image() ;
} else { 
	$header_img = JOURNAL_DIRECTORY_URI . '/assets/images/girl-2907463_1920.jpg' ;
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	
		<?php
			wp_body_open();
		?>
	<div class="journal-loader"></div>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'journal-blog' ); ?></a>

		<div id="journal-aside" style="background-image: url(<?php echo esc_url($header_img); ?>)">

			<div class="overlay"></div>

			<?php if( has_custom_logo() ){ ?>
				<div class="img-logo">
					<?php the_custom_logo(); ?>
				</div>
			<?php } else { ?>
				<h1 class="site-title">
					<?php bloginfo( 'name' );?>
				</h1>
			<?php } ?>
			<!-- Mobile Bar & Menu Icon -->
			<input type="checkbox" class="menu-toggle" id="menu-toggle">
			<div class="mobile-bar">
				<label for="menu-toggle" class="menu-icon">
					<span></span>
				</label>
			</div>
			
			<!-- Header -->
			<header class="header">
				<nav class="main-navigation">
					<?php
						wp_nav_menu( array(
							'theme_location' => 'menu-1',
							'menu_id'        => 'primary-menu',
						) );
					?>
				</nav>
			</header>

			<div class="featured site-description text-center">
				<?php	$description = get_bloginfo( 'description', 'display' );
					if ( $description || is_customize_preview() ) : ?>
					<h2><?php echo $description; /* WPCS: xss ok. */ ?></h2>
				<?php endif; ?>
				<?php do_action('journal_blog_social_links');?>
			</div>


		</div>

	

	<div id="journal-main-content" class="site-content">
		<div class="journal-post"> 
