<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Journal_Blog
 */


?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class('single'); ?>>

	<div class="journal-loader"></div>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'journal-blog' ); ?></a>

		<div id="journal-aside" style="background-image: url(<?php the_post_thumbnail_url(); ?>)">

			<div class="overlay"></div>
			<!-- Mobile Bar & Menu Icon -->
			<input type="checkbox" class="menu-toggle" id="menu-toggle">
			<div class="mobile-bar">
				<label for="menu-toggle" class="menu-icon">
					<span></span>
				</label>
			</div>
			
			<!-- Header -->
			<header class="header">
				<nav class="main-navigation">
					<?php
							wp_nav_menu( array(
								'theme_location' => 'menu-1',
								'menu_id'        => 'primary-menu',
							) );
						?>
				</nav>
			</header>

				<div class="page-title">
					<?php if ( 'post' === get_post_type() ) : ?>
						<span><?php echo esc_html( get_the_date() ) ; ?></span>
					<?php
					endif; ?>
					<?php the_title( '<h2 class="entry-title">', '</h2>' );?>
				</div>


		</div>

	

	<div id="journal-main-content" class="site-content">
		<div class="journal-post"> 
