<?php
/**
 * Journal Blog functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Journal Blog
 */


define ('JOURNAL_DIRECTORY_URI', get_template_directory_uri() );
define ('JOURNAL_DIRECTORY', get_template_directory() );
define ('JOURNAL_FUNCTIONS_DIRECTORY', JOURNAL_DIRECTORY . '/inc' );


/**
 * Customizer additions.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/theme-options/kirki-fallback.php';
require JOURNAL_FUNCTIONS_DIRECTORY . '/theme-options/panels.php';
require JOURNAL_FUNCTIONS_DIRECTORY . '/theme-options/sections.php';
require JOURNAL_FUNCTIONS_DIRECTORY . '/theme-options/fields.php';
require JOURNAL_FUNCTIONS_DIRECTORY . '/theme-options/support.php';

/**
 * Include recommended plugins.
 */
include( JOURNAL_FUNCTIONS_DIRECTORY . '/tgm/tgm-init.php' );


/**
 * Implement the Custom Header feature.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/custom-header.php';


/**
 * Implement the theme functions.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/functions.php';

/**
 * Implement the theme scripts.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/scripts.php';

/**
 * Custom template tags for this theme.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/template-tags.php';

/**
 * Additional features to allow styling of the templates.
 */
require JOURNAL_FUNCTIONS_DIRECTORY . '/template-functions.php';


/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require JOURNAL_FUNCTIONS_DIRECTORY . '/jetpack.php';
}


/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require JOURNAL_FUNCTIONS_DIRECTORY . '/woocommerce.php';
}


/**
 * Customizer additions.
 */

require JOURNAL_FUNCTIONS_DIRECTORY . '/customizer.php';



