<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Journal Blog
 */

?>	

		<footer id="colophon" class="site-footer">
			<div class="site-info">
				<?php if( get_theme_mod('journal_blog_footer_copyright','') != '' ){ printf( esc_attr__( '%s ', 'journal-blog' ), get_theme_mod('journal_blog_footer_copyright') ); } else { ?>
                        <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'journal-blog' ) ); ?>">
	                        <?php
								/* translators: %s: CMS name, i.e. WordPress. */
								printf( esc_html__( 'Proudly powered by %s', 'journal-blog' ), 'WordPress' );
							?>			
						</a>
						<?php } ?>
				<span class="sep"> | </span>
				<?php
					/* translators: 1: Theme name, 2: Theme author. */
					printf( esc_html__( 'Theme: %1$s by %2$s.', 'journal-blog' ), '<a href="https://answerbox.net/journal-blog-responsive-and-journalistic-wordpress-theme/" target="_blank"> Journal Blog </a>', '<a href="https://answerbox.net/" target="_blank">AnswerBox</a>' );
				?>
			</div><!-- .site-info -->
		</footer><!-- #colophon -->

		</div> <!-- #journal-post -->
	</div><!-- #main-content -->
</div><!-- #page -->

<div class="gototop js-top">
		<a href="#" class="js-gotop"><i class="fa fa-arrow-up" aria-hidden="true"></i></a>
</div>

<?php wp_footer(); ?>

</body>
</html>
