<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Journal_Blog
 */

$prevThumb = get_the_post_thumbnail_url( get_previous_post(), 'journal-featured' );
$nextThumb = get_the_post_thumbnail_url( get_next_post(), 'journal-featured' );

$previous_link_url = get_permalink( get_previous_post() );
$next_link_url = get_permalink( get_next_post() );

?>

		</div> <!-- #journal-post -->
	</div><!-- #main-content -->
</div><!-- #page -->

		<div class="journal-navigation">
			<div class="journal-cover prev journal-cover-sm" style="background-image: url(<?php if(!empty($prevThumb)){ echo esc_url($prevThumb); } else { echo esc_url(JOURNAL_DIRECTORY_URI) . '/assets/images/prev.jpg'; } ?>)">
				<div class="overlay"></div>

				<a class="copy" href="<?php echo esc_url($previous_link_url);  ?>">
					<div class="display-t">
						<div class="display-tc">
							<div>
								<span><?php esc_html_e( 'Previous Post', 'journal-blog' ) ?></span>
								<h2><?php printf( esc_html__( '%s ', 'journal-blog' ), get_the_title( get_previous_post() ) );?> </h2>
							</div>
						</div>
					</div>
				</a>

			</div>

			<div class="journal-cover next journal-cover-sm" style="background-image: url(<?php if(!empty($nextThumb)){ echo esc_url($nextThumb); } else { echo esc_url(JOURNAL_DIRECTORY_URI) . '/assets/images/next.jpg'; } ?>)">
				<div class="overlay"></div>
				
				<a class="copy" href="<?php echo esc_url($next_link_url);  ?>">
					<div class="display-t">
						<div class="display-tc">
							<div>
								<span><?php esc_html_e( 'Next Post', 'journal-blog' ); ?></span>
								<h2><?php printf( esc_html__( '%s ', 'journal-blog' ), get_the_title( get_next_post() ) ); ?></h2>
							</div>
						</div>
					</div>
				</a>
				
			</div>
		</div><!-- .journal-navigation -->

		<footer id="colophon" class="site-footer">
			<div class="site-info">
				<?php if( get_theme_mod('journal_blog_footer_copyright','') != '' ){ printf( esc_attr__( '%s ', 'journal-blog' ), get_theme_mod('journal_blog_footer_copyright') ); } else { ?>
                        <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'journal-blog' ) ); ?>">
	                        <?php
								/* translators: %s: CMS name, i.e. WordPress. */
								printf( esc_html__( 'Proudly powered by %s', 'journal-blog' ), 'WordPress' );
							?>			
						</a>
						<?php } ?>
				<span class="sep"> | </span>
				<?php
					/* translators: 1: Theme name, 2: Theme author. */
					printf( esc_html__( 'Theme: %1$s by %2$s.', 'journal-blog' ), '<a href="https://answerbox.net/journal-blog-responsive-and-journalistic-wordpress-theme/" target="_blank"> Journal Blog </a>', '<a href="https://answerbox.net/" target="_blank">AnswerBox</a>' );
				?>
			</div><!-- .site-info -->
		</footer><!-- #colophon -->

		<div class="gototop js-top">
			<a href="#" class="js-gotop"><i class="fa fa-arrow-up" aria-hidden="true"></i></a>
		</div>

<?php wp_footer(); ?>

</body>
</html>
