<?php
/**
 * @package jokkmokk
 */
?>


<?php // Styling Tip! 

// Want to wrap for example the post content in blog listings with a thin outline in Bootstrap style?
// Just add the class "panel" to the article tag here that starts below. 
// Simply replace post_class() with post_class('panel') and check your site!   
// Remember to do this for all content templates you want to have this, 
// for example content-single.php for the post single view. ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="page-header">
		<h1 class="page-title"><a href="<?php the_permalink(); ?>" rel="bookmark"><?php the_title(); ?></a></h1>

		<?php if ( 'post' == get_post_type() ) : ?>
		<div class="entry-meta">
			<?php jokkmokk_posted_on(); ?>
		</div>
		<?php endif; ?>
	</header>

	<?php if ( is_search() || is_archive() ) : ?>
	<div class="entry-summary">
		<?php the_excerpt(); ?>
	</div>
	<?php else : ?>
	<div class="entry-content">
		<?php the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'jokkmokk' ) ); ?>
		<?php
			wp_link_pages( array(
				'before' => '<div class="page-links">' . __( 'Pages:', 'jokkmokk' ),
				'after'  => '</div>',
			) );
		?>
	</div>
	<?php endif; ?>

	<footer class="entry-meta">
		<?php if ( 'post' == get_post_type() ) : ?>
			<?php
				$categories_list = get_the_category_list( __( ', ', 'jokkmokk' ) );
				if ( $categories_list && jokkmokk_categorized_blog() ) :
			?>
			<p class="cat-links">
				<?php printf( __( 'Posted in %1$s', 'jokkmokk' ), $categories_list ); ?>
			</p>
			<?php endif; ?>

			<?php
				$tags_list = get_the_tag_list( '', __( ', ', 'jokkmokk' ) );
				if ( $tags_list ) :
			?>
			<p class="tags-links">
				<?php printf( __( 'Tagged %1$s', 'jokkmokk' ), $tags_list ); ?>
			</p>
			<?php endif; ?>
		<?php endif; ?>

		<?php if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
		<p class="comments-link"><?php comments_popup_link( __( 'Leave a comment', 'jokkmokk' ), __( '1 Comment', 'jokkmokk' ), __( '% Comments', 'jokkmokk' ) ); ?></p>
		<?php endif; ?>

		<?php edit_post_link( __( 'Edit', 'jokkmokk' ), '<p class="edit-link">', '</p>' ); ?>
	</footer>
</article>
