<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package jokkmokk
 */

get_header(); ?>

	<div class="content-padder">
		
		<?php if ( have_posts() ) : ?>
	
			<header class="page-header">
				<h1 class="page-title">
					<?php
						if ( is_category() ) :
							single_cat_title();
	
						elseif ( is_tag() ) :
							single_tag_title();
	
						elseif ( is_author() ) :
							the_post();
							printf( __( 'Author: %s', 'jokkmokk' ), '<span class="vcard">' . get_the_author() . '</span>' );
							rewind_posts();
	
						elseif ( is_day() ) :
							printf( __( 'Day: %s', 'jokkmokk' ), '<span>' . get_the_date() . '</span>' );
	
						elseif ( is_month() ) :
							printf( __( 'Month: %s', 'jokkmokk' ), '<span>' . get_the_date( 'F Y' ) . '</span>' );
	
						elseif ( is_year() ) :
							printf( __( 'Year: %s', 'jokkmokk' ), '<span>' . get_the_date( 'Y' ) . '</span>' );
	
						elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
							_e( 'Asides', 'jokkmokk' );
	
						elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
							_e( 'Images', 'jokkmokk');
	
						elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
							_e( 'Videos', 'jokkmokk' );
	
						elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
							_e( 'Quotes', 'jokkmokk' );
	
						elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
							_e( 'Links', 'jokkmokk' );
	
						else :
							_e( 'Archives', 'jokkmokk' );
	
						endif;
					?>
				</h1>
				<?php
					$term_description = term_description();
					if ( ! empty( $term_description ) ) :
						printf( '<div class="taxonomy-description">%s</div>', $term_description );
					endif;
				?>
			</header>
	
			<?php while ( have_posts() ) : the_post(); ?>
	
				<?php
					get_template_part( 'content', get_post_format() );
				?>
	
			<?php endwhile; ?>
	
			<?php jokkmokk_content_nav( 'nav-below' ); ?>
	
		<?php else : ?>
	
			<?php get_template_part( 'no-results', 'archive' ); ?>
	
		<?php endif; ?>
	
	</div>
			
<?php get_sidebar(); ?>
<?php get_footer(); ?>
