<?php

/**
 * Title: Homepage Template Default
 * Slug: jetnews-magazine/template-frontpage
 * Categories: jetnews-magazine-home
 */
$jetnews_magazine_url = trailingslashit(get_template_directory_uri());
$jetnews_magazine_images = array(
    $jetnews_magazine_url . 'assets/images/main_bg.jpg',
    $jetnews_magazine_url . 'assets/images/trending_icon.png',
    $jetnews_magazine_url . 'assets/images/bottom_ads.png',
);
?>
<!-- wp:cover {"url":"<?php echo esc_url($jetnews_magazine_images[0]) ?>","id":3034,"hasParallax":true,"dimRatio":20,"overlayColor":"dark-color","isUserOverlayColor":true,"className":"newsork-magazine-cover-fixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|foreground"}}},"spacing":{"blockGap":"0","padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"},"margin":{"top":"0px"}}},"textColor":"foreground","layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-cover has-parallax newsork-magazine-cover-fixed has-foreground-color has-text-color has-link-color" style="margin-top:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><span aria-hidden="true" class="wp-block-cover__background has-dark-color-background-color has-background-dim-20 has-background-dim"></span>
    <div class="wp-block-cover__image-background wp-image-3034 has-parallax" style="background-position:50% 50%;background-image:url(<?php echo esc_url($jetnews_magazine_images[0]) ?>)"></div>
    <div class="wp-block-cover__inner-container"><!-- wp:template-part {"slug":"header","theme":"jetnews-magazine"} /-->

        <!-- wp:group {"tagName":"main","metadata":{"name":"Main Content"},"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"0","bottom":"0","left":"0","right":"0"}}},"layout":{"type":"constrained","contentSize":"1240px"}} -->
        <main class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"metadata":{"name":"Breaking News"},"className":"is-style-default","style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"10px","bottom":"7px","left":"28px","right":"28px"}},"border":{"bottom":{"style":"none","width":"0px"}}},"backgroundColor":"light-color","layout":{"type":"constrained","contentSize":"100%"}} -->
            <div class="wp-block-group is-style-default has-light-color-background-color has-background" style="border-bottom-style:none;border-bottom-width:0px;margin-top:0;margin-bottom:0;padding-top:10px;padding-right:28px;padding-bottom:7px;padding-left:28px"><!-- wp:columns {"verticalAlignment":"center","style":{"border":{"bottom":{"color":"var:preset|color|border-color","width":"2px"}},"spacing":{"padding":{"bottom":"10px"},"margin":{"top":"0","bottom":"0"}}}} -->
                <div class="wp-block-columns are-vertically-aligned-center" style="border-bottom-color:var(--wp--preset--color--border-color);border-bottom-width:2px;margin-top:0;margin-bottom:0;padding-bottom:10px"><!-- wp:column {"verticalAlignment":"center","width":"200px"} -->
                    <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:200px"><!-- wp:group {"style":{"spacing":{"blockGap":"10px"},"border":{"bottom":{"width":"0px","style":"none"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                        <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px"><!-- wp:image {"id":35,"width":"35px","height":"auto","aspectRatio":"1","scale":"contain","sizeSlug":"full","linkDestination":"none","style":{"color":{"duotone":"var:preset|duotone|white-primary"}}} -->
                            <figure class="wp-block-image size-full is-resized"><img src="<?php echo esc_url($jetnews_magazine_images[1]) ?>" alt="" class="wp-image-35" style="aspect-ratio:1;object-fit:contain;width:35px;height:auto" /></figure>
                            <!-- /wp:image -->

                            <!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600","fontSize":"18px"}},"textColor":"heading-color"} -->
                            <h4 class="wp-block-heading has-heading-color-color has-text-color has-link-color" style="font-size:18px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Breaking News', 'jetnews-magazine') ?></h4>
                            <!-- /wp:heading -->
                        </div>
                        <!-- /wp:group -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column {"verticalAlignment":"center","width":""} -->
                    <div class="wp-block-column is-vertically-aligned-center"><!-- wp:query {"queryId":18,"query":{"perPage":"7","pages":0,"offset":0,"postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false},"className":"newswokmarquee-wrapper"} -->
                        <div class="wp-block-query newswokmarquee-wrapper"><!-- wp:post-template {"className":"newswokmarquee-content","layout":{"type":"default"}} -->
                            <!-- wp:group {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                            <div class="wp-block-group"><!-- wp:post-featured-image {"isLink":true,"width":"48px","height":"48px","style":{"border":{"radius":"60%"}}} /-->

                                <!-- wp:post-title {"level":4,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"fontSize":"18px","fontStyle":"normal","fontWeight":"500","textTransform":"none"}}} /-->
                            </div>
                            <!-- /wp:group -->
                            <!-- /wp:post-template -->
                        </div>
                        <!-- /wp:query -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"metadata":{"name":"Content with Sidebar"},"style":{"spacing":{"padding":{"right":"28px","left":"28px","top":"20px","bottom":"20px"},"margin":{"top":"0","bottom":"0"}}},"backgroundColor":"background","layout":{"type":"constrained","contentSize":"100%"}} -->
            <div class="wp-block-group has-background-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:20px;padding-right:28px;padding-bottom:20px;padding-left:28px"><!-- wp:columns -->
                <div class="wp-block-columns"><!-- wp:column {"width":""} -->
                    <div class="wp-block-column"><!-- wp:group {"metadata":{"name":"Featured Banner"},"style":{"spacing":{"padding":{"right":"0","left":"0","top":"0px","bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"100%"}} -->
                        <div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0;padding-bottom:0px;padding-left:0"><!-- wp:query {"queryId":23,"query":{"perPage":"7","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false},"className":"jetnewsmagazine-featured-slider"} -->
                            <div class="wp-block-query jetnewsmagazine-featured-slider"><!-- wp:post-template {"className":"jetnewsmagazine-swiper-holder","style":{"spacing":{"blockGap":"32px"}},"layout":{"type":"default","columnCount":3}} -->
                                <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-jetnews-magazine-boxshadow-medium","style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"radius":"0px","width":"0px","style":"none"}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-jetnews-magazine-boxshadow-medium has-light-color-background-color has-background" style="border-style:none;border-width:0px;border-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:cover {"useFeaturedImage":true,"isUserOverlayColor":true,"minHeight":500,"gradient":"primary-gradient","contentPosition":"bottom left","className":"is-style-jetnews-magazine-cover-hover-zoom","style":{"spacing":{"padding":{"top":"20px","bottom":"20px","left":"24px","right":"24px"}},"border":{"width":"0px","style":"none"}},"layout":{"type":"constrained"}} -->
                                    <div class="wp-block-cover has-custom-content-position is-position-bottom-left is-style-jetnews-magazine-cover-hover-zoom" style="border-style:none;border-width:0px;padding-top:20px;padding-right:24px;padding-bottom:20px;padding-left:24px;min-height:500px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-primary-gradient-gradient-background"></span>
                                        <div class="wp-block-cover__inner-container"><!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
                                            <div class="wp-block-group is-style-default" style="margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-terms {"term":"category","className":"is-style-categories-background-with-mixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"},":hover":{"color":{"text":"var:preset|color|background"}}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"}},"textColor":"light-color","fontSize":"x-small"} /--></div>
                                                <!-- /wp:group -->

                                                <!-- wp:post-title {"level":4,"isLink":true,"className":"is-style-default","style":{"elements":{"link":{":hover":{"color":{"text":"var:preset|color|primary"}},"color":{"text":"var:preset|color|light-color"}}},"typography":{"lineHeight":"1.3","textTransform":"none","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"large"} /-->

                                                <!-- wp:post-excerpt {"excerptLength":25} /-->

                                                <!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-author-name {"className":"is-style-author-name-with-white-icon"} /-->

                                                    <!-- wp:post-date {"className":"is-style-post-date-with-white-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"small"} /-->
                                                </div>
                                                <!-- /wp:group -->
                                            </div>
                                            <!-- /wp:group -->
                                        </div>
                                    </div>
                                    <!-- /wp:cover -->
                                </div>
                                <!-- /wp:group -->
                                <!-- /wp:post-template -->

                                <!-- wp:group {"metadata":{"name":"Slider Controls"},"className":"jetnews-magazine-slider-controls","style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
                                <div class="wp-block-group jetnews-magazine-slider-controls" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:html -->
                                    <div class="jetnewsmagazine-button-prev swiper-button-prev"></div>
                                    <div class="jetnewsmagazine-button-next swiper-button-next"></div>
                                    <div class="jetnewsmagazine-pagination"></div>
                                    <!-- /wp:html -->
                                </div>
                                <!-- /wp:group -->
                            </div>
                            <!-- /wp:query -->
                        </div>
                        <!-- /wp:group -->

                        <!-- wp:group {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"constrained","contentSize":"100%"}} -->
                        <div class="wp-block-group"><!-- wp:group {"style":{"border":{"bottom":{"color":"var:preset|color|primary","width":"2px"},"top":[],"right":[],"left":[]},"spacing":{"padding":{"bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                            <div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--primary);border-bottom-width:2px;margin-top:0;margin-bottom:0;padding-bottom:0px"><!-- wp:group {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"spacing":{"padding":{"top":"5px","bottom":"5px","left":"12px","right":"12px"}}},"backgroundColor":"primary","textColor":"light-color","layout":{"type":"constrained"}} -->
                                <div class="wp-block-group has-light-color-color has-primary-background-color has-text-color has-background has-link-color" style="padding-top:5px;padding-right:12px;padding-bottom:5px;padding-left:12px"><!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600","fontSize":"18px"}},"textColor":"background"} -->
                                    <h4 class="wp-block-heading has-background-color has-text-color has-link-color" style="font-size:18px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Top Stories', 'jetnews-magazine') ?></h4>
                                    <!-- /wp:heading -->
                                </div>
                                <!-- /wp:group -->
                            </div>
                            <!-- /wp:group -->

                            <!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"20px","left":"20px"},"padding":{"top":"20px","bottom":"20px","left":"20px","right":"20px"}},"border":{"width":"1px"}},"borderColor":"border-color"} -->
                            <div class="wp-block-columns has-border-color has-border-color-border-color" style="border-width:1px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:column {"style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"width":"0px","style":"none"}},"backgroundColor":"light-color"} -->
                                <div class="wp-block-column has-light-color-background-color has-background" style="border-style:none;border-width:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:query {"queryId":23,"query":{"perPage":"1","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
                                    <div class="wp-block-query"><!-- wp:post-template {"style":{"spacing":{"blockGap":"32px"}},"layout":{"type":"default","columnCount":3}} -->
                                        <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"radius":"0px"}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                        <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default has-light-color-background-color has-background" style="border-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:post-featured-image {"isLink":true,"height":"300px"} /-->

                                            <!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"20px","bottom":"0"},"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
                                            <div class="wp-block-group is-style-default" style="margin-top:20px;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-terms {"term":"category","className":"is-style-categories-background-with-mixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"},":hover":{"color":{"text":"var:preset|color|background"}}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"}},"textColor":"light-color","fontSize":"x-small"} /--></div>
                                                <!-- /wp:group -->

                                                <!-- wp:post-title {"level":4,"isLink":true,"className":"is-style-default","style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"spacing":{"margin":{"top":"var:preset|spacing|20"}},"typography":{"textTransform":"none","lineHeight":"1.3","fontSize":"28px","fontStyle":"normal","fontWeight":"600"}}} /-->

                                                <!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-author-name {"className":"is-style-author-name-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-icon-color"}}}},"textColor":"meta-icon-color"} /-->

                                                    <!-- wp:post-date {"className":"is-style-post-date-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-icon-color"}}}},"textColor":"meta-icon-color","fontSize":"small"} /-->
                                                </div>
                                                <!-- /wp:group -->

                                                <!-- wp:post-excerpt {"moreText":"More","showMoreOnNewLine":false,"excerptLength":34,"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"},":hover":{"color":{"text":"var:preset|color|secondary"}}}}}} /-->
                                            </div>
                                            <!-- /wp:group -->
                                        </div>
                                        <!-- /wp:group -->
                                        <!-- /wp:post-template -->
                                    </div>
                                    <!-- /wp:query -->
                                </div>
                                <!-- /wp:column -->

                                <!-- wp:column {"style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"width":"0px","style":"none"}},"backgroundColor":"light-color"} -->
                                <div class="wp-block-column has-light-color-background-color has-background" style="border-style:none;border-width:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:query {"queryId":23,"query":{"perPage":"5","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
                                    <div class="wp-block-query"><!-- wp:post-template {"style":{"spacing":{"blockGap":"16px"}},"layout":{"type":"default","columnCount":3}} -->
                                        <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"0px","bottom":"16px","left":"0px","right":"0px"}},"border":{"radius":"0px","top":{"width":"0px","style":"none"},"bottom":{"color":"var:preset|color|border-color","width":"1px"}}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                        <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default has-light-color-background-color has-background" style="border-radius:0px;border-top-style:none;border-top-width:0px;border-bottom-color:var(--wp--preset--color--border-color);border-bottom-width:1px;padding-top:0px;padding-right:0px;padding-bottom:16px;padding-left:0px"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"16px","left":"16px"}}}} -->
                                            <div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"120px"} -->
                                                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:120px"><!-- wp:post-featured-image {"isLink":true,"height":"100px"} /--></div>
                                                <!-- /wp:column -->

                                                <!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"padding":{"right":"0","left":"0","top":"0","bottom":"0"}}}} -->
                                                <div class="wp-block-column is-vertically-aligned-center" style="padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"0px","bottom":"0"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
                                                    <div class="wp-block-group is-style-default" style="margin-top:0px;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:post-title {"level":4,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"lineHeight":"1.3","fontSize":"18px","textTransform":"none","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"0"}}}} /-->

                                                        <!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                        <div class="wp-block-group"><!-- wp:post-date {"className":"is-style-post-date-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-color"}}}},"textColor":"meta-color","fontSize":"small"} /--></div>
                                                        <!-- /wp:group -->
                                                    </div>
                                                    <!-- /wp:group -->
                                                </div>
                                                <!-- /wp:column -->
                                            </div>
                                            <!-- /wp:columns -->
                                        </div>
                                        <!-- /wp:group -->
                                        <!-- /wp:post-template -->
                                    </div>
                                    <!-- /wp:query -->
                                </div>
                                <!-- /wp:column -->
                            </div>
                            <!-- /wp:columns -->
                        </div>
                        <!-- /wp:group -->

                        <!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"},"blockGap":"20px"},"border":{"width":"0px","style":"none"}},"backgroundColor":"light-color","layout":{"type":"constrained","contentSize":"100%"}} -->
                        <div class="wp-block-group has-light-color-background-color has-background" style="border-style:none;border-width:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"border":{"bottom":{"color":"var:preset|color|primary","width":"2px"},"top":[],"right":[],"left":[]},"spacing":{"padding":{"bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                            <div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--primary);border-bottom-width:2px;margin-top:0;margin-bottom:0;padding-bottom:0px"><!-- wp:group {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"spacing":{"padding":{"top":"5px","bottom":"5px","left":"12px","right":"12px"}}},"backgroundColor":"primary","textColor":"light-color","layout":{"type":"constrained"}} -->
                                <div class="wp-block-group has-light-color-color has-primary-background-color has-text-color has-background has-link-color" style="padding-top:5px;padding-right:12px;padding-bottom:5px;padding-left:12px"><!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600","fontSize":"18px"}},"textColor":"background"} -->
                                    <h4 class="wp-block-heading has-background-color has-text-color has-link-color" style="font-size:18px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Hot Issues', 'jetnews-magazine') ?></h4>
                                    <!-- /wp:heading -->
                                </div>
                                <!-- /wp:group -->
                            </div>
                            <!-- /wp:group -->

                            <!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","bottom":"20px","left":"20px","right":"20px"},"blockGap":"0px"},"border":{"width":"1px"}},"borderColor":"border-color","layout":{"type":"constrained"}} -->
                            <div class="wp-block-group has-border-color has-border-color-border-color" style="border-width:1px;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:query {"queryId":23,"query":{"perPage":"6","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
                                <div class="wp-block-query"><!-- wp:post-template {"style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"grid","columnCount":3}} -->
                                    <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"radius":"0px"}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                    <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default has-light-color-background-color has-background" style="border-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:cover {"useFeaturedImage":true,"isUserOverlayColor":true,"minHeight":180,"gradient":"primary-gradient","contentPosition":"bottom left","className":"is-style-jetnews-magazine-cover-hover-zoom","style":{"spacing":{"padding":{"top":"10px","bottom":"10px","left":"14px","right":"14px"}}},"layout":{"type":"constrained"}} -->
                                        <div class="wp-block-cover has-custom-content-position is-position-bottom-left is-style-jetnews-magazine-cover-hover-zoom" style="padding-top:10px;padding-right:14px;padding-bottom:10px;padding-left:14px;min-height:180px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient has-primary-gradient-gradient-background"></span>
                                            <div class="wp-block-cover__inner-container"><!-- wp:post-terms {"term":"category","className":"is-style-categories-background-with-mixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"}},"textColor":"light-color","fontSize":"x-small"} /--></div>
                                        </div>
                                        <!-- /wp:cover -->

                                        <!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"16px","bottom":"0"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
                                        <div class="wp-block-group is-style-default" style="margin-top:16px;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:post-title {"level":4,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"lineHeight":"1.3","fontSize":"20px","textTransform":"none","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} /-->

                                            <!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                            <div class="wp-block-group"><!-- wp:post-date {"className":"is-style-post-date-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-color"}}}},"textColor":"meta-color","fontSize":"small"} /--></div>
                                            <!-- /wp:group -->
                                        </div>
                                        <!-- /wp:group -->
                                    </div>
                                    <!-- /wp:group -->
                                    <!-- /wp:post-template -->
                                </div>
                                <!-- /wp:query -->
                            </div>
                            <!-- /wp:group -->
                        </div>
                        <!-- /wp:group -->

                        <!-- wp:group {"style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"},"blockGap":"20px"}},"layout":{"type":"constrained","contentSize":"100%"}} -->
                        <div class="wp-block-group" style="padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"border":{"bottom":{"color":"var:preset|color|primary","width":"2px"},"top":[],"right":[],"left":[]},"spacing":{"padding":{"bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                            <div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--primary);border-bottom-width:2px;margin-top:0;margin-bottom:0;padding-bottom:0px"><!-- wp:group {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"spacing":{"padding":{"top":"5px","bottom":"5px","left":"12px","right":"12px"}}},"backgroundColor":"primary","textColor":"light-color","layout":{"type":"constrained"}} -->
                                <div class="wp-block-group has-light-color-color has-primary-background-color has-text-color has-background has-link-color" style="padding-top:5px;padding-right:12px;padding-bottom:5px;padding-left:12px"><!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600","fontSize":"18px"}},"textColor":"background"} -->
                                    <h4 class="wp-block-heading has-background-color has-text-color has-link-color" style="font-size:18px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('Recent Articles', 'jetnews-magazine') ?></h4>
                                    <!-- /wp:heading -->
                                </div>
                                <!-- /wp:group -->
                            </div>
                            <!-- /wp:group -->

                            <!-- wp:group {"style":{"spacing":{"blockGap":"0","padding":{"top":"0px","bottom":"20px","left":"20px","right":"20px"}},"border":{"width":"1px"}},"borderColor":"border-color","layout":{"type":"constrained","contentSize":"100%"}} -->
                            <div class="wp-block-group has-border-color has-border-color-border-color" style="border-width:1px;padding-top:0px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:query {"queryId":23,"query":{"perPage":"10","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
                                <div class="wp-block-query"><!-- wp:post-template {"style":{"spacing":{"blockGap":"0px"}},"layout":{"type":"default","columnCount":3}} -->
                                    <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"20px","bottom":"20px","left":"0px","right":"0px"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":"0px","top":{"radius":"0px","width":"0px","style":"none"},"right":{"radius":"0px","width":"0px","style":"none"},"bottom":{"color":"var:preset|color|border-color","width":"1px"},"left":{"radius":"0px","width":"0px","style":"none"}}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                    <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default has-light-color-background-color has-background" style="border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-color:var(--wp--preset--color--border-color);border-bottom-width:1px;border-left-style:none;border-left-width:0px;margin-top:0;margin-bottom:0;padding-top:20px;padding-right:0px;padding-bottom:20px;padding-left:0px"><!-- wp:columns {"verticalAlignment":"center"} -->
                                        <div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"40%"} -->
                                            <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:40%"><!-- wp:post-featured-image {"isLink":true,"height":"248px"} /--></div>
                                            <!-- /wp:column -->

                                            <!-- wp:column {"verticalAlignment":"center","width":""} -->
                                            <div class="wp-block-column is-vertically-aligned-center"><!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"0px","bottom":"0"},"blockGap":"var:preset|spacing|30"}},"layout":{"type":"constrained"}} -->
                                                <div class="wp-block-group is-style-default" style="margin-top:0px;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:post-terms {"term":"category","className":"is-style-categories-background-with-mixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|background"},":hover":{"color":{"text":"var:preset|color|background"}}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"}},"fontSize":"x-small"} /-->

                                                    <!-- wp:post-title {"level":4,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|heading-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"lineHeight":"1.3","fontSize":"24px","textTransform":"none","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"var:preset|spacing|30"}}}} /-->

                                                    <!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                    <div class="wp-block-group"><!-- wp:post-author-name {"className":"is-style-author-name-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-color"}}}},"textColor":"meta-color"} /-->

                                                        <!-- wp:post-date {"className":"is-style-post-date-with-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|meta-color"}}}},"textColor":"meta-color","fontSize":"small"} /-->
                                                    </div>
                                                    <!-- /wp:group -->

                                                    <!-- wp:post-excerpt {"moreText":"","excerptLength":18} /-->

                                                    <!-- wp:group {"style":{"spacing":{"margin":{"top":"16px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                                                    <div class="wp-block-group" style="margin-top:16px"><!-- wp:read-more {"content":"Read More","className":"is-style-readmore-hover-primary-fill","style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"}}},"border":{"width":"1px"},"spacing":{"padding":{"right":"16px","left":"16px","top":"4px","bottom":"4px"}}},"textColor":"primary"} /--></div>
                                                    <!-- /wp:group -->
                                                </div>
                                                <!-- /wp:group -->
                                            </div>
                                            <!-- /wp:column -->
                                        </div>
                                        <!-- /wp:columns -->
                                    </div>
                                    <!-- /wp:group -->
                                    <!-- /wp:post-template -->

                                    <!-- wp:query-pagination {"paginationArrow":"chevron","showLabel":false,"className":"jetnews-magazine-pagination","style":{"typography":{"fontSize":"18px","fontStyle":"normal","fontWeight":"500","textTransform":"uppercase"}},"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"center"}} -->
                                    <!-- wp:query-pagination-previous /-->

                                    <!-- wp:query-pagination-numbers /-->

                                    <!-- wp:query-pagination-next /-->
                                    <!-- /wp:query-pagination -->
                                </div>
                                <!-- /wp:query -->
                            </div>
                            <!-- /wp:group -->
                        </div>
                        <!-- /wp:group -->
                    </div>
                    <!-- /wp:column -->

                    <!-- wp:column {"width":"28%"} -->
                    <div class="wp-block-column" style="flex-basis:28%"><!-- wp:group {"metadata":{"name":"Sidebar Groups"},"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}},"position":{"type":"sticky","top":"0px"}},"layout":{"type":"constrained","contentSize":"100%"}} -->
                        <div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:template-part {"slug":"sidebar","theme":"jetnews-magazine","area":"uncategorized"} /--></div>
                        <!-- /wp:group -->
                    </div>
                    <!-- /wp:column -->
                </div>
                <!-- /wp:columns -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"metadata":{"name":"You may missed"},"style":{"spacing":{"padding":{"right":"28px","left":"28px","top":"0px","bottom":"0px"},"margin":{"top":"0","bottom":"0"},"blockGap":"20px"}},"backgroundColor":"background","layout":{"type":"constrained","contentSize":"100%"}} -->
            <div class="wp-block-group has-background-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:0px;padding-right:28px;padding-bottom:0px;padding-left:28px"><!-- wp:group {"style":{"border":{"bottom":{"color":"var:preset|color|primary","width":"2px"},"top":[],"right":[],"left":[]},"spacing":{"padding":{"bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                <div class="wp-block-group" style="border-bottom-color:var(--wp--preset--color--primary);border-bottom-width:2px;margin-top:0;margin-bottom:0;padding-bottom:0px"><!-- wp:group {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"spacing":{"padding":{"top":"5px","bottom":"5px","left":"12px","right":"12px"}}},"backgroundColor":"primary","textColor":"light-color","layout":{"type":"constrained"}} -->
                    <div class="wp-block-group has-light-color-color has-primary-background-color has-text-color has-background has-link-color" style="padding-top:5px;padding-right:12px;padding-bottom:5px;padding-left:12px"><!-- wp:heading {"level":4,"style":{"elements":{"link":{"color":{"text":"var:preset|color|background"}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"600","fontSize":"18px"}},"textColor":"background"} -->
                        <h4 class="wp-block-heading has-background-color has-text-color has-link-color" style="font-size:18px;font-style:normal;font-weight:600;text-transform:uppercase"><?php esc_html_e('You May Missed', 'jetnews-magazine') ?></h4>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->
                </div>
                <!-- /wp:group -->

                <!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","bottom":"20px","left":"20px","right":"20px"},"margin":{"top":"20px","bottom":"0"}},"border":{"width":"1px"}},"backgroundColor":"light-color","borderColor":"border-color","layout":{"type":"constrained","contentSize":"100%"}} -->
                <div class="wp-block-group has-border-color has-border-color-border-color has-light-color-background-color has-background" style="border-width:1px;margin-top:20px;margin-bottom:0;padding-top:20px;padding-right:20px;padding-bottom:20px;padding-left:20px"><!-- wp:columns -->
                    <div class="wp-block-columns"><!-- wp:column -->
                        <div class="wp-block-column"><!-- wp:query {"queryId":23,"query":{"perPage":10,"pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false},"className":"jetnewsmagazine-post-carousel"} -->
                            <div class="wp-block-query jetnewsmagazine-post-carousel"><!-- wp:post-template {"className":"jetnewsmagazine-swiper-holder","style":{"spacing":{"blockGap":"20px"}},"layout":{"type":"default","columnCount":4}} -->
                                <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"0px","bottom":"0px","left":"0px","right":"0px"}},"border":{"radius":"0px"}},"backgroundColor":"light-color","layout":{"type":"constrained"}} -->
                                <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default has-light-color-background-color has-background" style="border-radius:0px;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:cover {"useFeaturedImage":true,"isUserOverlayColor":true,"minHeight":230,"customGradient":"linear-gradient(180deg,rgba(0,0,0,0.05) 29%,rgb(0,0,0) 100%)","contentPosition":"bottom left","className":"is-style-jetnews-magazine-cover-hover-zoom","style":{"spacing":{"padding":{"top":"14px","bottom":"14px","left":"16px","right":"16px"}}},"layout":{"type":"constrained"}} -->
                                    <div class="wp-block-cover has-custom-content-position is-position-bottom-left is-style-jetnews-magazine-cover-hover-zoom" style="padding-top:14px;padding-right:16px;padding-bottom:14px;padding-left:16px;min-height:230px"><span aria-hidden="true" class="wp-block-cover__background has-background-dim-100 has-background-dim has-background-gradient" style="background:linear-gradient(180deg,rgba(0,0,0,0.05) 29%,rgb(0,0,0) 100%)"></span>
                                        <div class="wp-block-cover__inner-container"><!-- wp:group {"className":"is-style-default","style":{"spacing":{"padding":{"bottom":"0px","left":"0px","right":"0px","top":"0px"},"margin":{"top":"0","bottom":"0"},"blockGap":"var:preset|spacing|40"}},"layout":{"type":"constrained"}} -->
                                            <div class="wp-block-group is-style-default" style="margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px"><!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-terms {"term":"category","className":"is-style-categories-background-with-mixed","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"},":hover":{"color":{"text":"var:preset|color|light-color"}}}},"typography":{"textTransform":"uppercase","fontStyle":"normal","fontWeight":"500"}},"textColor":"light-color","fontSize":"x-small"} /--></div>
                                                <!-- /wp:group -->

                                                <!-- wp:post-title {"level":4,"isLink":true,"className":"is-style-default","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"lineHeight":"1.2","textTransform":"none","fontStyle":"normal","fontWeight":"600"},"spacing":{"margin":{"top":"var:preset|spacing|20"}}},"fontSize":"medium"} /-->

                                                <!-- wp:group {"layout":{"type":"flex","flexWrap":"nowrap"}} -->
                                                <div class="wp-block-group"><!-- wp:post-date {"className":"is-style-post-date-with-white-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"small"} /--></div>
                                                <!-- /wp:group -->
                                            </div>
                                            <!-- /wp:group -->
                                        </div>
                                    </div>
                                    <!-- /wp:cover -->
                                </div>
                                <!-- /wp:group -->
                                <!-- /wp:post-template -->

                                <!-- wp:group {"metadata":{"name":"Carousel Controls"},"className":"jetnews-magazine-carousel-controls","style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained"}} -->
                                <div class="wp-block-group jetnews-magazine-carousel-controls" style="margin-top:0;margin-bottom:0"><!-- wp:html -->
                                    <div class="jetnewsmagazine-carousel-button-prev swiper-button-prev"></div>
                                    <div class="jetnewsmagazine-carousel-button-next swiper-button-next"></div>
                                    <!-- /wp:html -->
                                </div>
                                <!-- /wp:group -->
                            </div>
                            <!-- /wp:query -->
                        </div>
                        <!-- /wp:column -->
                    </div>
                    <!-- /wp:columns -->
                </div>
                <!-- /wp:group -->
            </div>
            <!-- /wp:group -->

            <!-- wp:group {"metadata":{"name":"Ads Placement"},"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40","top":"32px","bottom":"32px"}}},"backgroundColor":"background","layout":{"type":"constrained","contentSize":"1180px"}} -->
            <div class="wp-block-group has-background-background-color has-background" style="margin-top:0;margin-bottom:0;padding-top:32px;padding-right:var(--wp--preset--spacing--40);padding-bottom:32px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:image {"lightbox":{"enabled":false},"id":3018,"sizeSlug":"full","linkDestination":"custom","align":"center"} -->
                <figure class="wp-block-image aligncenter size-full"><img src="<?php echo esc_url($jetnews_magazine_images[2]) ?>" alt="" class="wp-image-3018" /></figure>
                <!-- /wp:image -->
            </div>
            <!-- /wp:group -->
        </main>
        <!-- /wp:group -->

        <!-- wp:template-part {"slug":"footer","theme":"jetnews-magazine","area":"footer"} /-->
    </div>
</div>
<!-- /wp:cover -->