<?php

/**
 * Title: Footer Layout with Gallery
 * Slug: jetnews-magazine/footer-with-gallery
 * Categories: footer
 */
$jetnews_magazine_url = trailingslashit(get_template_directory_uri());
$jetnews_magazine_images = array(
    $jetnews_magazine_url . 'assets/images/g1.jpg',
    $jetnews_magazine_url . 'assets/images/g2.jpg',
    $jetnews_magazine_url . 'assets/images/g3.jpg',
    $jetnews_magazine_url . 'assets/images/g4.jpg',
    $jetnews_magazine_url . 'assets/images/g5.jpg',
    $jetnews_magazine_url . 'assets/images/g6.jpg',
    $jetnews_magazine_url . 'assets/images/g7.jpg',
    $jetnews_magazine_url . 'assets/images/g8.jpg',
    $jetnews_magazine_url . 'assets/images/g9.jpg',
);
?>
<!-- wp:group {"style":{"spacing":{"padding":{"top":"0","bottom":"0","left":"0","right":"0"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"100%"}} -->
<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:0;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:group {"className":"jetnews-magazine-footer","style":{"spacing":{"padding":{"top":"40px","right":"0","left":"0","bottom":"0px"},"margin":{"top":"0","bottom":"0"},"blockGap":"0"},"border":{"width":"0px","style":"none"}},"backgroundColor":"dark-shade","layout":{"type":"constrained","contentSize":"100%"}} -->
    <div class="wp-block-group jetnews-magazine-footer has-dark-shade-background-color has-background" style="border-style:none;border-width:0px;margin-top:0;margin-bottom:0;padding-top:40px;padding-right:0;padding-bottom:0px;padding-left:0"><!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40"},"margin":{"top":"0","bottom":"0"}},"border":{"top":{"style":"none","width":"0px"},"right":[],"bottom":[],"left":[]}},"layout":{"type":"constrained","contentSize":"1240px"}} -->
        <div class="wp-block-group" style="border-top-style:none;border-top-width:0px;margin-top:0;margin-bottom:0;padding-right:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)"><!-- wp:columns {"style":{"spacing":{"blockGap":{"top":"20px","left":"48px"},"margin":{"top":"0px"},"padding":{"top":"40px"}},"border":{"top":{"width":"0px","style":"none"},"right":{},"bottom":{},"left":{}}}} -->
            <div class="wp-block-columns" style="border-top-style:none;border-top-width:0px;margin-top:0px;padding-top:40px"><!-- wp:column {"width":"12%","className":"jetnews-magazine-footer-list"} -->
                <div class="wp-block-column jetnews-magazine-footer-list" style="flex-basis:12%"><!-- wp:group {"style":{"border":{"bottom":{"width":"0px","style":"none"}},"spacing":{"blockGap":"15px","margin":{"top":"1px","bottom":"16px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px;margin-top:1px;margin-bottom:16px"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
                        <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><?php esc_html_e('Quick Links', 'jetnews-magazine') ?></h3>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->

                    <!-- wp:navigation {"ref":282,"textColor":"light-color","style":{"spacing":{"blockGap":"var:preset|spacing|30"}},"layout":{"type":"flex","orientation":"vertical"}} /-->
                </div>
                <!-- /wp:column -->

                <!-- wp:column {"width":"12%","className":"jetnews-magazine-footer-list"} -->
                <div class="wp-block-column jetnews-magazine-footer-list" style="flex-basis:12%"><!-- wp:group {"style":{"border":{"bottom":{"width":"0px","style":"none"}},"spacing":{"blockGap":"15px","margin":{"top":"1px","bottom":"16px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px;margin-top:1px;margin-bottom:16px"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
                        <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><?php esc_html_e('Categories', 'jetnews-magazine') ?></h3>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->

                    <!-- wp:categories {"className":"is-style-jetnews-magazine-categories-bullet-hide-style-white","style":{"typography":{"lineHeight":"2"}}} /-->
                </div>
                <!-- /wp:column -->

                <!-- wp:column {"width":"25%","className":"jetnews-magazine-footer-list"} -->
                <div class="wp-block-column jetnews-magazine-footer-list" style="flex-basis:25%"><!-- wp:group {"style":{"border":{"bottom":{"width":"0px","style":"none"},"top":{},"right":{},"left":{}},"spacing":{"blockGap":"15px","margin":{"top":"1px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px;margin-top:1px"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
                        <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><?php esc_html_e('Photo Gallery', 'jetnews-magazine') ?></h3>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->

                    <!-- wp:gallery {"linkTo":"none","sizeSlug":"full","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|20","left":"var:preset|spacing|20"}}}} -->
                    <figure class="wp-block-gallery has-nested-images columns-default is-cropped"><!-- wp:image {"id":58,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[0]) ?>" alt="" class="wp-image-58" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":55,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[1]) ?>" alt="" class="wp-image-55" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":52,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[2]) ?>" alt="" class="wp-image-52" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":43,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[3]) ?>" alt="" class="wp-image-43" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":46,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[4]) ?>" alt="" class="wp-image-46" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":49,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[5]) ?>" alt="" class="wp-image-49" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":740,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[6]) ?>" alt="" class="wp-image-740" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":738,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[7]) ?>" alt="" class="wp-image-738" /></figure>
                        <!-- /wp:image -->

                        <!-- wp:image {"id":736,"sizeSlug":"full","linkDestination":"none"} -->
                        <figure class="wp-block-image size-full"><img src="<?php echo esc_url($jetnews_magazine_images[8]) ?>" alt="" class="wp-image-736" /></figure>
                        <!-- /wp:image -->
                    </figure>
                    <!-- /wp:gallery -->
                </div>
                <!-- /wp:column -->

                <!-- wp:column {"className":"jetnews-magazine-footer-list"} -->
                <div class="wp-block-column jetnews-magazine-footer-list"><!-- wp:group {"style":{"border":{"bottom":{"width":"0px","style":"none"},"top":{},"right":{},"left":{}},"spacing":{"blockGap":"15px","margin":{"top":"1px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px;margin-top:1px"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
                        <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><?php esc_html_e('Latest Articles', 'jetnews-magazine') ?></h3>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->

                    <!-- wp:query {"queryId":23,"query":{"perPage":"2","pages":0,"offset":"0","postType":"post","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":false}} -->
                    <div class="wp-block-query"><!-- wp:post-template {"style":{"spacing":{"blockGap":"12px"}},"layout":{"type":"default","columnCount":3}} -->
                        <!-- wp:group {"className":"jetnews-magazine-post-featuredimg is-style-default","style":{"spacing":{"padding":{"top":"0px","bottom":"12px","left":"0px","right":"0px"},"margin":{"top":"0","bottom":"0"}},"border":{"radius":"0px","top":{"radius":"0px","width":"0px","style":"none"},"right":{"radius":"0px","width":"0px","style":"none"},"bottom":{"color":"var:preset|color|border-dark-color","width":"1px"},"left":{"radius":"0px","width":"0px","style":"none"}}},"layout":{"type":"constrained"}} -->
                        <div class="wp-block-group jetnews-magazine-post-featuredimg is-style-default" style="border-radius:0px;border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-color:var(--wp--preset--color--border-dark-color);border-bottom-width:1px;border-left-style:none;border-left-width:0px;margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0px;padding-bottom:12px;padding-left:0px"><!-- wp:post-title {"level":4,"isLink":true,"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"},":hover":{"color":{"text":"var:preset|color|primary"}}}},"typography":{"lineHeight":"1.3","textTransform":"none","fontSize":"16px"},"spacing":{"margin":{"top":"0"}}},"fontFamily":"public-sans"} /-->

                            <!-- wp:post-date {"className":"is-style-post-date-with-white-icon","style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"small"} /-->
                        </div>
                        <!-- /wp:group -->
                        <!-- /wp:post-template -->
                    </div>
                    <!-- /wp:query -->
                </div>
                <!-- /wp:column -->

                <!-- wp:column {"width":"","className":"jetnews-magazine-footer-list"} -->
                <div class="wp-block-column jetnews-magazine-footer-list"><!-- wp:group {"style":{"border":{"bottom":{"width":"0px","style":"none"},"top":[],"right":[],"left":[]},"spacing":{"blockGap":"15px","margin":{"top":"1px","bottom":"20px"}}},"layout":{"type":"flex","orientation":"vertical"}} -->
                    <div class="wp-block-group" style="border-bottom-style:none;border-bottom-width:0px;margin-top:1px;margin-bottom:20px"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"medium"} -->
                        <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-medium-font-size" style="text-transform:uppercase"><?php esc_html_e('Follow Us on', 'jetnews-magazine') ?></h3>
                        <!-- /wp:heading -->
                    </div>
                    <!-- /wp:group -->

                    <!-- wp:social-links {"iconColor":"light-color","iconColorValue":"#FFFFFF","className":"is-style-logos-only","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|40"},"margin":{"top":"0px","bottom":"0"}}}} -->
                    <ul class="wp-block-social-links has-icon-color is-style-logos-only" style="margin-top:0px;margin-bottom:0"><!-- wp:social-link {"url":"#","service":"instagram"} /-->

                        <!-- wp:social-link {"url":"#","service":"facebook"} /-->

                        <!-- wp:social-link {"url":"#","service":"linkedin"} /-->

                        <!-- wp:social-link {"url":"#","service":"x"} /-->

                        <!-- wp:social-link {"url":"#","service":"vk"} /-->

                        <!-- wp:social-link {"url":"#","service":"tiktok"} /-->
                    </ul>
                    <!-- /wp:social-links -->
                </div>
                <!-- /wp:column -->
            </div>
            <!-- /wp:columns -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"style":{"spacing":{"padding":{"right":"var:preset|spacing|40","left":"var:preset|spacing|40","top":"64px","bottom":"0px"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"constrained","contentSize":"1240px"}} -->
        <div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:64px;padding-right:var(--wp--preset--spacing--40);padding-bottom:0px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"left":"44px"},"margin":{"top":"0","bottom":"0"},"padding":{"bottom":"5px"}},"border":{"top":{"color":"var:preset|color|border-dark-color","width":"1px"},"bottom":{"color":"var:preset|color|border-dark-color","width":"1px"}}}} -->
            <div class="wp-block-columns are-vertically-aligned-center" style="border-top-color:var(--wp--preset--color--border-dark-color);border-top-width:1px;border-bottom-color:var(--wp--preset--color--border-dark-color);border-bottom-width:1px;margin-top:0;margin-bottom:0;padding-bottom:5px"><!-- wp:column {"verticalAlignment":"center","width":"30%"} -->
                <div class="wp-block-column is-vertically-aligned-center" style="flex-basis:30%"><!-- wp:site-title {"style":{"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}},"typography":{"textTransform":"uppercase"}},"textColor":"light-color"} /--></div>
                <!-- /wp:column -->

                <!-- wp:column {"verticalAlignment":"center"} -->
                <div class="wp-block-column is-vertically-aligned-center"><!-- wp:heading {"level":3,"style":{"typography":{"textTransform":"uppercase"},"elements":{"link":{"color":{"text":"var:preset|color|light-color"}}}},"textColor":"light-color","fontSize":"big"} -->
                    <h3 class="wp-block-heading has-light-color-color has-text-color has-link-color has-big-font-size" style="text-transform:uppercase"><?php esc_html_e('Get the Jump on News, Early Updates to Your Email', 'jetnews-magazine') ?></h3>
                    <!-- /wp:heading -->
                </div>
                <!-- /wp:column -->

                <!-- wp:column {"verticalAlignment":"center","width":"35%","style":{"spacing":{"padding":{"top":"24px"}}}} -->
                <div class="wp-block-column is-vertically-aligned-center" style="padding-top:24px;flex-basis:35%"><!-- wp:contact-form-7/contact-form-selector {"id":790,"hash":"a6f85fb","title":"Newsletter","className":"jetnews-magazine-footer-newsletter-2"} -->
                    <div class="wp-block-contact-form-7-contact-form-selector jetnews-magazine-footer-newsletter-2">[contact-form-7 id="a6f85fb" title="Newsletter"]</div>
                    <!-- /wp:contact-form-7/contact-form-selector -->
                </div>
                <!-- /wp:column -->
            </div>
            <!-- /wp:columns -->
        </div>
        <!-- /wp:group -->

        <!-- wp:group {"style":{"spacing":{"margin":{"top":"0px"},"padding":{"top":"24px","bottom":"24px","right":"var:preset|spacing|40","left":"var:preset|spacing|40"},"blockGap":"var:preset|spacing|50"},"border":{"top":{"width":"0px","style":"none"},"right":[],"bottom":[],"left":[]}},"layout":{"type":"constrained","contentSize":"1240px"}} -->
        <div class="wp-block-group" style="border-top-style:none;border-top-width:0px;margin-top:0px;padding-top:24px;padding-right:var(--wp--preset--spacing--40);padding-bottom:24px;padding-left:var(--wp--preset--spacing--40)"><!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"right":"0","left":"0","top":"0px","bottom":"0"}},"border":{"top":{"width":"0px","style":"none"}}},"layout":{"type":"flex","flexWrap":"nowrap","justifyContent":"space-between"}} -->
            <div class="wp-block-group" style="border-top-style:none;border-top-width:0px;margin-top:0;margin-bottom:0;padding-top:0px;padding-right:0;padding-bottom:0;padding-left:0"><!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|primary"},":hover":{"color":{"text":"var:preset|color|secondary"}}}},"typography":{"lineHeight":"1.5"}},"textColor":"light-color","fontSize":"normal"} -->
                <p class="has-light-color-color has-text-color has-link-color has-normal-font-size" style="line-height:1.5"><?php esc_html_e('Proudly Powered by WordPress | jetnews Magazine by', 'jetnews-magazine') ?> <a href="https://cozythemes.com/" target="_blank" rel="noreferrer noopener"><?php esc_html_e('CozyThemes', 'jetnews-magazine') ?></a>.</p>
                <!-- /wp:paragraph -->
            </div>
            <!-- /wp:group -->
        </div>
        <!-- /wp:group -->
    </div>
    <!-- /wp:group -->

    <!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} -->
    <div class="wp-block-buttons" style="margin-top:0;margin-bottom:0"><!-- wp:button {"backgroundColor":"tertiary","textColor":"foregound-alt","className":"jetnews-magazine-scrollto-top is-style-button-hover-secondary-bgcolor","style":{"border":{"radius":"50%"}}} -->
        <div class="wp-block-button jetnews-magazine-scrollto-top is-style-button-hover-secondary-bgcolor"><a class="wp-block-button__link has-foregound-alt-color has-tertiary-background-color has-text-color has-background wp-element-button" style="border-radius:50%"><?php esc_html_e('Scroll to Top', 'jetnews-magazine') ?></a></div>
        <!-- /wp:button -->
    </div>
    <!-- /wp:buttons -->
</div>
<!-- /wp:group -->