<?php

/**
 * Block Styles
 *
 * @link https://developer.wordpress.org/reference/functions/register_block_style/
 *
 * @package jetnews_magazine
 * @since 1.0.0
 */

if (function_exists('register_block_style')) {
    /**
     * Register block styles.
     *
     * @since 0.1
     *
     * @return void
     */
    function jetnews_magazine_register_block_styles()
    {
        register_block_style(
            'core/columns',
            array(
                'name'  => 'jetnews-magazine-boxshadow',
                'label' => __('Box Shadow', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'jetnews-magazine-boxshadow',
                'label' => __('Box Shadow', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'jetnews-magazine-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/column',
            array(
                'name'  => 'jetnews-magazine-boxshadow-large',
                'label' => __('Box Shadow Large', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'jetnews-magazine-boxshadow',
                'label' => __('Box Shadow', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'jetnews-magazine-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/group',
            array(
                'name'  => 'jetnews-magazine-boxshadow-large',
                'label' => __('Box Shadow Larger', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-boxshadow',
                'label' => __('Box Shadow', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-boxshadow-medium',
                'label' => __('Box Shadow Medium', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-boxshadow-larger',
                'label' => __('Box Shadow Large', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-image-pulse',
                'label' => __('Iamge Pulse Effect', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-image-hover-pulse',
                'label' => __('Hover Pulse Effect', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/image',
            array(
                'name'  => 'jetnews-magazine-image-hover-rotate',
                'label' => __('Hover Rotate Effect', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/columns',
            array(
                'name'  => 'jetnews-magazine-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/column',
            array(
                'name'  => 'jetnews-magazine-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/group',
            array(
                'name'  => 'jetnews-magazine-boxshadow-hover',
                'label' => __('Box Shadow on Hover', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-primary',
                'label' => __('Primary BG Set', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-secondary',
                'label' => __('Secondary BG Set', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-mixed',
                'label' => __('Mixed BG Set', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-mixed-color',
                'label' => __('Mixed Color Set', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-mixed-color-square',
                'label' => __('Square Bullet style Mixed Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-with-square',
                'label' => __('Square Bullet style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-round-faded',
                'label' => __('Faded Round', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-terms',
            array(
                'name'  => 'categories-background-mixed-round',
                'label' => __('Faded Mixed Round', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-title',
            array(
                'name'  => 'jetnews-post-title-underline-primary',
                'label' => __('Hover: Underline Primary Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-title',
            array(
                'name'  => 'jetnews-post-title-underline-secondary',
                'label' => __('Hover: Underline Secondary Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-color',
                'label' => __('Hover: Primary Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-primary-bgcolor',
                'label' => __('Hover: Primary color fill', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/button',
            array(
                'name'  => 'button-hover-secondary-bgcolor',
                'label' => __('Hover: Secondary color fill', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-color',
                'label' => __('Hover: Primary Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-color',
                'label' => __('Hover: Secondary Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-primary-fill',
                'label' => __('Hover: Primary Fill', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/read-more',
            array(
                'name'  => 'readmore-hover-secondary-fill',
                'label' => __('Hover: secondary Fill', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/list',
            array(
                'name'  => 'list-style-no-bullet',
                'label' => __('Hide bullet', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/gallery',
            array(
                'name'  => 'enable-grayscale-mode-on-image',
                'label' => __('Enable Grayscale Mode on Image', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/social-links',
            array(
                'name'  => 'social-icon-border',
                'label' => __('Border Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/page-list',
            array(
                'name'  => 'jetnews-magazine-page-list-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'jetnews-magazine-categories-bullet-hide-style',
                'label' => __('Hide Bullet Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'jetnews-magazine-categories-bullet-hide-style-heading',
                'label' => __('Hide Bullet Style Heading Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'jetnews-magazine-categories-bullet-hide-style-primary',
                'label' => __('Hide Bullet Style Primay Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/categories',
            array(
                'name'  => 'jetnews-magazine-categories-bullet-hide-style-white',
                'label' => __('Hide Bullet Style White Color', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/cover',
            array(
                'name'  => 'jetnews-magazine-cover-hover-zoom',
                'label' => __('Hover Zoom Style', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/navigation',
            array(
                'name'  => 'jetnews-navigation-hover-primary-bgcolor',
                'label' => __('Background on Hover', 'jetnews-magazine')
            )
        );

        register_block_style(
            'core/post-author-name',
            array(
                'name'  => 'author-name-with-icon',
                'label' => __('With Icon', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-author-name',
            array(
                'name'  => 'author-name-with-white-icon',
                'label' => __('With White Icon', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-date',
            array(
                'name'  => 'post-date-with-icon',
                'label' => __('With Icon', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/post-date',
            array(
                'name'  => 'post-date-with-white-icon',
                'label' => __('With White Icon', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/archives',
            array(
                'name'  => 'jetnews-magazine-archive-hide-bullet',
                'label' => __('Hide Bullet', 'jetnews-magazine')
            )
        );
        register_block_style(
            'core/archives',
            array(
                'name'  => 'jetnews-magazine-archive-square-bullet',
                'label' => __('Square Bullet', 'jetnews-magazine')
            )
        );
    }
    add_action('init', 'jetnews_magazine_register_block_styles');
}
