<?php

/**
 * jetnews_magazine: Block Patterns
 *
 * @since jetnews_magazine 1.0.0
 */

/**
 * Registers pattern categories for jetnews_magazine
 *
 * @since jetnews_magazine 1.0.0
 *
 * @return void
 */
function jetnews_magazine_register_pattern_category()
{
	$block_pattern_categories = array(
		'jetnews-magazine' => array('label' => __('Additional Sections', 'jetnews-magazine')),
		'jetnews-magazine-home' => array('label' => __('Templates: Homepage', 'jetnews-magazine')),
		'jetnews-magazine-pages' => array('label' => __('Pages Layouts', 'jetnews-magazine')),
		'jetnews-magazine-page-templates' => array('label' => __('Templates: Page', 'jetnews-magazine')),
		'jetnews-magazine-posts' => array('label' => __('Templates: Single Post', 'jetnews-magazine')),
		'jetnews-magazine-banners' => array('label' => __('Featured Banners and Sliders', 'jetnews-magazine')),
		'jetnews-magazine-post-layouts' => array('label' => __('Post and Magazine Sections', 'jetnews-magazine')),
		'jetnews-magazine-blogs' => array('label' => __('Templates: Archive', 'jetnews-magazine')),
		'jetnews-magazine-sidebar-elements' => array('label' => __('Sidebar Components', 'jetnews-magazine')),


	);

	$block_pattern_categories = apply_filters('jetnews_magazine_block_pattern_categories', $block_pattern_categories);

	foreach ($block_pattern_categories as $name => $properties) {
		if (!WP_Block_Pattern_Categories_Registry::get_instance()->is_registered($name)) {
			register_block_pattern_category($name, $properties); // phpcs:ignore WPThemeReview.PluginTerritory.ForbiddenFunctions.editor_blocks_register_block_pattern_category
		}
	}
}
add_action('init', 'jetnews_magazine_register_pattern_category', 9);
