<?php

/**
 * file for holding dashboard welcome page for theme
 */
if ( ! function_exists( 'jetnews_magazine_is_plugin_installed' ) ) {
	function jetnews_magazine_is_plugin_installed( $plugin_slug ) {
		$plugin_path = WP_PLUGIN_DIR . '/' . $plugin_slug;
		return file_exists( $plugin_path );
	}
}
if ( ! function_exists( 'jetnews_magazine_is_plugin_activated' ) ) {
	function jetnews_magazine_is_plugin_activated( $plugin_slug ) {
		return is_plugin_active( $plugin_slug );
	}
}
if ( ! function_exists( 'jetnews_magazine_welcome_notice' ) ) :
	function jetnews_magazine_welcome_notice() {
		if ( get_option( 'jetnews_magazine_dismissed_custom_notice' ) ) {
			return;
		}
		global $pagenow;
		$current_screen = get_current_screen();

		if ( is_admin() ) {
			if ( $current_screen->id !== 'dashboard' && $current_screen->id !== 'themes' ) {
				return;
			}
			if ( is_network_admin() ) {
				return;
			}
			if ( ! current_user_can( 'manage_options' ) ) {
				return;
			}

			?>
			<div class="jetnews-magazine-admin-notice notice notice-success is-dismissible content-install-plugin theme-info-notice" id="jetnews-magazine-dismiss-notice">
				<div class="info-content">
					<div class="notice-holder">

						<h3><?php esc_html_e( 'Welcome to JetNews Magazine! Launch your website in minutes with 20+ pre-built starter sites and a seamless one-click demo importer for easy setup.', 'jetnews-magazine' ); ?></h3>
						<div class="notice-text">
							<p class="cozy-blocks-text"><?php esc_html_e( 'Please install and activate all recommended plugins to use 40+ advanced blocks, 200+ pre-built sections, and 20+ starter site demos. Enhance website building and launch your site within minutes with just a few clicks! - Cozy Addons, Cozy Essential Addons, Advanced Import.', 'jetnews-magazine' ); ?></p>
						</div>
						<a href="<?php echo admin_url(); ?>themes.php?page=about-jetnews-magazine" class="button admin-button button-primary"><?php esc_html_e( 'Explore JetNews Magazine', 'jetnews-magazine' ); ?></a>

					</div>
				</div>
				<div class="theme-hero-screens">
					<img src="<?php echo esc_url( get_template_directory_uri() . '/inc/admin/images/theme-templates-stack.png' ); ?>" />
				</div>

			</div>
			<?php
		}
	}
endif;
add_action( 'admin_notices', 'jetnews_magazine_welcome_notice' );
function jetnews_magazine_dismissble_notice() {
	if ( ! isset( $_POST['nonce'] ) || ! wp_verify_nonce( $_POST['nonce'], 'jetnews_magazine_admin_nonce' ) ) {
		wp_send_json_error( array( 'message' => 'Nonce verification failed.' ) );
		return;
	}
	$result = update_option( 'jetnews_magazine_dismissed_custom_notice', 1 );

	if ( $result ) {
		wp_send_json_success();
	} else {
		wp_send_json_error( array( 'message' => 'Failed to update option' ) );
	}
}
add_action( 'wp_ajax_jetnews_magazine_dismissble_notice', 'jetnews_magazine_dismissble_notice' );

// Hook into a custom action when the button is clicked.
add_action( 'wp_ajax_jetnews_magazine_install_and_activate_plugins', 'jetnews_magazine_install_and_activate_plugins' );
add_action( 'wp_ajax_nopriv_jetnews_magazine_install_and_activate_plugins', 'jetnews_magazine_install_and_activate_plugins' );
add_action( 'wp_ajax_jetnews_magazine_rplugin_activation', 'jetnews_magazine_rplugin_activation' );
add_action( 'wp_ajax_nopriv_jetnews_magazine_rplugin_activation', 'jetnews_magazine_rplugin_activation' );

function jetnews_magazine_check_plugin_installed_status( $pugin_slug, $plugin_file ) {
	return file_exists( ABSPATH . 'wp-content/plugins/' . $pugin_slug . '/' . $plugin_file ) ? true : false;
}

/* Check if plugin is activated */
function jetnews_magazine_check_plugin_active_status( $pugin_slug, $plugin_file ) {
	return is_plugin_active( $pugin_slug . '/' . $plugin_file ) ? true : false;
}

require_once ABSPATH . 'wp-admin/includes/plugin-install.php';
require_once ABSPATH . 'wp-admin/includes/file.php';
require_once ABSPATH . 'wp-admin/includes/misc.php';
require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
function jetnews_magazine_install_and_activate_plugins() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}
	check_ajax_referer( 'jetnews_magazine_welcome_nonce', 'nonce' );
	// Define the plugins to be installed and activated
	$recommended_plugins = array(
		array(
			'slug' => 'cozy-addons',
			'file' => 'cozy-addons.php',
			'name' => __( 'Cozy Addons', 'jetnews-magazine' ),
		),
		array(
			'slug' => 'advanced-import',
			'file' => 'advanced-import.php',
			'name' => __( 'Advanced Imporrt', 'jetnews-magazine' ),
		),
		array(
			'slug' => 'cozy-essential-addons',
			'file' => 'cozy-essential-addons.php',
			'name' => __( 'Cozy Essential Addons', 'jetnews-magazine' ),
		),
		// Add more plugins here as needed
	);

	// Include the necessary WordPress functions

	// Set up a transient to store the installation progress
	// set_transient( 'install_and_activate_progress', array(), MINUTE_IN_SECONDS * 10 );

	// Loop through each plugin
	foreach ( $recommended_plugins as $plugin ) {
		$plugin_slug = $plugin['slug'];
		$plugin_file = $plugin['file'];
		$plugin_name = $plugin['name'];

		$redirect_url = admin_url( 'themes.php?page=about-jetnews-magazine' );

		// Check if the plugin is active
		if ( is_plugin_active( $plugin_slug . '/' . $plugin_file ) ) {
			// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Already Active' );
			continue; // Skip to the next plugin
		}

		// Check if the plugin is installed but not active
		if ( is_jetnews_magazine_plugin_installed( $plugin_slug . '/' . $plugin_file ) ) {
			$activate = activate_plugin( $plugin_slug . '/' . $plugin_file, $redirect_url, false, true );
			if ( is_wp_error( $activate ) ) {
				// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Error' );
				continue; // Skip to the next plugin
			}
			// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Activated' );
			continue; // Skip to the next plugin
		}

		// Plugin is not installed or activated, proceed with installation
		// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Installing' );

		// Fetch plugin information
		$api = plugins_api(
			'plugin_information',
			array(
				'slug'   => $plugin_slug,
				'fields' => array( 'sections' => false ),
			)
		);

		// Check if plugin information is fetched successfully
		if ( is_wp_error( $api ) ) {
			// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Error' );
			continue; // Skip to the next plugin
		}

		// Set up the plugin upgrader
		$upgrader = new Plugin_Upgrader();
		$install  = $upgrader->install( $api->download_link );

		// Check if installation is successful
		if ( $install ) {
			// Activate the plugin
			$activate = activate_plugin( $plugin_slug . '/' . $plugin_file, $redirect_url, false, true );

			// Check if activation is successful
			if ( is_wp_error( $activate ) ) {
				// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Error' );
				continue; // Skip to the next plugin
			}
			// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Activated' );
		}
	}

	// Delete the progress transient
	// delete_transient( 'install_and_activate_progress' );
	// Return JSON response
	wp_send_json_success( array( 'redirect_url' => $redirect_url ) );
}

/**
 * Checks if a specific plugin is installed.
 *
 * This function checks if a plugin, identified by its slug, is installed and available
 * in the WordPress plugin directory. It retrieves the list of all installed plugins
 * and checks if the plugin with the given slug exists.
 *
 * @param string $plugin_slug The slug of the plugin to check.
 *
 * @return bool True if the plugin is installed, false otherwise.
 *
 * @uses get_plugins() Retrieves the list of installed plugins.
 */
function is_jetnews_magazine_plugin_installed( $plugin_slug ) {
	$plugins = get_plugins();
	return isset( $plugins[ $plugin_slug ] );
}

/**
 * Updates the progress of plugin installation and activation.
 *
 * This function updates the progress of a plugin installation or activation by
 * adding the plugin name and its status to a transient. The progress data is
 * stored temporarily and can be retrieved later to show the installation/activation
 * progress of multiple plugins.
 *
 * The progress data is stored as an array of plugin names with their respective statuses
 * (e.g., "Activated", "Error") and is saved in a transient for a limited period (10 minutes).
 *
 * @param string $plugin_name The name of the plugin being installed or activated.
 * @param string $status      The status of the plugin installation or activation (e.g., "Activated", "Error").
 *
 * @return void
 *
 * @uses get_transient() Retrieves the current progress stored in a transient.
 * @uses set_transient() Saves the updated progress back into the transient.
 */
function jetnews_magazine_update_install_and_activate_progress( $plugin_name, $status ) {
	$progress   = get_transient( 'install_and_activate_progress' );
	$progress[] = array(
		'plugin' => $plugin_name,
		'status' => $status,
	);
	set_transient( 'install_and_activate_progress', $progress, MINUTE_IN_SECONDS * 10 );
}


function jetnews_magazine_dashboard_menu() {
	add_theme_page( esc_html__( 'About JetNews Magazine', 'jetnews-magazine' ), esc_html__( 'About JetNews Magazine', 'jetnews-magazine' ), 'edit_theme_options', 'about-jetnews-magazine', 'jetnews_magazine_theme_info_display' );
}
add_action( 'admin_menu', 'jetnews_magazine_dashboard_menu' );

/**
 * Displays theme information by including the dashboard template.
 *
 * This function is used to display theme-related information by including the
 * `dashboard.php` file from the theme's `inc/admin` directory. It is typically
 * invoked in the admin dashboard or a settings page to show relevant theme details.
 *
 * @return void
 *
 * @uses require_once() Includes the 'dashboard.php' file to display theme information.
 */
function jetnews_magazine_theme_info_display() {
	// Dashboard.
	require_once JETNEWS_MAGAZINE_DIR . 'inc/admin/dashboard.php';
}

/**
 * Handles the activation of a plugin via an AJAX request.
 *
 * This function processes an AJAX request to activate a plugin. It checks for required
 * parameters (plugin slug, filename, and name) and activates the specified plugin.
 * If the activation is successful, it updates the installation and activation progress.
 * If an error occurs during the activation, it logs the error and returns a failure response.
 *
 * The function uses a nonce (`jetnews_magazine_admin_nonce`) to ensure the request is valid
 * and comes from an authorized source.
 *
 * @return void
 *
 * @uses check_ajax_referer() Ensures the request is valid by checking the nonce.
 * @uses activate_plugin() Attempts to activate the plugin using its filename.
 * @uses jetnews_magazine_update_install_and_activate_progress() Updates the installation and activation progress.
 * @uses wp_send_json_success() Sends a success response in JSON format.
 * @uses wp_send_json_error() Sends an error response in JSON format.
 */
function jetnews_magazine_rplugin_activation() {
	if ( ! current_user_can( 'manage_options' ) ) {
		return;
	}

	check_ajax_referer( 'jetnews_magazine_admin_nonce', 'nonce', true );

	$redirect_url = admin_url( 'themes.php?page=about-jetnews-magazine' );

	if ( isset( $_POST['pluginSlug'], $_POST['pluginFilename'], $_POST['pluginName'] ) ) {
		$plugin_slug     = sanitize_text_field( wp_unslash( $_POST['pluginSlug'] ) );
		$plugin_filename = sanitize_text_field( wp_unslash( $_POST['pluginFilename'] ) );
		$plugin_name     = sanitize_text_field( wp_unslash( $_POST['pluginName'] ) );

		if ( file_exists( trailingslashit( WP_PLUGIN_DIR ) . $plugin_filename ) ) {
			$activate = activate_plugin( $plugin_filename, $redirect_url, false, true );
		} else {
			// Fetch plugin information
			$api = plugins_api(
				'plugin_information',
				array(
					'slug'   => $plugin_slug,
					'fields' => array( 'sections' => false ),
				)
			);

			$upgrader = new Plugin_Upgrader();
			$install  = $upgrader->install( $api->download_link );

			if ( $install ) {
				$activate = activate_plugin( $plugin_filename, $redirect_url, false, true );
			}
		}

		// if ( is_wp_error( $activate ) ) {
		// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Error' );
		// }

		// jetnews_magazine_update_install_and_activate_progress( $plugin_name, 'Activated' );

		wp_send_json_success();

	} else {
		wp_send_json_error( 'Error: Missing parameters.' );
	}
}