<?php
if ( ! defined( 'JETNEWS_MAGAZINE_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'JETNEWS_MAGAZINE_VERSION', wp_get_theme()->get( 'Version' ) );
}
define( 'JETNEWS_MAGAZINE_DEBUG', defined( 'WP_DEBUG' ) && WP_DEBUG === true );
define( 'JETNEWS_MAGAZINE_DIR', trailingslashit( get_template_directory() ) );
define( 'JETNEWS_MAGAZINE_URL', trailingslashit( get_template_directory_uri() ) );

if ( ! function_exists( 'jetnews_magazine_support' ) ) :

	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * @since walker_fse 1.0.0
	 *
	 * @return void
	 */
	function jetnews_magazine_support() {
		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );
		// Add support for block styles.
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'post-thumbnails' );
		// Enqueue editor styles.
		add_editor_style( 'style.css' );
		// Removing default patterns.
		remove_theme_support( 'core-block-patterns' );
	}

endif;
add_action( 'after_setup_theme', 'jetnews_magazine_support' );

/*
----------------------------------------------------------------------------------
Enqueue Styles
-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'jetnews_magazine_styles' ) ) :
	function jetnews_magazine_styles() {
		// registering style for theme
		wp_enqueue_style( 'jetnews-magazine-style', get_stylesheet_uri(), array(), JETNEWS_MAGAZINE_VERSION );
		wp_enqueue_style( 'jetnews-magazine-blocks-style', get_template_directory_uri() . '/assets/css/blocks.css' );
		wp_enqueue_style( 'jetnews-magazine-swiper-bundle-style', get_template_directory_uri() . '/assets/css/swiper-bundle.css' );
		wp_enqueue_style( 'jetnews-magazine-aos-style', get_template_directory_uri() . '/assets/css/aos.css' );
		if ( is_rtl() ) {
			wp_enqueue_style( 'jetnews-magazine-rtl-css', get_template_directory_uri() . '/assets/css/rtl.css', 'rtl_css' );
		}
		wp_enqueue_script( 'jquery' );
		wp_enqueue_script( 'jetnews-magazine-swiper-bundle-scripts', get_template_directory_uri() . '/assets/js/swiper-bundle.js', array(), JETNEWS_MAGAZINE_VERSION, true );
		wp_enqueue_script( 'jetnews-magazine-aos-scripts', get_template_directory_uri() . '/assets/js/aos.js', array(), JETNEWS_MAGAZINE_VERSION, true );
		wp_enqueue_script( 'jetnews-magazine-scripts', get_template_directory_uri() . '/assets/js/jetnews-magazine-scripts.js', array(), JETNEWS_MAGAZINE_VERSION, true );
	}
endif;

add_action( 'wp_enqueue_scripts', 'jetnews_magazine_styles' );

/**
 * Enqueue scripts for admin area
 */
function jetnews_magazine_admin_style() {
	$hello_notice_current_screen = get_current_screen();
	if ( ! empty( $_GET['page'] ) && 'about-jetnews-magazine' === $_GET['page'] || $hello_notice_current_screen->id === 'themes' || $hello_notice_current_screen->id === 'dashboard' ) {
		wp_enqueue_style( 'jetnews-magazine-admin-style', get_template_directory_uri() . '/inc/admin/css/admin-style.css', array(), JETNEWS_MAGAZINE_VERSION, 'all' );
		wp_enqueue_script( 'jetnews-magazine-admin-scripts', get_template_directory_uri() . '/inc/admin/js/jetnews-magazine-admin-scripts.js', array(), JETNEWS_MAGAZINE_VERSION, true );
		wp_localize_script(
			'jetnews-magazine-admin-scripts',
			'jetnews_magazine_admin_localize',
			array(
				'ajax_url'     => admin_url( 'admin-ajax.php' ),
				'nonce'        => wp_create_nonce( 'jetnews_magazine_admin_nonce' ),
				'welcomeNonce' => wp_create_nonce( 'jetnews_magazine_welcome_nonce' ),
				'redirect_url' => admin_url( 'themes.php?page=about-jetnews-magazine' ),
				'scrollURL'    => admin_url( 'plugins.php?cozy-addons-scroll=true' ),
				'demoURL'      => admin_url( 'themes.php?page=advanced-import' ),
			)
		);
	}
}
add_action( 'admin_enqueue_scripts', 'jetnews_magazine_admin_style' );

/**
 * Enqueue assets scripts for both backend and frontend
 */
function jetnews_magazine_block_assets() {
	wp_enqueue_style( 'jetnews-magazine-blocks-style', get_template_directory_uri() . '/assets/css/blocks.css' );
}
add_action( 'enqueue_block_assets', 'jetnews_magazine_block_assets' );

/**
 * Load core file.
 */
require_once get_template_directory() . '/inc/core/init.php';

/**
 * Load welcome page file.
 */
require_once get_template_directory() . '/inc/admin/welcome-notice.php';

if ( ! function_exists( 'jetnews_magazine_excerpt_more_postfix' ) ) {
	function jetnews_magazine_excerpt_more_postfix( $more ) {
		if ( is_admin() ) {
			return $more;
		}
		return '...';
	}
	add_filter( 'excerpt_more', 'jetnews_magazine_excerpt_more_postfix' );
}
function jetnews_magazine_add_woocommerce_support() {
	add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'jetnews_magazine_add_woocommerce_support' );
