<?php
/**
 * Template part for Slider
 *
 * @package iweb-standard
 */

?>

<div class="iwebstandard-slider">
	<div class="iwebstandard-slider-w">
		<?php if ( null != get_theme_mod( 'iwebstandard_slider_title' ) ) : ?>
			<div class="iwebstandard-slider-a">
				<h1 class="iwebstandard-slider-tit"><?php echo esc_html( get_theme_mod( 'iwebstandard_slider_title' ) );?></h1>
			</div>
		<?php endif; ?>
	<div class="iwebstandard-slider-b">

		<?php
			$iwebstandard_slider_cat = esc_html( get_theme_mod( 'iwebstandard_slider_category' ) );
				$iwebstandard_slider_args = array(
					'cat' => $iwebstandard_slider_cat,
					'post_status' => 'publish',
					'posts_per_page' => 3,
				);
				$iwebstandard_slider_query = new WP_Query( $iwebstandard_slider_args );
				$iwebstandard_sld = 0;
				if ( get_theme_mod( 'iwebstandard_slider_category' ) != null ) :
					function iwebstandard_postcount( $id ) {
						$category = get_category( $id );
						return $category->category_count;
					}
					$iwebstandard_count = iwebstandard_postcount( $iwebstandard_slider_cat );
				else :
					$iwebstandard_count = 0;
				endif;
		?>
		<?php if ( get_theme_mod( 'iwebstandard_display_mslider','1' ) === '1' || '1' == $iwebstandard_count ) :
			if ( $iwebstandard_slider_query->have_posts() ) :
				$iwebstandard_slider_query->the_post();
		?>
		<div class="iwebstandard-slider-c">
			<div class="iwebstandard-slider-text">
				<h1><?php the_title();?></h1>
				<div class="iweb-show480">
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
				</div>
			</div>
		</div>
		<?php endif; ?>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'iwebstandard_display_mslider' ) === '0' and '1' < $iwebstandard_count ) : ?>

		<?php if ( $iwebstandard_slider_query->have_posts() ) : ?>
		<div class="iwebstandard-slider-c">
			<?php while ( $iwebstandard_slider_query->have_posts() ) :
					  $iwebstandard_slider_query->the_post();
		?>
		<?php if ( has_post_thumbnail() ) : ?>
			<?php $iwebstandard91_img = get_the_post_thumbnail_url( get_the_ID(),'full' ); ?>
		<?php else : ?>
			<?php $iwebstandard91_img = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );?>
		<?php endif; ?>

			<div class="iwebslides iwebstandard-slider-text">
					<h1><?php the_title();?></h1>
				<div class="iweb-show480">
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
				</div>
			</div>

		<?php $iwebstandard_sld++; ?>
		<?php  endwhile; ?>
		<?php wp_reset_postdata();?>
	</div>
		<?php endif; ?>
		<?php endif; ?>
	</div>
	<div class="iwebstandard-slider-d">
		<?php if ( null != get_theme_mod( 'iwebstandard_sldbt1_txt' ) ) : ?>
			<a class="iwebstandard-button" href="<?php echo esc_url( get_theme_mod( 'iwebstandard_sldbt1_url' ) ); ?>"><p id="iwebstandard-sldbt1-txt"><?php echo esc_attr( get_theme_mod( 'iwebstandard_sldbt1_txt' ) );?></p></a>
		<?php endif; ?>
		<?php if ( null != get_theme_mod( 'iwebstandard_sldbt2_txt' ) ) : ?>
			<a class="iwebstandard-button2" href="<?php echo esc_url( get_theme_mod( 'iwebstandard_sldbt2_url' ) ); ?>"><p id="iwebstandard-sldbt2-txt"><?php echo esc_attr( get_theme_mod( 'iwebstandard_sldbt2_txt' ) );?></p></a>
		<?php endif; ?>
	</div>
	</div>
	<?php if ( get_theme_mod( 'iwebstandard_display_mslider' ) === '0' and '1' < $iwebstandard_count ) : ?>
	<div class="iwebstandard-slider-e">
			<span class="iwebstandard-sld-dot"></span>
			<?php if ( $iwebstandard_sld > 1 ) :?>
				<span class="iwebstandard-sld-dot"></span>
				<?php if ( $iwebstandard_sld > 2 ) :?>
					<span class="iwebstandard-sld-dot"></span>
					<?php if ( $iwebstandard_sld > 3 ) :?>
						<span class="iwebstandard-sld-dot"></span>
					<?php endif; ?><?php endif; ?><?php endif; ?>
	</div>
	<?php endif; ?>

</div>

