<?php
/**
 * Template part for displaying posts in a category
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package iweb-standard
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="iwebpagibord"></div>
   <div class="iwebstandard-arch-b">
		<?php
		if ( has_post_thumbnail() ) :
			$iwebstandard_arch_img = get_the_post_thumbnail_url( get_the_ID(),'full' );
		else :
			$iwebstandard_arch_img = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
		endif;
			$iwebstandard_arch_date = get_the_date();
		?>
		<div class="iwebstandard-arch-b1">
			<div class="iwebstandard-arch-b2">
				<a href="<?php the_permalink(); ?>"><img src="<?php echo esc_url( $iwebstandard_arch_img );?>" alt="<?php the_title(); ?>" /></a>
			</div><!--

			--><div class="iwebstandard-arch-b3">
				<a href="<?php the_permalink(); ?>"><h3><?php the_title();?></h3></a>
				<p class="entry-meta"><?php the_weekday();?>, <?php echo esc_html( $iwebstandard_arch_date );?></p>
				<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
				 add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );?>
						<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
				<div class="entry-meta">
					<?php echo esc_html__( 'Category: ', 'iweb-standard' );?><?php the_category( ' | ' ) ?>
				</div>

			</div>
		</div>
	</div>

	<footer class="entry-footer">

	</footer><!-- .entry-footer -->

</article><!-- #post-<?php the_ID(); ?> -->
