<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * Template Name: Front Page
 * @package iwebstandard
 */

	get_header();
?>

<div  class="content-area">
	<main id="main" class="site-main" role="main">

		<?php  get_template_part( 'template-parts/iwebstandard-slider' ); ?>

<!-- About Us  -->

<?php if ( get_theme_mod( 'iwebstandard_display_aboutus','0' ) === '1' ) :?>
		<div class="iwebstandard-aboutus">
			<div class="iwebstandard-aboutus-w">
			<?php
				$iwebstandard_aboutus_cat = get_theme_mod( 'iwebstandard_aboutus_catg1' );
			if ( '0' != $iwebstandard_aboutus_cat ) :
					$iwebstandard_aboutus_args = array(
						'page_id' => $iwebstandard_aboutus_cat,
						'post_type' => 'page',
						'post_status' => 'publish',
						'posts_per_page' => 1,
					);
					$iwebstandard_aboutus_query = new WP_Query( $iwebstandard_aboutus_args );
				if ( $iwebstandard_aboutus_query->have_posts() ) :
					while ( $iwebstandard_aboutus_query->have_posts() ) :
						$iwebstandard_aboutus_query->the_post();
			?>
			<div class="iwebstandard-aboutus-a1">
				<h4><?php the_title();?></h4>
				<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
				 add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );?>
						<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
			</div>
			<div class="iwebstandard-aboutus-a1">
				<div class="iwebstandard-aboutus-82"></div>
				<?php if ( has_post_thumbnail() ) :?>
					<?php the_post_thumbnail( 'full' );?>
				<?php else : ?>
					<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
				<?php endif; ?>
			</div>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>

			<?php
				$iwebstandard_aboutus2_cat = get_theme_mod( 'iwebstandard_aboutus_catg2' );
			if ( '0' != $iwebstandard_aboutus2_cat ) :
					$iwebstandard_aboutus2_args = array(
						 'cat' => $iwebstandard_aboutus2_cat,
						 'post_status' => 'publish',
						 'posts_per_page' => 1,
					);
					$iwebstandard_aboutus2_query = new WP_Query( $iwebstandard_aboutus2_args );
			?>
			<div class="iwebstandard-aboutus-b1">
				<?php if ( $iwebstandard_aboutus2_query->have_posts() ) :
					while ( $iwebstandard_aboutus2_query->have_posts() ) :
						$iwebstandard_aboutus2_query->the_post();
						$iwebstandard_aboutus_content = get_the_content();
						$iwebstandard_aboutus_content = strip_tags( $iwebstandard_aboutus_content );
						$iwebstandard_aboutus_cont = explode( '*', $iwebstandard_aboutus_content, 6 );
				?>
				<h4><?php the_title();?></h4>

				<?php if ( array_key_exists( 1,$iwebstandard_aboutus_cont ) ) :?>
					<li><?php echo esc_html( $iwebstandard_aboutus_cont[1] );?></li>
				<?php if ( array_key_exists( 2,$iwebstandard_aboutus_cont ) ) :?>
					<li><?php echo esc_html( $iwebstandard_aboutus_cont[2] );?></li>
				<?php if ( array_key_exists( 3,$iwebstandard_aboutus_cont ) ) :?>
					<li><?php echo esc_html( $iwebstandard_aboutus_cont[3] );?></li>
				<?php if ( array_key_exists( 4,$iwebstandard_aboutus_cont ) ) :?>
					<li><?php echo esc_html( $iwebstandard_aboutus_cont[4] );?></li>
				<?php if ( array_key_exists( 5,$iwebstandard_aboutus_cont ) ) :?>
					<li><?php echo esc_html( $iwebstandard_aboutus_cont[5] );?></li>
				<?php endif; ?><?php endif; ?><?php endif; ?><?php endif; ?><?php endif; ?>

				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
			</div>
				<?php endif; ?>

			</div>
		</div>
<?php endif; ?>

<!-- END - About Us  -->

<!-- Services  -->

<?php if ( get_theme_mod( 'iwebstandard_display_services','0' ) === '1' ) :?>
<div class="iwebstandard-services">
	<div class="iwebstandard-services-w">
	<div class="iwebstandard-services-a">
		<?php if ( null != get_theme_mod( 'iwebstandard_services_title' ) ) :?>
		<div class="iwebstandard-services-a1">
			<h1><?php echo esc_html( get_theme_mod( 'iwebstandard_services_title' ) );?></h1>
		</div>
	<?php endif; ?>
	</div>
		<div class="iwebstandard-services-bb">
		<?php
		$iwebstandard_services_cat = get_theme_mod( 'iwebstandard_services_catg' );
		$iwebstandard_ser1 = 1;
		if ( '0' != $iwebstandard_services_cat ) :
			$iwebstandard_services_args = array(
				'cat' => $iwebstandard_services_cat,
				'post_status' => 'publish',
				'posts_per_page' => 5,
				);
				$iwebstandard_services_query = new WP_Query( $iwebstandard_services_args );
			if ( $iwebstandard_services_query->have_posts() ) :
				while ( $iwebstandard_services_query->have_posts() ) :
					$iwebstandard_services_query->the_post();
		?>
		<?php if ( 1 == $iwebstandard_ser1 || 4 == $iwebstandard_ser1 ) : ?>
		<div class="iwebstandard-services-b">
		<?php endif; ?>
			<?php if ( 1 == $iwebstandard_ser1 || 2 == $iwebstandard_ser1 || 4 == $iwebstandard_ser1 || 5 == $iwebstandard_ser1 ) : ?>
			<div class="iwebstandard-services-b1">
				<?php if ( has_post_thumbnail() ) :?>
					<?php the_post_thumbnail( 'full' );?>
				<?php else : ?>
					<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
				<?php endif; ?>
				<h6><?php the_title();?></h6>
				<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length15' );
				add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length15' );?>
			</div>
			<?php endif; ?>
		<?php if ( 2 == $iwebstandard_ser1 || 5 == $iwebstandard_ser1 ) : ?>
		</div>
		<?php endif; ?>

		<?php if ( 3 == $iwebstandard_ser1 ) : ?>
			<div class="iwebstandard-services-b">
				<h5><?php the_title();?></h5>
				<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
				add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
			</div>
		<?php endif; ?>

	<?php $iwebstandard_ser1++ ;?>
	<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
	<?php endif; ?>
	<?php endif; ?>
</div>
</div>
</div>
<?php endif; ?>

<!-- END - Services  -->

<!-- Features Section 1 -->

<?php if ( get_theme_mod( 'iwebstandard_display_featureds1','0' ) === '1' ) :?>
<div class="iwebstandard-featureds1">
	<div class="iwebstandard-featureds1-w">
		<h1 id="iwebstandard_fs1_tit"><?php echo esc_html( get_theme_mod( 'iwebstandard_featureds1_title',__( 'Featured Section 1', 'iweb-standard' ) ) );?></h1>
		<div class="iwebstandard-featureds1-ab">
			<?php
			$iwebstandard_featureds1_cat = get_theme_mod( 'iwebstandard_featureds1_catg' );

			if ( '0' != $iwebstandard_featureds1_cat ) :
				$iwebstandard_featureds1_args = array(
					'cat' => $iwebstandard_featureds1_cat,
					'post_status' => 'publish',
					'posts_per_page' => 2,
					);
					$iwebstandard_featureds1_query = new WP_Query( $iwebstandard_featureds1_args );
					$iwebstandard_featureds1_v1 = 1;
				if ( $iwebstandard_featureds1_query->have_posts() ) :
					while ( $iwebstandard_featureds1_query->have_posts() ) :
						$iwebstandard_featureds1_query->the_post();
			?>

				<?php if ( 1 == $iwebstandard_featureds1_v1 ) :?>
				<div class="iwebstandard-featureds1-a">
					<?php if ( has_post_thumbnail() ) :?>
						<a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'full' );?></a>
					<?php else : ?>
						<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
					<?php endif; ?>
				</div><!--
				<?php endif; ?>
				<?php if ( 1 == $iwebstandard_featureds1_v1 ) :?>
				--><div class="iwebstandard-featureds1-b">
				<?php endif; ?>
					<h5><?php the_title();?></h5>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>

				<?php $iwebstandard_featureds1_v1++ ;?>
				<?php endwhile; ?>
			</div>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>
		   </div>

	</div>
</div>
<?php endif; ?>

<!-- END - Features Section 1  -->

<!-- Features Section 2 -->

<?php if ( get_theme_mod( 'iwebstandard_display_featureds2','0' ) === '1' ) :?>
<div class="iwebstandard-featureds2">
	<div class="iwebstandard-featureds2-w">
			<div class="iwebstandard-featureds2-b iweb-hide968">
				<?php if ( get_theme_mod( 'iwebstandard_featureds2_bgimg' ) == null ) :?>
						<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'Featured Section 1','iweb-standard' );?>" />
				<?php else : ?>
						<img src="<?php echo esc_url( get_theme_mod( 'iwebstandard_featureds2_bgimg' ) );?>" alt="<?php echo esc_attr__( 'Featured Section 1','iweb-standard' );?>"/>
				<?php endif; ?>
			</div>
		<div class="iwebstandard-featureds2-a">
			<?php
			$iwebstandard_featureds2_cat = get_theme_mod( 'iwebstandard_featureds2_catg' );

			if ( '0' != $iwebstandard_featureds2_cat ) :
				$iwebstandard_featureds2_args = array(
					'cat' => $iwebstandard_featureds2_cat,
					'post_status' => 'publish',
					'posts_per_page' => 4,
					);
					$iwebstandard_featureds2_query = new WP_Query( $iwebstandard_featureds2_args );
				if ( $iwebstandard_featureds2_query->have_posts() ) :
					while ( $iwebstandard_featureds2_query->have_posts() ) :
						$iwebstandard_featureds2_query->the_post();
			?>
			<div class="iwebstandard-featureds2-ax">
				<div class="iwebstandard-featureds2-a1">
					<i class="fa fa-check" aria-hidden="true"></i>
				</div>
				<div class="iwebstandard-featureds2-a2">
					<h5><?php the_title();?></h5>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
				</div><br>
			</div>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>
			</div>
			<div class="iwebstandard-featureds2-b iweb-show968">
				<?php if ( get_theme_mod( 'iwebstandard_featureds2_bgimg' ) == null ) :?>
						<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'Featured Section 1','iweb-standard' );?>" />
				<?php else : ?>
						<img src="<?php echo esc_url( get_theme_mod( 'iwebstandard_featureds2_bgimg' ) );?>" alt="<?php echo esc_attr__( 'Featured Section 1','iweb-standard' );?>"/>
				<?php endif; ?>
			</div>
		</div>
</div>
<?php endif; ?>

<!-- END - Features Section 2  -->

<!-- Features Section 3 -->

<?php if ( get_theme_mod( 'iwebstandard_display_featureds3','0' ) === '1' ) :?>
<div class="iwebstandard-featureds3">
	<div class="iwebstandard-featureds3-w">

			<?php
			$iwebstandard_featureds3_cat = get_theme_mod( 'iwebstandard_featureds3_catg' );

			if ( '0' != $iwebstandard_featureds3_cat ) :
				$iwebstandard_featureds3_args = array(
					'cat' => $iwebstandard_featureds3_cat,
					'post_status' => 'publish',
					'posts_per_page' => 2,
					);
					$iwebstandard_featureds3_query = new WP_Query( $iwebstandard_featureds3_args );
					$iwebstandard_featureds3_v1 = 1;
				if ( $iwebstandard_featureds3_query->have_posts() ) :
					while ( $iwebstandard_featureds3_query->have_posts() ) :
						$iwebstandard_featureds3_query->the_post();
						$iwebstandard_featureds3_thum = get_the_post_thumbnail_url( get_the_ID(),'full' );
			?>
			<?php if ( has_post_thumbnail() ) :
				$iwebstandard_featureds3_thum = get_the_post_thumbnail_url( get_the_ID(),'full' );
			else :
				$iwebstandard_featureds3_thum = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
			endif; ?>

		<?php if ( 1 == $iwebstandard_featureds3_v1 ) : ?>
		<div class="iwebstandard-featureds3-a1" style="background-image: url( <?php echo esc_url( $iwebstandard_featureds3_thum ); ?> );">

		</div><!--
		--><div class="iwebstandard-featureds3-a2">
			<div class="iwebstandard-featureds3-a2x">
			<i class="fa <?php echo esc_attr( get_theme_mod( 'iwebstandard_fafs3_icon1' ) );?>" aria-hidden="true"></i>
			<h3><?php the_title();?></h3>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
			<a href="<?php the_permalink(); ?>"><p id="iwebstandard-fs3-bt1"><?php echo esc_attr( get_theme_mod( 'iwebstandard_fs3bt_txt1' ) );?></p></a>
		</div>
		</div>
		<?php endif; ?>
		<?php if ( 2 == $iwebstandard_featureds3_v1 ) : ?>
		<div class="iwebstandard-featureds3-a3">
		<i class="fa <?php echo esc_attr( get_theme_mod( 'iwebstandard_fafs3_icon2' ) );?>" aria-hidden="true"></i>
			<h3><?php the_title();?></h3>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
			<a href="<?php the_permalink(); ?>"><p id="iwebstandard-fs3-bt2"><?php echo esc_attr( get_theme_mod( 'iwebstandard_fs3bt_txt2' ) );?></p></a>
		</div><!--
		--><?php endif; ?>
				<?php $iwebstandard_featureds3_v1++ ;?>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>
	</div>
</div>
<?php endif; ?>

<!-- END - Features Section 3  -->

<!-- Our Team -->

<?php if ( get_theme_mod( 'iwebstandard_ourtim_display', '0' ) === '1' ) :?>

<div class="iwebstandard-ourtim">
	<div class="iwebstandard-ourtim-w">

			<?php
					$iwebstandard_ourteam_v1 = 1;
					$iwebstandard_ourteam_v10 = 0;
					$iwebstandard_ourteam_v20 = 0;
					$iwebstandard_ourteam_v30 = 0;
					$iwebstandard_ourteam_v40 = 0;
					$iwebstandard_ourteam_img1 = '';
					$iwebstandard_ourteam_img2 = '';
					$iwebstandard_ourteam_img3 = '';
					$iwebstandard_ourteam_img4 = '';
					$iwebstandard_ourteam_title10 = '';
					$iwebstandard_ourteam_title11 = '';
					$iwebstandard_ourteam_title12 = '';
					$iwebstandard_ourteam_title20 = '';
					$iwebstandard_ourteam_title21 = '';
					$iwebstandard_ourteam_title22 = '';
					$iwebstandard_ourteam_title30 = '';
					$iwebstandard_ourteam_title31 = '';
					$iwebstandard_ourteam_title32 = '';
					$iwebstandard_ourteam_title40 = '';
					$iwebstandard_ourteam_title41 = '';
					$iwebstandard_ourteam_title42 = '';
					$iwebstandard_ourteam_excp1 = '';
					$iwebstandard_ourteam_excp2 = '';
					$iwebstandard_ourteam_excp3 = '';
					$iwebstandard_ourteam_excp4 = '';
			$iwebstandard_ourteam_cat = get_theme_mod( 'iwebstandard_ourtim_catg' );

			if ( '0' != $iwebstandard_ourteam_cat ) :
				$iwebstandard_ourteam_args = array(
					'cat' => $iwebstandard_ourteam_cat,
					'post_status' => 'publish',
					'posts_per_page' => 4,
					);
					$iwebstandard_ourteam_query = new WP_Query( $iwebstandard_ourteam_args );
			?>

				<?php if ( $iwebstandard_ourteam_query->have_posts() ) :
					while ( $iwebstandard_ourteam_query->have_posts() ) :
						$iwebstandard_ourteam_query->the_post();
						$iwebstandard_ourteam_z1 = 0 ;
						$iwebstandard_ourtim_tit = esc_html( get_the_title() );
						$iwebstandard_ourteam_title = explode( ',', $iwebstandard_ourtim_tit, 2 );

						if ( strpos( $iwebstandard_ourtim_tit, ',' ) !== false ) {
							$iwebstandard_ourteam_title = explode( ',', $iwebstandard_ourtim_tit, 2 );
							$iwebstandard_ourteam_z1 = 1 ;
						}
			?>
				<?php if ( 1 == $iwebstandard_ourteam_v1 ) :?>
					<?php if ( has_post_thumbnail() ) :
						$iwebstandard_ourteam_img1 = esc_url( get_the_post_thumbnail_url( get_the_ID(),'full' ) );
					else :
						$iwebstandard_ourteam_img1 = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
					endif; ?>

					<?php if ( 1 == $iwebstandard_ourteam_z1 ) :
						$iwebstandard_ourteam_title10 = $iwebstandard_ourteam_title[0];
						$iwebstandard_ourteam_title11 = $iwebstandard_ourteam_title[1];
					else :
						$iwebstandard_ourteam_title12 = $iwebstandard_ourtim_tit;
					endif; ?>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						$iwebstandard_ourteam_excp1 = esc_html( get_the_excerpt() );
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
					<?php $iwebstandard_ourteam_v10 = 1; ?>
				<?php endif; ?>

				<?php if ( 2 == $iwebstandard_ourteam_v1 ) :?>
					<?php if ( has_post_thumbnail() ) :
						$iwebstandard_ourteam_img2 = esc_url( get_the_post_thumbnail_url( get_the_ID(),'full' ) );
					else :
						$iwebstandard_ourteam_img2 = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
					endif; ?>

					<?php if ( 1 == $iwebstandard_ourteam_z1 ) :
						$iwebstandard_ourteam_title20 = $iwebstandard_ourteam_title[0];
						$iwebstandard_ourteam_title21 = $iwebstandard_ourteam_title[1];
					else :
						$iwebstandard_ourteam_title22 = $iwebstandard_ourtim_tit;
					endif; ?>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						$iwebstandard_ourteam_excp2 = esc_html( get_the_excerpt() );
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
					<?php $iwebstandard_ourteam_v20 = 1; ?>
				<?php endif; ?>

				<?php if ( 3 == $iwebstandard_ourteam_v1 ) :?>
					<?php if ( has_post_thumbnail() ) :
						$iwebstandard_ourteam_img3 = esc_url( get_the_post_thumbnail_url( get_the_ID(),'full' ) );
					else :
						$iwebstandard_ourteam_img3 = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
					endif; ?>

					<?php if ( 1 == $iwebstandard_ourteam_z1 ) :
						$iwebstandard_ourteam_title30 = $iwebstandard_ourteam_title[0];
						$iwebstandard_ourteam_title31 = $iwebstandard_ourteam_title[1];
					else :
						$iwebstandard_ourteam_title32 = $iwebstandard_ourtim_tit;
					endif; ?>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						$iwebstandard_ourteam_excp3 = esc_html( get_the_excerpt() );
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
					<?php $iwebstandard_ourteam_v30 = 1; ?>
				<?php endif; ?>

				<?php if ( 4 == $iwebstandard_ourteam_v1 ) :?>
					<?php if ( has_post_thumbnail() ) :
						$iwebstandard_ourteam_img4 = esc_url( get_the_post_thumbnail_url( get_the_ID(),'full' ) );
					else :
						$iwebstandard_ourteam_img4 = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
					endif; ?>

					<?php if ( 1 == $iwebstandard_ourteam_z1 ) :
						$iwebstandard_ourteam_title40 = $iwebstandard_ourteam_title[0];
						$iwebstandard_ourteam_title41 = $iwebstandard_ourteam_title[1];
					else :
						$iwebstandard_ourteam_title42 = $iwebstandard_ourtim_tit;
					endif; ?>

					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						$iwebstandard_ourteam_excp4 = esc_html( get_the_excerpt() );
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length20' );?>
					<?php $iwebstandard_ourteam_v40 = 1; ?>

				<?php endif; ?>
				<?php $iwebstandard_ourteam_v1++ ;?>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>

	<div class="iwebstandard-ourtim-a">
			 <div class="iwebstandard-ourtim-at">
				 <h1><?php echo esc_html( get_theme_mod( 'iwebstandard_ourtim_title',__( 'Experienced Team', 'iweb-standard' ) ) );?></h1>
			 </div>
		<?php if ( 1 == $iwebstandard_ourteam_v10 ) :?>
		<div class="iwebstandard-ourtim-butn">
			<button class="istandardtab buttm" onclick="openTeam(event, 'iotim1')" id="defaultOpenstdtm">
			<div class="iwebstandard-ourtim-at">
				<div class="iwebstandard-ourtim-a1">
					<img src="<?php echo esc_url( $iwebstandard_ourteam_img1 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-a2">
				<?php if ( null != $iwebstandard_ourteam_title12 ) : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title12 );?></p>
				<?php else : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title10 );?></p>
					<p><?php echo esc_html( $iwebstandard_ourteam_title11 );?></p>
				<?php endif; ?>
				</div>
			</div>
			</button>
		</div>
		<?php endif; ?>
		<?php if ( 1 == $iwebstandard_ourteam_v20 ) :?>
		<div class="iwebstandard-ourtim-butn">
			<button class="istandardtab buttm" onclick="openTeam(event, 'iotim2')">
			<div class="iwebstandard-ourtim-at">
				<div class="iwebstandard-ourtim-a1">
					<img src="<?php echo esc_url( $iwebstandard_ourteam_img2 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-a2">
				<?php if ( null != $iwebstandard_ourteam_title22 ) : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title22 );?></p>
				<?php else : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title20 );?></p>
					<p><?php echo esc_html( $iwebstandard_ourteam_title21 );?></p>
				<?php endif; ?>
				</div>
			</div>
			</button>
		</div>
		<?php endif; ?>
		<?php if ( 1 == $iwebstandard_ourteam_v30 ) :?>
		<div class="iwebstandard-ourtim-butn">
			<button class="istandardtab buttm" onclick="openTeam(event, 'iotim3')">
			<div class="iwebstandard-ourtim-at">
				<div class="iwebstandard-ourtim-a1">
					<img src="<?php echo esc_url( $iwebstandard_ourteam_img3 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-a2">
				<?php if ( null != $iwebstandard_ourteam_title32 ) : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title32 );?></p>
				<?php else : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title30 );?></p>
					<p><?php echo esc_html( $iwebstandard_ourteam_title31 );?></p>
				<?php endif; ?>
				</div>
			</div>
			</button>
		</div>
		<?php endif; ?>
		<?php if ( 1 == $iwebstandard_ourteam_v40 ) :?>
		<div class="iwebstandard-ourtim-butn">
			<button class="istandardtab buttm" onclick="openTeam(event, 'iotim4')">
			<div class="iwebstandard-ourtim-at">
				<div class="iwebstandard-ourtim-a1">
					<img src="<?php echo esc_url( $iwebstandard_ourteam_img4 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-a2">
				<?php if ( null != $iwebstandard_ourteam_title42 ) : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title42 );?></p>
				<?php else : ?>
					<p class="iwebstandard-ourtim-a2h6"><?php echo esc_html( $iwebstandard_ourteam_title40 );?></p>
					<p><?php echo esc_html( $iwebstandard_ourteam_title41 );?></p>
				<?php endif; ?>
				</div>
			</div>
			</button>
		</div>
		<?php endif; ?>
	</div>

		<div class="iwebstandard-ourtim-bb">
			<div id="iotim1" class="iwebstandard-ourtim-b istandardtm iweb-fadeInDown">
				<div class="iwebstandard-ourtim-b1">
						 <img src="<?php echo esc_url( $iwebstandard_ourteam_img1 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-b2">
				<?php if ( null != $iwebstandard_ourteam_title12 ) : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title12 );?></h4>
				<?php else : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title10 );?></h4>
					<p class="iwebstandard-ourtim-b2p iwebstandard-ourtim-b2-px"><?php echo esc_html( $iwebstandard_ourteam_title11 );?></p>
				<?php endif; ?>
					<p><?php echo esc_html( $iwebstandard_ourteam_excp1 ); ?></p>
				</div>
			</div>

			<div id="iotim2" class="iwebstandard-ourtim-b istandardtm iweb-fadeInDown">
				<div class="iwebstandard-ourtim-b1">
						 <img src="<?php echo esc_url( $iwebstandard_ourteam_img2 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-b2">
				<?php if ( null != $iwebstandard_ourteam_title22 ) : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title22 );?></h4>
				<?php else : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title20 );?></h4>
					<p class="iwebstandard-ourtim-b2p  iwebstandard-ourtim-b2-px"><?php echo esc_html( $iwebstandard_ourteam_title21 );?></p>
				<?php endif; ?>
					<p><?php echo esc_html( $iwebstandard_ourteam_excp2 ); ?></p>
				</div>
			</div>

			<div id="iotim3" class="iwebstandard-ourtim-b istandardtm iweb-fadeInDown">
				<div class="iwebstandard-ourtim-b1">
						 <img src="<?php echo esc_url( $iwebstandard_ourteam_img3 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-b2">
				<?php if ( null != $iwebstandard_ourteam_title32 ) : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title32 );?></h4>
				<?php else : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title30 );?></h4>
					<p class="iwebstandard-ourtim-b2p iwebstandard-ourtim-b2-px"><?php echo esc_html( $iwebstandard_ourteam_title31 );?></p>
				<?php endif; ?>
					<p><?php echo esc_html( $iwebstandard_ourteam_excp3 ); ?></p>
				</div>
			</div>

			<div id="iotim4" class="iwebstandard-ourtim-b istandardtm iweb-fadeInDown">
				<div class="iwebstandard-ourtim-b1">
						 <img src="<?php echo esc_url( $iwebstandard_ourteam_img4 );?>" alt="<?php echo esc_attr__( 'Our Team','iweb-standard' );?>"/>
				</div>
				<div class="iwebstandard-ourtim-b2">
				<?php if ( null != $iwebstandard_ourteam_title42 ) : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title42 );?></h4>
				<?php else : ?>
					<h4><?php echo esc_html( $iwebstandard_ourteam_title40 );?></h4>
					<p class="iwebstandard-ourtim-b2p iwebstandard-ourtim-b2-px"><?php echo esc_html( $iwebstandard_ourteam_title41 );?></p>
				<?php endif; ?>
					<p><?php echo esc_html( $iwebstandard_ourteam_excp4 ); ?></p>
				</div>
			</div>
		</div>

	</div>
</div>
<?php endif; ?>

<!-- END - Our Team -->

<!-- Testimonials Section  -->

<?php if ( get_theme_mod( 'iwebstandard_tmonials_display', '0' ) === '1' ) :?>
<div class="iwebstandard-tmonials">
	<div class="iwebstandard-tmonials-w">

		<div class="iwebstandard-tmonials-w1">
			<h1 id="iwebstandard_tmo_tit"><?php echo esc_html( get_theme_mod( 'iwebstandard_tmonials_title', __( 'WHAT CUSTOMERS SAY', 'iweb-standard' ) ) );?></h1>
			<?php
			$iwebstandard_tm_dt = 1;
			$iwebstandard_tmonials_cat = get_theme_mod( 'iwebstandard_tmonials_catg' );
			if ( 0 != $iwebstandard_tmonials_cat ) :
					$iwebstandard_tmonials_args = array(
						'cat' => $iwebstandard_tmonials_cat,
						'post_status' => 'publish',
						'posts_per_page' => 3,
					);
					$iwebstandard_tmonials_query = new WP_Query( $iwebstandard_tmonials_args );
				if ( get_theme_mod( 'iwebstandard_tmonials_catg' ) != null ) :
					function iwebstandard_postcount2( $id ) {
						$category = get_category( $id );
						return $category->category_count;
					}
					$iwebstandard_count2 = iwebstandard_postcount2( $iwebstandard_tmonials_cat );
				else :
					$iwebstandard_count2 = 0;
				endif;
				if ( '1' == $iwebstandard_count2 ) :
					if ( $iwebstandard_tmonials_query->have_posts() ) :
						while ( $iwebstandard_tmonials_query->have_posts() ) :
							$iwebstandard_tmonials_query->the_post();
							$iwebstandard_tmonials_v1 = 0 ;
							$iwebstandard_tmonials_title1 = esc_html( get_the_title() );
							if ( strpos( $iwebstandard_tmonials_title1, ',' ) !== false ) {
								$iwebstandard_tmonials_title = explode( ',', $iwebstandard_tmonials_title1, 2 );
								$iwebstandard_tmonials_v1 = 1 ;
							}
			?>
			<div class="iwebstandard-tmonials-a">
				<div class="iwebstandard-tmonials-a1">
					<div class="iwebstandard-tmonials-b">
						<div class="iwebstandard-tmonials-b1">
							<?php if ( has_post_thumbnail() ) :?>
								<?php the_post_thumbnail( 'full' );?>
							<?php else : ?>
								<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
							<?php endif; ?>
						</div>
						<div class="iwebstandard-tmonials-b2">
							<?php if ( 1 == $iwebstandard_tmonials_v1 ) : ?>
								<?php if ( null != $iwebstandard_tmonials_title[0] ) : ?>
							<p id="iwebstandard-tmonials-pc"><?php echo esc_html( $iwebstandard_tmonials_title[0] );?></p>
								<?php endif; ?>
								<?php if ( null != $iwebstandard_tmonials_title[1] ) : ?>
									<p class="iwebstandard-tmonials-b2-px"><?php echo esc_html( $iwebstandard_tmonials_title[1] );?></p>
								<?php endif; ?>
							<?php else : ?>
								<p id="iwebstandard-tmonials-pc"><?php echo esc_html( $iwebstandard_tmonials_title1 );?></p>
							<?php endif; ?>
						</div>
					</div>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );?>
						<?php the_excerpt();?>
					<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
				</div>

			</div>
					<?php $iwebstandard_tm_dt++ ;?>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
				<?php endif; ?>
			<?php endif;?>
			<?php
			if ( '1' < $iwebstandard_count2 ) :
				if ( $iwebstandard_tmonials_query->have_posts() ) :
					while ( $iwebstandard_tmonials_query->have_posts() ) :
						$iwebstandard_tmonials_query->the_post();
						$iwebstandard_tmonials_v1 = 0 ;
						$iwebstandard_tmonials_title1 = esc_html( get_the_title() );
						if ( strpos( $iwebstandard_tmonials_title1, ',' ) !== false ) {
							$iwebstandard_tmonials_title = explode( ',', $iwebstandard_tmonials_title1, 2 );
							$iwebstandard_tmonials_v1 = 1 ;
						}
			?>
			<div class="iwebstandard-tmonials-a iwebstandard-tmonials-sld">
				<div class="iwebstandard-tmonials-a1">
					<div class="iwebstandard-tmonials-b">
						<div class="iwebstandard-tmonials-b1">
							<?php if ( has_post_thumbnail() ) :?>
								<?php the_post_thumbnail( 'full' );?>
							<?php else : ?>
								<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
							<?php endif; ?>
						</div>
						<div class="iwebstandard-tmonials-b2">
							<?php if ( 1 == $iwebstandard_tmonials_v1 ) : ?>
								<?php if ( null != $iwebstandard_tmonials_title[0] ) : ?>
							<p id="iwebstandard-tmonials-pc"><?php echo esc_html( $iwebstandard_tmonials_title[0] );?></p>
								<?php endif; ?>
								<?php if ( null != $iwebstandard_tmonials_title[1] ) : ?>
									<p class="iwebstandard-tmon-b2-px"><?php echo esc_html( $iwebstandard_tmonials_title[1] );?></p>
								<?php endif; ?>
							<?php else : ?>
								<p id="iwebstandard-tmonials-pc"><?php echo esc_html( $iwebstandard_tmonials_title1 );?></p>
							<?php endif; ?>
						</div>
					</div>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );?>
						<?php the_excerpt();?>
					<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
				</div>

			</div>
					<?php $iwebstandard_tm_dt++ ;?>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
				<?php endif; ?>

				<div class="talign-c">
					<span class="iwebstandard-tmonials-dot"></span>
				<?php if ( $iwebstandard_tm_dt > 2 ) :?>
					<span class="iwebstandard-tmonials-dot"></span>
					<?php if ( 4 == $iwebstandard_tm_dt ) :?>
				  <span class="iwebstandard-tmonials-dot"></span><?php endif ;?><?php endif ;?>
				</div>
			<?php endif;?>

			<?php endif;?>

		</div><!--
		--><div class="iwebstandard-tmonials-w1">
			<h1><?php echo esc_html( get_theme_mod( 'iwebstandard_whyus_title', __( 'Why Us?', 'iweb-standard' ) ) );?></h1>
			<?php
			$iwebstandard_whyus_cat = get_theme_mod( 'iwebstandard_whyus_catg' );
			if ( 0 != $iwebstandard_whyus_cat ) :
					$iwebstandard_whyus_args = array(
					   'page_id' => $iwebstandard_whyus_cat,
					   'post_type' => 'page',
					   'post_status' => 'publish',
					   'posts_per_page' => 1,
					);
					$iwebstandard_whyus_query = new WP_Query( $iwebstandard_whyus_args );

				if ( $iwebstandard_whyus_query->have_posts() ) :
					while ( $iwebstandard_whyus_query->have_posts() ) :
						$iwebstandard_whyus_query->the_post();
			?>
			<div class="iwebstandard-whyus-a">
				<h3><?php the_title();?></h3>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );?>
						<?php the_excerpt();?>
					<?php remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt_oth' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
			</div>

			<?php endwhile; ?>
			<?php wp_reset_postdata(); ?>
			<?php endif; ?>
			<?php endif;?>
		</div><!--
	--></div>
</div>
<?php endif; ?>

<!-- END - Testimonials Section  -->

<!-- App Download  -->

<?php if ( get_theme_mod( 'iwebstandard_appdwld_display','0' ) === '1' ) :?>
	<div class="iwebstandard-appdwld">
		<div class="iwebstandard-appdwld-w">
				<?php
					$iwebstandard_appdwld_cat = get_theme_mod( 'iwebstandard_appdwld_catg' );
				if ( '0' != $iwebstandard_appdwld_cat ) :
							 $iwebstandard_appdwld_args = array(
									 'cat' => $iwebstandard_appdwld_cat,
									 'post_status' => 'publish',
									 'posts_per_page' => 1,
										);

							 $iwebstandard_appdwld_query = new WP_Query( $iwebstandard_appdwld_args );
					if ( $iwebstandard_appdwld_query->have_posts() ) :
						while ( $iwebstandard_appdwld_query->have_posts() ) :
							 $iwebstandard_appdwld_query->the_post();
				?>
				<div class="iwebstandard-appdwld-a1">
					<h1><?php the_title();?></h1>
					<?php add_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );
					add_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
						the_excerpt();
					remove_filter( 'excerpt_more', 'iwebstandard_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebstandard_custom_excerpt_length45' );?>
				</div>
				<div class="iwebstandard-appdwld-a2">
				<?php if ( null != get_theme_mod( 'iwebstandard_appbut1_bgimg' ) ) :?>
					<a href="<?php echo esc_url( get_theme_mod( 'iwebstandard_appbut1_url' ) ); ?>">
						<img src="<?php echo esc_url( get_theme_mod( 'iwebstandard_appbut1_bgimg' ) ); ?>" alt="<?php echo esc_attr__( 'App Download','iweb-standard' ); ?>" /></a>
				<?php endif; ?>
				<?php if ( null != get_theme_mod( 'iwebstandard_appbut2_bgimg' ) ) : ?>
					<a href="<?php echo esc_url( get_theme_mod( 'iwebstandard_appbut2_url' ) ); ?>">
						<img src="<?php echo esc_url( get_theme_mod( 'iwebstandard_appbut2_bgimg' ) ); ?>" alt="<?php echo esc_attr__( 'App Download','iweb-standard' ); ?>" /></a>
				<?php endif; ?>
				</div>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>
		</div>
	</div>
<?php endif; ?>
<!-- END - App  Download  -->

<!-- Our Clients Section  -->

<?php if ( get_theme_mod( 'iwebstandard_oclients_display', '0' ) == '1' ) : ?>
<div class="iwebstandard-oclinets">
	<div class="iwebstandard-oclinets-w">
	<?php if ( null != get_theme_mod( 'iwebstandard_oclients_title' ) ) :?>
		<h1><?php echo esc_html( get_theme_mod( 'iwebstandard_oclients_title', __( 'Our Clients', 'iweb-standard' ) ) );?></h1>
	<?php endif; ?>
		<?php
			$iwebstandard_oclinets_cat = get_theme_mod( 'iwebstandard_oclients_catg' );

		if ( '0' != $iwebstandard_oclinets_cat ) : ?>
				<?php
								$iwebstandard_oclinets_args = array(
								'cat' => $iwebstandard_oclinets_cat,
								'post_status' => 'publish',
								'posts_per_page' => 5,
								);
								$iwebstandard_oclinets_query = new WP_Query( $iwebstandard_oclinets_args );
				if ( $iwebstandard_oclinets_query->have_posts() ) :
					while ( $iwebstandard_oclinets_query->have_posts() ) :
										$iwebstandard_oclinets_query->the_post();
				?>
		<div class="iwebstandard-oclinets-a2">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-standard' ); ?>" />
			<?php endif; ?>
				</div>
		<?php endwhile;?>
		<?php wp_reset_postdata(); ?>
		<?php endif;?>
		<?php endif;?>
		</div>
</div>
<?php endif;?>

<!-- END - Our Clients Section  -->

<!-- Contact Us  -->

<?php if ( get_theme_mod( 'iwebstandard_contact_display', '0' ) === '1' ) :
	get_template_part( 'template-parts/contactus' );
endif; ?>

<!-- END - Contact Us  -->

	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer(); ?>
