<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package iweb-standard
 */

get_header();
?>

		<div class="iwebstandard-page-header">
			<h1><?php echo esc_html( get_the_title( absint( get_the_ID() ) ) ); ?></h1>
		</div>
	<div id="primary" class="content-area-l">
		<main id="main" class="site-main-l itopmrg">
			<!-- class itopmrg used in fixed.js file only for page content below header -->

			<?php if ( get_theme_mod( 'iwebstandard_display_breadcrumb', '1' ) === '1' ) : ?>
				<div class="breadcrumb"><?php iwebstandard_breadcrumb(); ?></div>
			<?php endif; ?>

		<?php
		while ( have_posts() ) :
			the_post();

			get_template_part( 'template-parts/content', 'page' );

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
		<?php get_sidebar(); ?>
	</div><!-- #primary -->

<?php

get_footer();
