/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 * @package iweb-standard
 */

( function( $ ) {

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );

	// Copyright
		wp.customize( 'iweb_copyright_text', function( value ) {
				value.bind( function( to ) {
					$( '#iweb-cuscr' ).text( to );
				} );
		} );

	// Slider

	wp.customize( 'iwebstandard_slider_bgimg', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-slider' ).css( { 'background': 'url' + '(' + to + ')' + 'center' + ' ' + 'center' } );
		} );
	} );

	wp.customize( 'iwebstandard_slider_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-slider-a h1' ).text( to );
		} );
	} );

	wp.customize( 'iwebstandard_sldtit_fsz', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-slider-a h1' ).css( { 'font-size': to + 'px' } );
		} );
	} );

	wp.customize( 'iwebstandard_sldbt1_txt', function( value ) {
		value.bind( function( to ) {
			$( 'p#iwebstandard-sldbt1-txt' ).text( to );
		} );
	} );

	wp.customize( 'iwebstandard_sldbt2_txt', function( value ) {
		value.bind( function( to ) {
			$( 'p#iwebstandard-sldbt2-txt' ).text( to );
		} );
	} );

	// Our Services

	wp.customize( 'iwebstandard_services_bgimg', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-services-a' ).css( { 'background': 'url' + '(' + to + ')' + 'center' + ' ' + 'center' } );
		} );
	} );

	wp.customize( 'iwebstandard_services_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-services-a1 h1' ).text( to );
		} );
	} );

	// Featured Section 1

	wp.customize( 'iwebstandard_featureds1_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebstandard_fs1_tit' ).text( to );
		} );
	} );

	// Featured Section 3

	wp.customize( 'iwebstandard_fs3bt_txt1', function( value ) {
		value.bind( function( to ) {
			$( 'p#iwebstandard-fs3-bt1' ).text( to );
		} );
	} );

	wp.customize( 'iwebstandard_fs3bt_txt2', function( value ) {
		value.bind( function( to ) {
			$( 'p#iwebstandard-fs3-bt2' ).text( to );
		} );
	} );

	// Our Team

	wp.customize( 'iwebstandard_ourtim_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-ourtim-at h1' ).text( to );
		} );
	} );

	// Testimonials

	wp.customize( 'iwebstandard_tmonials_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebstandard_tmo_tit' ).text( to );
		} );
	} );

	// Why Us

	wp.customize( 'iwebstandard_whyus_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-tmonials-w1 h1' ).text( to );
		} );
	} );

	// Our Clients

	wp.customize( 'iwebstandard_oclients_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-oclinets-w h1' ).text( to );
		} );
	} );

	// Contact Us

	wp.customize( 'iwebstandard_contact_phy_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-a h5' ).text( to );
		} );
	} );
	wp.customize( 'iwebstandard_contact_phy_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-a p' ).text( to );
		} );
	} );

	wp.customize( 'iwebstandard_contact_dgt_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-b h5' ).text( to );
		} );
	} );
	wp.customize( 'iwebstandard_contact_dgt_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-b p' ).text( to );
		} );
	} );

	wp.customize( 'iwebstandard_flwus_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-c h5' ).text( to );
		} );
	} );
	wp.customize( 'iwebstandard_flwus_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebstandard-contact-c p' ).text( to );
		} );
	} );

} )( jQuery );
