<?php
/**
 *
 * @package iweb-standard
 */

// radio box sanitization function.
function iwebstandard_sanitize_radio( $input ) {
			$valid_keys = array(
				'1' => __( 'Enable','iweb-standard' ),
				'0' => __( 'Disable','iweb-standard' ),
				);
	if ( array_key_exists( $input, $valid_keys ) ) {
				return $input;
	} else {
				return '';
	}
}

function iwebstandard_sanitize_radio2( $input ) {
			$valid_keys = array(
				'1' => __( 'White','iweb-standard' ),
				'0' => __( 'Theme Background Color','iweb-standard' ),
				);
	if ( array_key_exists( $input, $valid_keys ) ) {
				return $input;
	} else {
				return '';
	}
}

// file input sanitization function.
function iwebstandard_sanitize_file( $file, $setting ) {

			//allowed file types
			$mimes = array(
				'jpg|jpeg|jpe' => 'image/jpeg',
				'gif'          => 'image/,gif',
				'png'          => 'image/png',
			);

			//check file type from file name
			$file_ext = wp_check_filetype( $file, $mimes );

			//if file has a valid mime type return it, otherwise return default
			return ( $file_ext['ext'] ? $file : $setting->default );
}

if ( ! function_exists( 'iwebstandard_sanitize_number_range' ) ) :

	/**
	 * Sanitize number range.
	 *
	 */

	function iwebstandard_sanitize_number_range( $number, $setting ) {
		$number = absint( $number );
		$atts = $setting->manager->get_control( $setting->id )->input_attrs;
		$min = ( isset( $atts['min'] ) ? $atts['min'] : $number );
		$max = ( isset( $atts['max'] ) ? $atts['max'] : $number );
		$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );
		return ( $min <= $number && $number <= $max ) ? $number : $setting->default;
	}

endif;

if ( ! function_exists( 'iwebstandard_sanitize_allowed_html' ) ) :

	/**
	 * Sanitize allowed html tags.
	 *
	 */

	function iwebstandard_sanitize_allowed_html( $input ) {
		$input = wp_kses( $input, array(
			'br' => array(),
			'strong' => array(),
		));

		return $input;
	}
endif;

