<?php
/**
 *
 * @package iweb-standard
 */


function iwebstandard_bg_custom_css() {
		?>
	<style type="text/css">
		<?php $iweb_header_img = get_header_image();?>
		<?php if ( null != $iweb_header_img ) : ?>
			.site-header
			{background: url( <?php echo esc_url( get_theme_mod( header_image() ) );?>) ;}
		<?php else : ?>
			.site-header
			{background-color: transparent;}
		<?php endif; ?>
		<?php if ( get_theme_mod( 'iwebstandard_fpbgclr_display', '0' ) == '1' ) :?>
			.iwebstandard-aboutus, .iwebstandard-featureds1, .iwebstandard-featureds2, .iwebstandard-ourtim,
			.iwebstandard-oclinets, .site-header
				{background-color: #fff ;}
		<?php else : ?>
			.iwebstandard-aboutus, .iwebstandard-featureds1, .iwebstandard-featureds2, .iwebstandard-ourtim,
			.iwebstandard-oclinets, .site-header, body
				{background-color: #<?php echo esc_attr( get_theme_mod( background_color() ) );?> ;}
		<?php endif; ?>
		<?php if ( null != esc_html( get_theme_mod( 'iwebstandard_topbar_text' ) ) ) :?>
			.fullwidth {margin-top: -20px;}
				@media screen and (max-width: 768px) {
					.fullwidth {margin-top: 0;}
				}
		<?php else : ?>
			.fullwidth {margin-top: 0;}
		<?php endif; ?>
		<?php if ( get_theme_mod( 'iwebstandard_pheader_bgimg' ) != null ) :?>
			.iwebstandard-page-header
			{background: url(<?php echo esc_url( get_theme_mod( 'iwebstandard_pheader_bgimg' ) );?>) ;}
		<?php else : ?>
			.iwebstandard-page-header
			{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/headerimg.jpg) ;}
		<?php endif; ?>

		.iwebstandard-page-header h1:after, .top-add-bar, .iwebpagepagi .current, .iwebpagepagi .page-numbers:hover
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		<?php if ( get_theme_mod( 'iwebstandard_footer_bgimg' ) != null ) :?>
		 #footer-sidebar-w {
			background: linear-gradient( rgba(0,0,0,.8), rgba(0,0,0,.8) ), url(<?php echo esc_url( get_theme_mod( 'iwebstandard_footer_bgimg' ) ); ?>) center center ;}
		<?php endif; ?>

		h2.entry-title, .iwebstandard-arch-b3 h3
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

	</style>
<?php  }
add_action( 'wp_head','iwebstandard_bg_custom_css' );

function iwebstandard_themecolor1_custom_css() {
		?>
	<style type="text/css">
		#footer-sidebar .widget h2, .iwebstandard-button2, #topBtn
		{border-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		.fullwidth
		{border-bottom-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		a:hover, .site-title a:hover, .site-info a:hover, .breadcrumb a, .ppost span, .npost span, .iweb-moretag, .iwebstandard-button:hover, .iwebstandard-button2, #topBtn::after
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		#sidebar-1 h2, .iwebstandard-button, .iwebstandard-button2:hover
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		body #iwebstandard-bckgr
			{background: linear-gradient( rgba(0,0,0,0.6), rgba(0,0,0,0.6) ), url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg) center repeat ;}

			button,
			input[type="button"],
			input[type="reset"],
			input[type="submit"] {
		background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;
		border-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

	   @media screen and (min-width: 968px) {

		.search-form input[type="submit"], .form-submit input[type="submit"]
			{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		.main-navigation .current-menu-item > a,
		.main-navigation .current-menu-ancestor > a,
		.main-navigation .current_page_item > a,
		.main-navigation .current_page_ancestor > a,
		.main-navigation li ul li a
			{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}
		}

	   @media screen and (max-width: 967px) {

		.main-navigation a:hover, .main-navigation a:focus, .main-navigation li ul li a:hover,
		.main-navigation li ul li a:focus, .main-navigation ul {
			color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?> ;}
	   }
	</style>
<?php  }

add_action( 'wp_head','iwebstandard_themecolor1_custom_css' );


function iwebstandard_themecolor_main_custom_css() {
?>
	<style type="text/css">
		.iwebstandard-slider-a
		{font-size: <?php echo esc_attr( get_theme_mod( 'iwebstandard_sldtit_fsz' ) );?>px ;}

		@media screen and (min-width: 1280px) {
			.iwebstandard-slider-a h1 {font-size: 1em ;}
		}

	@media screen and (max-width: 1280px) and (min-width: 969px) {
		<?php if ( get_theme_mod( 'iwebstandard_sldtit_fsz' ) >= '105' ) :?>
		   .iwebstandard-slider-a h1 {font-size: 0.7em; }
		<?php else : ?>
			.iwebstandard-slider-a h1 {font-size: 1em ;}
		<?php endif; ?>
		}
	@media screen and (max-width: 968px) and (min-width: 769px) {
		<?php if ( get_theme_mod( 'iwebstandard_sldtit_fsz' ) >= '75' ) :?>
			.iwebstandard-slider-a h1 {font-size: 0.5em;}
		<?php elseif ( get_theme_mod( 'iwebstandard_sldtit_fsz' ) < '75' ) :?>
			.iwebstandard-slider-a h1 {font-size: 1em;}
		<?php endif; ?>
		}
	@media screen and (max-width: 768px) and (min-width: 601px) {
			.iwebstandard-slider-a h1 {font-size: 36px;}
		}

		<?php if ( get_theme_mod( 'iwebstandard_slider_bgimg' ) == null ) :?>
			.iwebstandard-slider
				{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg) center center ;}
		<?php else : ?>
			.iwebstandard-slider {
			  background: url(<?php echo esc_url( get_theme_mod( 'iwebstandard_slider_bgimg' ) );?>) center center ;}
		<?php endif; ?>

		<?php if ( get_theme_mod( 'iwebstandard_services_bgimg' ) != null ) :?>
			.iwebstandard-services-a
			{background: url(<?php echo esc_url( get_theme_mod( 'iwebstandard_services_bgimg' ) );?>) center center ;}
		<?php else : ?>
			.iwebstandard-services-a
			{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg) center center ;}
		<?php endif; ?>

		.iwebstandard-lastWord,
		.iwebstandard-slider-tit h1,
		.iwebstandard-featureds2-a1 .fa, .iwebstandard-ourtim-b2 h4, .iwebstandard-ourtim-a button.active, p#iwebstandard-tmonials-pc
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?> ;}

		 .iwebstandard-sld-dot, .iwebstandard-sld-active, .iwebstandard-featureds3-a2,
		 .iwebstandard-ourtim-at h1:after, p.iwebstandard-ourtim-b2p:after, .iwebstandard-oclinets-w h1:after, .iwebstandard-contact-a h5:after, .iwebstandard-contact-c h5:after, .iwebstandard-contact-b, .iwebstandard-services-a
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?> ;}

		.iwebstandard-featureds2-b img
		{border-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#c1331b' ) ); ?>;}

		<?php if ( get_theme_mod( 'iwebstandard_appdwld_bgimg' ) != null ) :?>
			.iwebstandard-appdwld
			{background: url(<?php echo esc_url( get_theme_mod( 'iwebstandard_appdwld_bgimg' ) );?>) ;}
		<?php else : ?>
			.iwebstandard-appdwld
			{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/appdwld.jpg) center ;}
		<?php endif; ?>

		<?php if ( get_theme_mod( 'iwebstandard_tmonials_bgimg' ) != null ) :?>
			.iwebstandard-tmonials
			{background: linear-gradient( to right, rgb(242,242,243) 40%,rgba(255,255,255,0.4) ), url(<?php echo esc_url( get_theme_mod( 'iwebstandard_tmonials_bgimg' ) );?>) center repeat ;}
		<?php else : ?>
			.iwebstandard-tmonials
				{background: linear-gradient( to right, rgb(242,242,243) 40%,rgba(255,255,255,0.4) ), url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg) center repeat ;}
		<?php endif; ?>

	</style>
<?php  }

add_action( 'wp_head','iwebstandard_themecolor_main_custom_css' );

function iwebstandard_themecolor_alpha_custom_css() {

	function iwebstandard_hex2rgba( $iweb_color, $iweb_opacity = false ) {

			$iwebdefault = 'rgb(51,51,51)';

		//Return default if no color provided
		if ( empty( $iweb_color ) ) {
			return $iwebdefault;
		}

		//Sanitize $iweb_color if "#" is provided
		if ( '#' == $iweb_color[0] ) {
			$iweb_color = substr( $iweb_color, 1 );
		}

			//Check if color has 6 or 3 characters and get values
		if ( strlen( $iweb_color ) == 6 ) {
			$hex = array( $iweb_color[0] . $iweb_color[1], $iweb_color[2] . $iweb_color[3], $iweb_color[4] . $iweb_color[5] );
		} elseif ( strlen( $iweb_color ) == 3 ) {
			$hex = array( $iweb_color[0] . $iweb_color[0], $iweb_color[1] . $iweb_color[1], $iweb_color[2] . $iweb_color[2] );
		} else {
			return $iwebdefault;
		}

		//Convert hexadec to rgb
		$rgb = array_map( 'hexdec', $hex );

		//Check if opacity is set(rgba or rgb)
		if ( $iweb_opacity ) {
			if ( abs( $iweb_opacity ) > 1 ) {
				$iweb_opacity = 1.0;
			}
				$output = 'rgba( ' . implode( ',',$rgb ) . ',' . $iweb_opacity . ' )';
		} else {
				$output = 'rgb( ' . implode( ',',$rgb ) . ' )';
		}

		//Return rgb(a) color string
		return $output;
	}

		$iwebstandard_color = esc_html( get_theme_mod( 'iweb_theme_color','#c1331b' ) );
		$iwebstandard_rgba1 = iwebstandard_hex2rgba( $iwebstandard_color, 0.1 );

?>
	<style type="text/css">

		.bypostauthor .comment-body, .children .bypostauthor .comment-body
		{background-color: <?php echo esc_attr( $iwebstandard_rgba1 ); ?> ;}

	</style>
<?php  }

add_action( 'wp_head','iwebstandard_themecolor_alpha_custom_css' );
