<?php
/**
 * IWeb Standard Theme Customizer
 *
 * @package iweb-standard
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

	// Load customize sanitize.
	get_template_part( '/inc/active-callback' );

function iwebstandard_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'iwebstandard_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'iwebstandard_customize_partial_blogdescription',
		) );
	}

	// ----------------------------------------------------------------------
	// Add Theme Options Panel
	$wp_customize->add_panel('iwebstandard_options_panel',array(
			'priority' => '50',
			'capability' => 'edit_theme_options',
			'theme_supports' => '',
			'title' => esc_html__( 'Theme Options','iweb-standard' ),
			'description' => __( 'Visit <a target="_blank" href="http://www.iwebdm.com/wordpress-themes/documentation-standard/">Documentation</a> for creating this section.', 'iweb-standard' ),
	));

	// Theme Settings ----------------------------------

		   $wp_customize->add_section('iwebstandard_themesettings',array(
				'title' => __( 'Theme Settings','iweb-standard' ),
				'priority' => '10',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
		   ));

		// add color picker setting
			$wp_customize->add_setting( 'iweb_theme_color', array(
				'default' => '#c1331b',
				'sanitize_callback' => 'sanitize_hex_color',
			) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'iweb_theme_color', array(
				'label' => 'Select Theme Color',
				'section' => 'iwebstandard_themesettings',
				'settings' => 'iweb_theme_color',
			) ) );

	// Frontpage Background Color
					$wp_customize->add_setting('iwebstandard_fpbgclr_display', array(
						'default' => '1',
						'sanitize_callback' => 'iwebstandard_sanitize_radio2',
					));

					$wp_customize->add_control('iwebstandard_fpbgclr_display',array(
						'type' => 'radio',
						'label' => __( 'Frontpage Background Color', 'iweb-standard' ),
						'section' => 'iwebstandard_themesettings',
						'choices' => array(
							'1' => __( 'White','iweb-standard' ),
							'0' => __( 'Theme Background Color','iweb-standard' ),
							),
					));
		// Info 7
					$wp_customize->add_setting('custom_info7', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',
					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info7', array(
						'description' 	=> __( 'You can select Theme Background Color in customizer Colors Panel', 'iweb-standard' ),
						'settings'		=> 'custom_info7',
						'section'  		=> 'iwebstandard_themesettings',
					)));
	// Separator 1
					$wp_customize->add_setting('separator_1', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_1', array(
						'settings'		=> 'separator_1',
						'section'  		=> 'iwebstandard_themesettings',
					)));

	   // Tob Bar Text
				$wp_customize->add_setting('iwebstandard_topbar_text', array(
						'default' => '',
						'sanitize_callback' => 'sanitize_text_field',
				));

				$wp_customize->add_control('iwebstandard_topbar_text',array(
						'type' => 'text',
						'label' => __( 'Top Bar Text','iweb-standard' ),
						'section' => 'iwebstandard_themesettings',
						'setting' => 'iwebstandard_topbar_text',
						'input_attrs' => array(
							'placeholder' => __( 'Tel.: +91-731-12345678', 'iweb-standard' ),
						),
				));
	// Separator 2
					$wp_customize->add_setting('separator_2', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_2', array(
						'settings'		=> 'separator_2',
						'section'  		=> 'iwebstandard_themesettings',
					)));
	// Breadcrumb
					$wp_customize->add_setting('iwebstandard_display_breadcrumb', array(
						'default' => '1',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_display_breadcrumb',array(
						'type' => 'radio',
						'label' => __( 'Display Breadcrumb', 'iweb-standard' ),
						'section' => 'iwebstandard_themesettings',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	// Separator 3
					$wp_customize->add_setting('separator_3', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_3', array(
						'settings'		=> 'separator_3',
						'section'  		=> 'iwebstandard_themesettings',
					)));
	// Post/Page Header Background Image
						$wp_customize->add_setting('iwebstandard_pheader_bgimg', array(
							'default' => '',
							'capability' => 'edit_theme_options',
							'sanitize_callback' => 'iwebstandard_sanitize_file',
						));

						$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_pheader_bgimg', array(
							'label' => __( 'Page/Post Header Background Image', 'iweb-standard' ),
							'description' => __( 'Your theme works best with an image with a header size of 1920x400px', 'iweb-standard' ),
							'section' => 'iwebstandard_themesettings',
							'setting' => 'iwebstandard_pheader_bgimg',
						)));
	// Separator 4
					$wp_customize->add_setting('separator_4', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_4', array(
						'settings'		=> 'separator_4',
						'section'  		=> 'iwebstandard_themesettings',
					)));
	   // Copyright Text
				$wp_customize->add_setting('iweb_copyright_text', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				));

				$wp_customize->add_control('iweb_copyright_text',array(
						'type' => 'text',
						'label' => __( 'Footer Copyright Text','iweb-standard' ),
						'section' => 'iwebstandard_themesettings',
						'setting' => 'iweb_copyright_text',
				));
	// Separator 5
					$wp_customize->add_setting('separator_5', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_5', array(
						'settings'		=> 'separator_5',
						'section'  		=> 'iwebstandard_themesettings',
					)));
	   // BG Image for Footer Widgets
				  $wp_customize->add_setting('iwebstandard_footer_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'transport' => 'postMessage',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_footer_bgimg', array(
						'label' => __( 'Background Image for Footer Widgets', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 1920x600px', 'iweb-standard' ),
						'section' => 'iwebstandard_themesettings',
						'setting' => 'iwebstandard_footer_bgimg',
				   )));

	// Slider ----------------------------------

			$wp_customize->add_section('iwebstandard_slider',array(
				'title' => __( 'Slider','iweb-standard' ),
				'priority' => '20',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
				//'active_callback' => 'is_front_page',
			));

					$wp_customize->add_setting('iwebstandard_display_mslider', array(
						'default' => '1',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_display_mslider',array(
						'type' => 'radio',
						'label' => __( 'Display Slider or A Static Image', 'iweb-standard' ),
						'description' => __( 'Recommended Size for Featured Image in Post is 1920x600px','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'choices' => array(
							'1' => __( 'A Static Image','iweb-standard' ),
							'0' => __( 'Slider','iweb-standard' ),
						),
					));
	   // BG Image
				  $wp_customize->add_setting('iwebstandard_slider_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'transport' => 'postMessage',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_slider_bgimg', array(
						'label' => __( 'Background Image for Slider', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 1920x800px', 'iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_slider_bgimg',
				   )));
		//  Title
				   $wp_customize->add_setting('iwebstandard_slider_title', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_slider_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_slider_title',
					));
	// Title Font Size
					$wp_customize->add_setting( 'iwebstandard_sldtit_fsz', array(
						  'default' => 150,
						  'transport' => 'postMessage',
						  'sanitize_callback' => 'iwebstandard_sanitize_number_range',
					));

					$wp_customize->add_control( new IwebStandard_Customize_Range( $wp_customize, 'iwebstandard_sldtit_fsz', array(
						'type' => 'range',
						'label' => esc_html__( 'Title Font Size- 50 to 150', 'iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_sldtit_fsz',
						'input_attrs' => array(
							 'min' => 50, // Required. Minimum value for the slider
							 'max' => 150, // Required. Maximum value for the slider
							 'step' => 1, // Required. The size of each interval or step the slider takes between the minimum and maximum values
						  ),
					)));
		//select category
					$wp_customize->add_setting('iwebstandard_slider_category',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_slider_category', array(
						'label' => __( 'Select a category to show in slider','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_slider_category',
					)));
	   //  Button #1 Text
				   $wp_customize->add_setting('iwebstandard_sldbt1_txt', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_sldbt1_txt',array(
						'type' => 'text',
						'label' => __( 'Text for Button 1','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_sldbt1_txt',
					));
		// Button #1 URL
					$wp_customize->add_setting('iwebstandard_sldbt1_url', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_sldbt1_url',array(
						'type' => 'url',
						'description' => __( 'URL for Button 1','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_sldbt1_url',
					));
	   //  Button #2 Text
				   $wp_customize->add_setting('iwebstandard_sldbt2_txt', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_sldbt2_txt',array(
						'type' => 'text',
						'label' => __( 'Text for Button 2','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_sldbt2_txt',
					));
		// Button #2 URL
					$wp_customize->add_setting('iwebstandard_sldbt2_url', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_sldbt2_url',array(
						'type' => 'url',
						'description' => __( 'URL for Button 2','iweb-standard' ),
						'section' => 'iwebstandard_slider',
						'setting' => 'iwebstandard_sldbt2_url',
					));

	// ------------------------------- About Us

			$wp_customize->add_section('iwebstandard_aboutus',array(
				'title' => __( 'About Us','iweb-standard' ),
				'priority' => '30',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebstandard_display_aboutus', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebstandard_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebstandard_display_aboutus',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_aboutus',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
		// Info 1
					$wp_customize->add_setting('custom_info1', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',
					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info1', array(
						'label'    		=> __( 'For the Left Side of Section', 'iweb-standard' ),
						'description' 	=> __( 'Title and Excerpt will be displayed with the Featured Image. Featured Image size recommended 900x600px', 'iweb-standard' ),
						'settings'		=> 'custom_info1',
						'section'  		=> 'iwebstandard_aboutus',
					)));
		//select page
					$wp_customize->add_setting('iwebstandard_aboutus_catg1',array(
						'default' => '0',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( 'iwebstandard_aboutus_catg1', array(
						'type' => 'dropdown-pages',
						'label' => __( 'Select a Page','iweb-standard' ),
						'section' => 'iwebstandard_aboutus',
						'setting' => 'iwebstandard_aboutus_catg1',
					));
		// Info 2
					$wp_customize->add_setting('custom_info2', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',

					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info2', array(
						'label'    		=> __( 'For the Right Side of Section', 'iweb-standard' ),
						'description' 	=> __( 'Select a category with one post only. The title of post will be displayed as main heading and each paragraph (which will start with the * ) of post content will be displayed as a point.<br>Visit <a target="_blank" href="http://www.iwebdm.com/wordpress-themes/documentation-standard/">Documentation</a> for creating this section.', 'iweb-standard' ),
						'settings'		=> 'custom_info2',
						'section'  		=> 'iwebstandard_aboutus',
					)));

		//select category 2
					$wp_customize->add_setting('iwebstandard_aboutus_catg2',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_aboutus_catg2', array(
						'label' => __( 'Select a category','iweb-standard' ),
						'section' => 'iwebstandard_aboutus',
						'setting' => 'iwebstandard_aboutus_catg2',
					)));

	// ------------------------------- Services

			$wp_customize->add_section('iwebstandard_services',array(
				'title' => __( 'Services','iweb-standard' ),
				'priority' => '35',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebstandard_display_services', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebstandard_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebstandard_display_services',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_services',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	   // BG Image
				  $wp_customize->add_setting('iwebstandard_services_bgimg', array(
						'default' => '',
						'transport' => 'postMessage',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_services_bgimg', array(
						'label' => __( 'Background Image', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 1280x900px', 'iweb-standard' ),
						'section' => 'iwebstandard_services',
						'setting' => 'iwebstandard_services_bgimg',
				   )));
	//  Title
				   $wp_customize->add_setting('iwebstandard_services_title', array(
						'default' => __( 'Services','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_services_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_services',
						'setting' => 'iwebstandard_services_title',
					));
	// Info 5
					$wp_customize->add_setting('custom_info5', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',
					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info5', array(
						'description' 	=> __( 'Select a Category with minimum 5 posts.', 'iweb-standard' ),
						'settings'		=> 'custom_info5',
						'section'  		=> 'iwebstandard_services',
					)));
	//select category
					$wp_customize->add_setting('iwebstandard_services_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_services_catg', array(
						'label' => __( 'Select a category','iweb-standard' ),
						'section' => 'iwebstandard_services',
						'setting' => 'iwebstandard_services_catg',
					)));

	// ------------------------------- Featured Section 1

			$wp_customize->add_section('iwebstandard_featureds1',array(
				'title' => __( 'Featured Section 1','iweb-standard' ),
				'priority' => '40',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebstandard_display_featureds1', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebstandard_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebstandard_display_featureds1',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds1',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
		//  Title
				   $wp_customize->add_setting('iwebstandard_featureds1_title', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_featureds1_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_featureds1',
						'setting' => 'iwebstandard_featureds1_title',
					));
	// Info 6
					$wp_customize->add_setting('custom_info6', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',
					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info6', array(
						'description' 	=> __( 'Select a Category with minimum 2 posts. The image of the first post will be displayed.', 'iweb-standard' ),
						'settings'		=> 'custom_info6',
						'section'  		=> 'iwebstandard_featureds1',
					)));
		//select category
					$wp_customize->add_setting('iwebstandard_featureds1_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_featureds1_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_featureds1',
						'setting' => 'iwebstandard_featureds1_catg',
					)));

	// ------------------------------- Featured Section 2

			$wp_customize->add_section('iwebstandard_featureds2',array(
				'title' => __( 'Featured Section 2','iweb-standard' ),
				 'description' => __( 'For better look, minimum 4 posts required in a category.', 'iweb-standard' ),
				'priority' => '45',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebstandard_display_featureds2', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebstandard_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebstandard_display_featureds2',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds2',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	   // BG Image
				  $wp_customize->add_setting('iwebstandard_featureds2_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_featureds2_bgimg', array(
						'label' => __( 'Image', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 900x600px', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds2',
						'setting' => 'iwebstandard_featureds2_bgimg',
				   )));
		//select category
					$wp_customize->add_setting('iwebstandard_featureds2_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_featureds2_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_featureds2',
						'setting' => 'iwebstandard_featureds2_catg',
					)));

	// ------------------------------- Featured Section 3

			$wp_customize->add_section('iwebstandard_featureds3',array(
				'title' => __( 'Featured Section 3','iweb-standard' ),
				 'description' => __( 'Minimum 2 posts required in a category. Featured Image size for first post is recommended 900x600px', 'iweb-standard' ),
				'priority' => '50',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebstandard_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebstandard_display_featureds3', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebstandard_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebstandard_display_featureds3',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
		//select category
					$wp_customize->add_setting('iwebstandard_featureds3_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_featureds3_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'setting' => 'iwebstandard_featureds3_catg',
					)));
		// FontAwesome Icon 1
				  $wp_customize->add_setting('iwebstandard_fafs3_icon1', array(
						'default' => '',
						'sanitize_callback' => 'sanitize_text_field',
				  ));
					$wp_customize->add_control( 'iwebstandard_fafs3_icon1',array(
						'type' => 'text',
						'label' => __( 'Select Icon for post #1','iweb-standard' ),
						'description' => __( 'Please input icon as eg: fa-line-chart. Find Font-awesome icons <a target="_blank" href="https://fontawesome.com/v4.7.0/icons/">here</a>', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'setting' => 'iwebstandard_fafs3_icon1',
					));
		// FontAwesome Icon 2
				  $wp_customize->add_setting('iwebstandard_fafs3_icon2', array(
						'default' => '',
						'sanitize_callback' => 'sanitize_text_field',
				  ));
					$wp_customize->add_control( 'iwebstandard_fafs3_icon2',array(
						'type' => 'text',
						'label' => __( 'Select Icon for post #2','iweb-standard' ),
						'description' => __( 'Please input icon as eg: fa-handshake-o. Find Font-awesome icons <a target="_blank" href="https://fontawesome.com/v4.7.0/icons/">here</a>', 'iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'setting' => 'iwebstandard_fafs3_icon2',
					));
	   //  Text for Button 1
				   $wp_customize->add_setting('iwebstandard_fs3bt_txt1', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_fs3bt_txt1',array(
						'type' => 'text',
						'label' => __( 'Text for Button of Post 1','iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'setting' => 'iwebstandard_fs3bt_txt1',
					));
	   //  Text for Button 1
				   $wp_customize->add_setting('iwebstandard_fs3bt_txt2', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_fs3bt_txt2',array(
						'type' => 'text',
						'label' => __( 'Text for Button of Post 2','iweb-standard' ),
						'section' => 'iwebstandard_featureds3',
						'setting' => 'iwebstandard_fs3bt_txt2',
					));

	// Our Team --------------------------------

			 $wp_customize->add_section('iwebstandard_ourtim',array(
				 'title' => __( 'Our Team','iweb-standard' ),
				 'description' => __( 'Minimum 5 posts required in a category for this section. Recommended Featured Image Size - 600x600px.', 'iweb-standard' ),
				 'priority' => '55',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebstandard_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebstandard_ourtim_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_ourtim_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_ourtim',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	//  Title
				   $wp_customize->add_setting('iwebstandard_ourtim_title', array(
						'default' => __( 'Our Team','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_ourtim_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_ourtim',
						'setting' => 'iwebstandard_ourtim_title',
					));
	//select category
					$wp_customize->add_setting('iwebstandard_ourtim_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_ourtim_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_ourtim',
						'setting' => 'iwebstandard_ourtim_catg',
					)));

	// Testimonials --------------------------------

			 $wp_customize->add_section('iwebstandard_tmonials',array(
				 'title' => __( 'Testimonials','iweb-standard' ),
				 'priority' => '60',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebstandard_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebstandard_tmonials_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_tmonials_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_tmonials',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	   // BG Image
				  $wp_customize->add_setting('iwebstandard_tmonials_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_tmonials_bgimg', array(
						'label' => __( 'Section Background Image', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 1920x900px', 'iweb-standard' ),
						'section' => 'iwebstandard_tmonials',
						'setting' => 'iwebstandard_tmonials_bgimg',
				   )));
	//  Title
				   $wp_customize->add_setting('iwebstandard_tmonials_title', array(
						'default' => __( 'Testimonials','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_tmonials_title',array(
						'type' => 'text',
						'label' => __( 'Testimonials','iweb-standard' ),
						'description' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_tmonials',
						'setting' => 'iwebstandard_tmonials_title',
					));
	//select category
					$wp_customize->add_setting('iwebstandard_tmonials_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_tmonials_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_tmonials',
						'setting' => 'iwebstandard_tmonials_catg',
					)));
	// Separator 6
					$wp_customize->add_setting('separator_6', array(
						'default'           => '',
						'sanitize_callback' => 'esc_html',
					));
					$wp_customize->add_control(new IwebStandard_Separator_Custom_Control($wp_customize, 'separator_6', array(
						'settings'		=> 'separator_6',
						'section'  		=> 'iwebstandard_tmonials',
					)));
	//  Why Us Title
				   $wp_customize->add_setting('iwebstandard_whyus_title', array(
						'default' => __( 'Why Us?','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_whyus_title',array(
						'type' => 'text',
						'label' => __( 'Why Us?','iweb-standard' ),
						'description' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_tmonials',
						'setting' => 'iwebstandard_whyus_title',
					));
	//select a page for Why Us
				$wp_customize->add_setting('iwebstandard_whyus_catg',array(
					'default' => '',
					'capability' => 'edit_theme_options',
					'sanitize_callback' => 'absint',
				));

				$wp_customize->add_control( 'iwebstandard_whyus_catg',array(
					'type' => 'dropdown-pages',
					'label' => __( 'Select a Page','iweb-standard' ),
					'section' => 'iwebstandard_tmonials',
					'setting' => 'iwebstandard_whyus_catg',
				));

	// App Download --------------------------------

			 $wp_customize->add_section('iwebstandard_appdwld',array(
				 'title' => __( 'App Download','iweb-standard' ),
				 'priority' => '70',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebstandard_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebstandard_appdwld_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_appdwld_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section', 'iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
		// Background Image
						$wp_customize->add_setting('iwebstandard_appdwld_bgimg', array(
							'default' => '',
							'capability' => 'edit_theme_options',
							'sanitize_callback' => 'iwebstandard_sanitize_file',
						));

						$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_appdwld_bgimg', array(
							'label' => __( 'Section Background Image', 'iweb-standard' ),
							'description' => __( 'Your theme works best with an image size of 1920x600px pixels', 'iweb-standard' ),
							'section' => 'iwebstandard_appdwld',
							'setting' => 'iwebstandard_appdwld_bgimg',
						)));
		//select category
					$wp_customize->add_setting('iwebstandard_appdwld_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_appdwld_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'setting' => 'iwebstandard_appdwld_catg',
					)));
	   // Button Image 1
				  $wp_customize->add_setting('iwebstandard_appbut1_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_appbut1_bgimg', array(
						'label' => __( 'Select Image for Button 1', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 150x50px', 'iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'setting' => 'iwebstandard_appbut1_bgimg',
				   )));
		// Button Image #1 URL
					$wp_customize->add_setting('iwebstandard_appbut1_url', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_appbut1_url',array(
						'type' => 'url',
						'description' => __( 'URL for Button 1','iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'setting' => 'iwebstandard_appbut1_url',
					));
	   // Button Image 2
				  $wp_customize->add_setting('iwebstandard_appbut2_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebstandard_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebstandard_appbut2_bgimg', array(
						'label' => __( 'Select Image for Button 2', 'iweb-standard' ),
						'description' => __( 'Recommended Size- 150x50px', 'iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'setting' => 'iwebstandard_appbut2_bgimg',
				   )));
		// Button Image #2 URL
					$wp_customize->add_setting('iwebstandard_appbut2_url', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_appbut2_url',array(
						'type' => 'url',
						'description' => __( 'URL for Button 2','iweb-standard' ),
						'section' => 'iwebstandard_appdwld',
						'setting' => 'iwebstandard_appbut2_url',
					));

	// Our Clients --------------------------------

			 $wp_customize->add_section('iwebstandard_oclients',array(
				 'title' => __( 'Our Clients','iweb-standard' ),
				 'description' => __( 'Recommended Featured Image size of a post is 200x100px.', 'iweb-standard' ),
				 'priority' => '75',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebstandard_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebstandard_oclients_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_oclients_display',array(
						'type' => 'radio',
						'label' => __( 'Display Our Clients Section', 'iweb-standard' ),
						'section' => 'iwebstandard_oclients',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	   //  Title
				   $wp_customize->add_setting('iwebstandard_oclients_title', array(
						'default' => __( 'Our Clients','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_oclients_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_oclients',
						'setting' => 'iwebstandard_oclients_title',
					));
		//select category
					$wp_customize->add_setting('iwebstandard_oclients_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebstandard_WP_Customize_Category_Control( $wp_customize,'iwebstandard_oclients_catg', array(
						'label' => __( 'Select a Category','iweb-standard' ),
						'section' => 'iwebstandard_oclients',
						'setting' => 'iwebstandard_oclients_catg',
					)));

	// Contact Us --------------------------------

			 $wp_customize->add_section('iwebstandard_contact',array(
				 'title' => __( 'Contact Us','iweb-standard' ),
				 'priority' => '80',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebstandard_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebstandard_contact_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_contact_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section on Home Page', 'iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
		// Display
					$wp_customize->add_setting('iwebstandard_contact_pp_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebstandard_sanitize_radio',
					));

					$wp_customize->add_control('iwebstandard_contact_pp_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section when any Page/Post is being displayed.', 'iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'choices' => array(
							'1' => __( 'Enable','iweb-standard' ),
							'0' => __( 'Disable','iweb-standard' ),
							),
					));
	   //  Physical Title
				   $wp_customize->add_setting('iwebstandard_contact_phy_title', array(
						'default' => __( 'Address','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_contact_phy_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_contact_phy_title',
					));
		// Info 3
					$wp_customize->add_setting('custom_info3', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',

					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info3', array(
						'description' 	=> __( 'In this description, you can use 2 HTML tags, one for New Line and another for Bold the word, view placeholder.', 'iweb-standard' ),
						'settings'		=> 'custom_info3',
						'section'  		=> 'iwebstandard_contact',
					)));
		// Physical Description
				  $wp_customize->add_setting('iwebstandard_contact_phy_desc', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'iwebstandard_sanitize_allowed_html',
				  ));
					$wp_customize->add_control( 'iwebstandard_contact_phy_desc',array(
						'type' => 'textarea',
						'description' => __( 'Description','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_contact_phy_desc',
						'input_attrs' => array(
							'placeholder' => __( '123-ABC Building<br>XYZ Street<br><strong>CityName</strong>','iweb-standard' ),
						),
					));
	   //  Digital Title
				   $wp_customize->add_setting('iwebstandard_contact_dgt_title', array(
						'default' => __( 'Contact Us','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_contact_dgt_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_contact_dgt_title',
					));
		// Info 4
					$wp_customize->add_setting('custom_info4', array(
						'default'           => '',
						'sanitize_callback' => 'sanitize_text_field',

					));
					$wp_customize->add_control(new IwebStandard_Info_Custom_Control($wp_customize, 'custom_info4', array(
						'description' 	=> __( 'In this description, you can use 2 HTML tags, one for New Line and another for Bold the word, view placeholder.', 'iweb-standard' ),
						'settings'		=> 'custom_info4',
						'section'  		=> 'iwebstandard_contact',
					)));
		// Description
				  $wp_customize->add_setting('iwebstandard_contact_dgt_desc', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'iwebstandard_sanitize_allowed_html',
				  ));
					$wp_customize->add_control( 'iwebstandard_contact_dgt_desc',array(
						'type' => 'textarea',
						'description' => __( 'Description','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_contact_dgt_desc',
						'input_attrs' => array(
							'placeholder' => __( 'Tel.: 91-731-12345678<br>Mobile: 09999911111<br>Email: contact@abcde.com','iweb-standard' ),
						),
					));
	   //  Follow Us
				   $wp_customize->add_setting('iwebstandard_flwus_title', array(
						'default' => __( 'Follow Us','iweb-standard' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebstandard_flwus_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_flwus_title',
						'input_attrs' => array(
							'placeholder' => __( 'Follow Us','iweb-standard' ),
							),
					));
		  // Facebook URL
					$wp_customize->add_setting('iwebstandard_fb_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_fb_url',array(
						'type' => 'url',
						'description' => __( 'Facebook URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_fb_url',
					));
		  // Twitter URL
					$wp_customize->add_setting('iwebstandard_tw_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_tw_url',array(
						'type' => 'url',
						'description' => __( 'Twitter URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_tw_url',
					));
		  // Instagram URL
					$wp_customize->add_setting('iwebstandard_inst_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_inst_url',array(
						'type' => 'url',
						'description' => __( 'Instagram URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_inst_url',
					));
		  // Linkedin URL
					$wp_customize->add_setting('iwebstandard_lkin_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_lkin_url',array(
						'type' => 'url',
						'description' => __( 'Linkedin URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_lkin_url',
					));
		  // Pinterest URL
					$wp_customize->add_setting('iwebstandard_pin_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_pin_url',array(
						'type' => 'url',
						'description' => __( 'Pinterest URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_pin_url',
					));
		// Youtube URL
					$wp_customize->add_setting('iwebstandard_ytube_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebstandard_ytube_url',array(
						'type' => 'url',
						'description' => __( 'Youtube URL','iweb-standard' ),
						'section' => 'iwebstandard_contact',
						'setting' => 'iwebstandard_ytube_url',
					));

	// ----------------------------------------------------------------------
}
add_action( 'customize_register', 'iwebstandard_customize_register' );


/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function iwebstandard_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function iwebstandard_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function iwebstandard_customize_preview_js() {
	wp_enqueue_script( 'iwebstandard-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'iwebstandard_customize_preview_js' );



function iwebstandard_sanitize_dropdown_pages( $page_id, $setting ) {
	// Ensure $input is an absolute integer.
	$page_id = absint( $page_id );

	// If $page_id is an ID of a published page, return it; otherwise, return the default.
	return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}
