<?php
/**
 * IWeb Standard Custom classes
 *
 *
 * @package iweb-standard
 */

if ( class_exists( 'WP_Customize_Control' ) ) {
	class IwebStandard_Info_Custom_Control extends WP_Customize_Control {
		public $type = 'info';
		public function render_content() {
			?>
			<span class="customize-control-title"><?php echo esc_html( $this->label ); ?></span>
			<p><?php echo wp_kses_post( $this->description ); ?></p>
			<?php
		}
	}
}

/* Custom Separator */

if ( class_exists( 'WP_Customize_Control' ) ) {
	class IwebStandard_Separator_Custom_Control extends WP_Customize_Control {
		public $type = 'separator';
		public function render_content() {
			?>
			<p><hr></p>
			<?php
		}
	}
}

/* Range Control */
if ( class_exists( 'WP_Customize_Control' ) ) {
	class IwebStandard_Customize_Range extends WP_Customize_Control {
		public $type = 'range';

		public function __construct( $manager, $id, $args = array() ) {
			parent::__construct( $manager, $id, $args );
			$defaults = array(
				'min' => 50,
				'max' => 150,
				'step' => 1,
			);
			$args = wp_parse_args( $args, $defaults );

			$this->min = $args['min'];
			$this->max = $args['max'];
			$this->step = $args['step'];
		}

		public function render_content() {
		?>
		<label>
			<span><?php echo esc_html( $this->label ); ?></span>
			<input min="<?php echo esc_attr( $this->min ) ?>" max="<?php echo esc_attr( $this->max ) ?>" step="<?php echo esc_attr( $this->step ) ?>" type='range' <?php $this->link(); ?> value="<?php echo esc_attr( $this->value() ); ?>" oninput="jQuery(this).next('input').val( jQuery(this).val() )">
			<input onKeyUp="jQuery(this).prev('input').val( jQuery(this).val() )" type='text' value='<?php echo esc_attr( $this->value() ); ?>'>

		</label>
		<?php
		}
	}
}
