<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package iweb-standard
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'iweb-standard' ); ?></a>

	<header id="masthead" class="site-header">
		<?php if ( null != esc_html( get_theme_mod( 'iwebstandard_topbar_text' ) ) ) :?>
		<div class="top-add-bar-w iweb-show768">
			<div class="top-add-bar">
				<div class="top-add-bar-b"><?php echo esc_html( get_theme_mod( 'iwebstandard_topbar_text' ) );?></div>
			</div>
		</div>
	<?php endif; ?>
		<div class="fullwidth">
			<div id="header-90">
				<?php if ( null != get_custom_logo() ) : ?>
					<div class="logo-l">
						<?php
						the_custom_logo(); ?>
					</div>
				<?php endif; ?>
				<?php if ( ! display_header_text() ) : ?>
				<?php else : ?>
					<div class="title-r">
						<?php
						if ( is_front_page() && is_home() ) :
							?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php
						else :
							?>
							<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
							<?php
						endif;
						$iwebstandard_description = get_bloginfo( 'description', 'display' );
						if ( $iwebstandard_description || is_customize_preview() ) :
							?>
							<p class="site-description"><?php echo $iwebstandard_description; /* WPCS: xss ok. */ ?></p>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div>

			<div class="inavbar">
				<?php if ( function_exists( 'max_mega_menu_is_enabled' ) && max_mega_menu_is_enabled( 'primary' ) ) : ?>
					<?php wp_nav_menu( array(
						'theme_location' => 'primary',
					) ); ?>
				<?php else : ?>
					<nav id="site-navigation" class="main-navigation">
							<button class="menu-toggle"><i class="fa fa-bars" aria-hidden="true"></i></button>
							<?php wp_nav_menu( array(
								'theme_location' => 'primary',
								'menu_class' => 'nav-menu',
							) ); ?>
					</nav>
				<?php endif; ?>
			</div>
		</div>
		</header><!-- #masthead -->

	<div id="content" class="site-content">
