<?php
/**
 * The template for displaying full-width posts
 * Template Name: Full Width Post
 * Template Post Type: Post
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package iweb-standard
 */

get_header();
?>
		<div class="iwebstandard-page-header">
			<h1><?php echo esc_html( get_the_title( absint( get_the_ID() ) ) ); ?></h1>
		</div>

	<div id="primary" class="content-area">
		<main id="main" class="site-main itopmrg">

		<?php if ( get_theme_mod( 'iwebstandard_display_breadcrumb', '1' ) === '1' ) : ?>
			<div class="breadcrumb"><?php iwebstandard_breadcrumb(); ?></div>
		<?php endif; ?>

		<?php
		while ( have_posts() ) :
			the_post();

			get_template_part( 'template-parts/content', get_post_type() );

			// If comments are open or we have at least one comment, load up the comment template.
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;

		endwhile; // End of the loop.
		?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php

get_footer();
