<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package iweb-standard
 */

get_header();
?>

	<div id="primary" class="content-area-l">
		<main id="main" class="site-main-l itopmrg">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php
				the_archive_title( '<h1 class="page-title">', '</h1>' );
				the_archive_description( '<div class="archive-description">', '</div>' );
				?>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) :
				the_post();

				/*
				 * Include the Post-Type-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
				 */
				if ( is_category() ) :
					get_template_part( 'template-parts/content-category', get_post_type() );
				else :
					get_template_part( 'template-parts/content-archive', get_post_type() );
				endif;

			endwhile; ?>
			<div class="iwebpagibord"></div>
			<div class="iwebpagepagi">
				<?php the_posts_pagination(); ?>
			</div>

		<?php else :

			get_template_part( 'template-parts/content', 'none' );

		endif;
		?>

		</main><!-- #main -->
<?php get_sidebar(); ?>
	</div><!-- #primary -->

<?php

get_footer();
