<?php
/**
 * Template part for Slider
 *
 * @package iwebbusiness
 */

?>

<div class="iwebbusiness-slider">
	<div class="iwebbusiness-slider-a">
		<h1><?php echo esc_html( get_theme_mod( 'iwebbusiness_slider_title' ) );?></h1>
		<p><?php echo esc_html( get_theme_mod( 'iwebbusiness_slider_desc' ) );?></p>
	</div>

	<div class="iwebbusiness-slider-b">

		<?php
			$iwebbusiness_slider_cat = esc_html( get_theme_mod( 'iwebbusiness_slider_category' ) );
				$iwebbusiness_slider_args = array(
					'cat' => $iwebbusiness_slider_cat,
					'post_status' => 'publish',
					'posts_per_page' => 4,
				);
				$iwebbusiness_slider_query = new WP_Query( $iwebbusiness_slider_args );
				$iwebbusiness_sld = 0;
				if ( get_theme_mod( 'iwebbusiness_slider_category' ) != null ) :
					function iwebbusiness_postcount( $id ) {
						$category = get_category( $id );
						return $category->category_count;
					}
					$iwebcount = iwebbusiness_postcount( $iwebbusiness_slider_cat );
				else :
					$iwebcount = 0;
				endif;
		?>
		<?php if ( get_theme_mod( 'iwebbusiness_display_mslider','1' ) === '1' || '1' == $iwebcount ) :
			if ( $iwebbusiness_slider_query->have_posts() ) :
				$iwebbusiness_slider_query->the_post();
		?>
			<?php if ( has_post_thumbnail() ) :
				$iwebbusiness91_img = get_the_post_thumbnail_url( get_the_ID(),'full' );
			else :
				$iwebbusiness91_img = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
			endif; ?>

			<div class="iSlides1" style="background-image: url( <?php echo esc_url( $iwebbusiness91_img ); ?> );">

					<div class="itext">
						<h1><?php the_title();?></h1>
						<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
						add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
							the_excerpt();
						remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
						remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
							<div class="tmarg-25">
							<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more','iweb-business' );?></a>
							</div>
					</div>

			</div>

		<?php endif; ?>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'iwebbusiness_display_mslider' ) === '0' and '1' < $iwebcount ) : ?>
		<?php $iwebbusiness_sld_d = 1;
		if ( $iwebbusiness_slider_query->have_posts() ) :
			while ( $iwebbusiness_slider_query->have_posts() ) :
					  $iwebbusiness_slider_query->the_post();
		?>
		<?php if ( has_post_thumbnail() ) : ?>
			<?php $iwebbusiness91_img = get_the_post_thumbnail_url( get_the_ID(),'full' ); ?>
		<?php else : ?>
			<?php $iwebbusiness91_img = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );?>
		<?php endif; ?>

		<div class="iSlides iSlides1" style="background-image: url(<?php echo esc_url( $iwebbusiness91_img );?>);">
			<div class="itext">
				<h1><?php the_title();?></h1>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
					the_excerpt();
				remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );?>
				<div class="tmarg-25">
				<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more','iweb-business' );?></a>
				</div>
			</div>
		</div>
		<?php $iwebbusiness_sld++ ;?>
		<?php  endwhile; ?>
		<?php wp_reset_postdata();?>
		<?php endif; ?>

		<div class="talign-c">
			<span class="iwebbusiness-sld-dot"></span>
			<?php if ( $iwebbusiness_sld > 1 ) :?>
				<span class="iwebbusiness-sld-dot"></span>
				<?php if ( $iwebbusiness_sld > 2 ) :?>
					<span class="iwebbusiness-sld-dot"></span>
					<?php if ( $iwebbusiness_sld > 3 ) :?>
						<span class="iwebbusiness-sld-dot"></span>
					<?php endif; ?><?php endif; ?><?php endif; ?>
		</div>

		<?php endif; ?>

	</div>
</div>
