<?php
/**
 * The template for displaying all pages.
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site will use a
 * different template.
 *
 * Template Name: Front Page
 * @package iwebbusiness
 */

	get_header();
?>

<div  class="content-area">
	<main id="main" class="site-main" role="main">

		<?php  get_template_part( 'template-parts/iwebnusiness-slider' ); ?>

<!-- Section 1  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_section1','0' ) === '1' ) :?>
	<div class="iwebbusiness-section-1">
		<?php
		$iwebbusiness_section1_cat = get_theme_mod( 'iwebbusiness_section1_catg' );
		if ( '0' != $iwebbusiness_section1_cat ) :
			$iwebbusiness_section1_args = array(
				'cat' => $iwebbusiness_section1_cat,
				'post_status' => 'publish',
				'posts_per_page' => 1,
				);
				$iwebbusiness_section1 = 1;
				$iwebbusiness_section1_query = new WP_Query( $iwebbusiness_section1_args );
			if ( $iwebbusiness_section1_query->have_posts() ) :
				while ( $iwebbusiness_section1_query->have_posts() ) :
					$iwebbusiness_section1_query->the_post();
		?>
		<?php if ( '1' == $iwebbusiness_section1 ) : ?>
		<div class="iwebbusiness-section-1-w iwebanim-fil">
			<div class="iwebbusiness-section-1-a1">
				<h2><?php the_title();?></h2>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
			</div>
			<div class="iwebbusiness-section-1-a2">
					<a class="iwebbusiness-button" href="<?php echo esc_url( get_theme_mod( 'iwebbusiness_section1_btnurl' ) );?>">
					<?php echo esc_html( get_theme_mod( 'iwebbusiness_section1_btntx',__( 'Download', 'iweb-business' ) ) );?></a>
			</div>
		</div>
		<?php endif; ?>
		<?php $iwebbusiness_section1++;?>
	<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
	<?php endif; ?>
	<?php endif; ?>
	</div>
<?php endif; ?>

<!-- END - Section 1  -->

<!-- Section 2  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_section2','0' ) === '1' ) :?>
		<div class="iwebbusiness-section2">
			<div class="iwebbusiness-section2-w iwebanim-fid">
				<h1 id="iwebbusiness-s2-h1" class="iwebbusiness-sectitle"><?php echo esc_html( get_theme_mod( 'iwebbusiness_section2_title',__( 'Section 2', 'iweb-business' ) ) );?></h1>
			<?php
				$iwebbusiness_section2_cat = get_theme_mod( 'iwebbusiness_section2_catg' );
			if ( '0' != $iwebbusiness_section2_cat ) :
					$iwebbusiness_section2_args = array(
						 'cat' => $iwebbusiness_section2_cat,
						 'post_status' => 'publish',
						 'posts_per_page' => 1,
					);
					$iwebbusiness_section2 = 1;
					$iwebbusiness_section2_query = new WP_Query( $iwebbusiness_section2_args );
				if ( $iwebbusiness_section2_query->have_posts() ) :
					while ( $iwebbusiness_section2_query->have_posts() ) :
						$iwebbusiness_section2_query->the_post();
			?>
			<?php if ( '1' == $iwebbusiness_section2 ) :?>
				<h4><?php the_title();?></h4>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length90' );
				 add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
						<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
					remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length90' );?>
			<?php endif; ?>
				<?php $iwebbusiness_section2++;?>
				<?php endwhile; ?>
				<?php wp_reset_postdata(); ?>
				<?php endif; ?>
				<?php endif; ?>
			</div>
		</div>
<?php endif; ?>

<!-- END - Section 2  -->

<!-- Section 3  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_section3','0' ) === '1' ) :?>
		<div class="iwebbusiness-section3">
		<div class="iwebbusiness-section3-w">
				<div class="iwebbusiness-section3-a1 iwebanim-fir">
				<?php
					$iwebbusiness_section3_htext = '';
					$iwebbusiness_section3_pth = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );
					$iwebbusiness_section3_cat = get_theme_mod( 'iwebbusiness_section3_catg' );
				if ( '0' != $iwebbusiness_section3_cat ) :
							 $iwebbusiness_section3_args = array(
									 'cat' => $iwebbusiness_section3_cat,
									 'post_status' => 'publish',
									 'posts_per_page' => 4,
										);
					$iwebbusiness_section3 = 1;
					$iwebbusiness_section3_query = new WP_Query( $iwebbusiness_section3_args );
					if ( $iwebbusiness_section3_query->have_posts() ) :
						while ( $iwebbusiness_section3_query->have_posts() ) :
							 $iwebbusiness_section3_query->the_post();
				?>

						<?php if ( 4 == $iwebbusiness_section3 ) : ?>
								<?php if ( has_post_thumbnail() ) : ?>
										<?php $iwebbusiness_section3_pth = get_the_post_thumbnail_url( get_the_ID(),'full' ); ?>
								<?php else : ?>
										<?php $iwebbusiness_section3_pth = esc_url( get_template_directory_uri() . '/img/defaultimage.jpg' );?>
								<?php endif; ?>
								<?php $iwebbusiness_section3_htext = get_the_title();?>
						<?php else : ?>
								<h2><?php the_title();?></h2>
									<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
									add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
												<?php the_excerpt();?>
										<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
										remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
						<?php endif;
						$iwebbusiness_section3++;
						?>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
						<?php endif; ?>
						<?php endif; ?>
						</div>

						<div class="iwebbusiness-section3-a2 iwebanim-fil" style="background: url( '<?php echo esc_url( $iwebbusiness_section3_pth ); ?>' ) center ;">
								<div class="iwebbusiness-section3-htext">
										<h1><?php echo esc_html( $iwebbusiness_section3_htext ); ?></h1>
								</div>
						</div>
				</div>
		</div>
<?php endif; ?>
<!-- END - Section 3  -->

<!-- Our Services Section  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_ourservices','0' ) === '1' ) :?>
		<div class="iwebbusiness-os">
			 <div class="iwebbusiness-os-w">
				<h1 id="iwebbusiness-os-h1" class="iwebbusiness-sectitle bmarg-5"><?php echo esc_html( get_theme_mod( 'iwebbusiness_os_title',__( 'Services We Offer', 'iweb-business' ) ) );?></h1>
					<?php
					$iwebbusiness_os_row = get_theme_mod( 'iwebbusiness_os_rows', '1' );
					$iwebbusiness_os_rxc = $iwebbusiness_os_row * 3;
					$iwebbusiness_os_prw = $iwebbusiness_os_rxc + 1;
					$iwebbusiness_os_prwd = 1;
					$iwebbusiness_os_cat = get_theme_mod( 'iwebbusiness_os_catg' );
					if ( '0' != $iwebbusiness_os_cat ) :
						$iwebbusiness_os_args = array(
						 'cat' => $iwebbusiness_os_cat,
						 'post_status' => 'publish',
						 'posts_per_page' => $iwebbusiness_os_rxc,
						);
						$iwebbusiness_os_query = new WP_Query( $iwebbusiness_os_args );
						if ( $iwebbusiness_os_query->have_posts() ) :
							while ( $iwebbusiness_os_query->have_posts() ) :
								$iwebbusiness_os_query->the_post();
					?>
					<?php if ( $iwebbusiness_os_prwd < $iwebbusiness_os_prw ) :?><!--
				--><div class="iwebbusiness-os-a1 iwebanim-zin">
					<?php if ( has_post_thumbnail() ) :?>
					   <a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'full' );?></a>
					<?php else : ?>
						<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
					<?php endif; ?>
						 <h4 class="iwebbusiness-sectitle ifontweightn"><a href="<?php the_permalink();?>"><?php the_title();?></a></h4>
						<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
							add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
							<?php the_excerpt();?>
						<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
									remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );?>
						<a href="<?php the_permalink();?>"><p id="iwebbusiness-os-a1p"><?php esc_html_e( 'Read more','iweb-business' );?></p></a>
					</div><!--
					--><?php endif; ?>
					<?php $iwebbusiness_os_prwd++;?>
					<?php  endwhile; ?>
					<?php wp_reset_postdata(); ?>
					<?php endif; ?>
					<?php endif; ?>
			</div>
		</div>
<?php endif;?>

<!-- END - Our Services Section  -->

<!-- Section 4  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_section4','0' ) === '1' ) :?>
<div class="iwebbusiness-section4">
		<?php
			$iwebbusiness_section4_cat = get_theme_mod( 'iwebbusiness_section4_catg' );
		if ( '0' != $iwebbusiness_section4_cat ) : ?>
	<?php
			$iwebbusiness_section4_args = array(
			'cat' => $iwebbusiness_section4_cat,
			'post_status' => 'publish',
			'posts_per_page' => 2,
			);
			$iwebbusiness_section4_query = new WP_Query( $iwebbusiness_section4_args );
			$iwebbusiness_section4 = 0;
	if ( $iwebbusiness_section4_query->have_posts() ) :
		while ( $iwebbusiness_section4_query->have_posts() ) :
				$iwebbusiness_section4_query->the_post();
	?>
	<?php if ( 0 == $iwebbusiness_section4 ) :?>
	<div class="iwebbusiness-section4-w">
		<div class="iwebbusiness-section4-a1 iwebanim-fil">
			<?php if ( has_post_thumbnail() ) :?>
				<a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'full' );?></a>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
		</div><!--
		--><div class="iwebbusiness-section4-b1 iwebanim-fir">
			<h1 class="iwebbusiness-sectitle"><a href="<?php the_permalink();?>"><?php the_title();?></a></h1>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
					the_excerpt();
				remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
					<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"> <?php esc_html_e( 'Read more','iweb-business' );?></a>
		</div>
	</div>
	<?php endif; ?>      <!-- iwebbusiness_section4=0 -->

	<?php if ( 1 == $iwebbusiness_section4 ) :?>  <!-- iwebbusiness_section4=1 -->
	<div class="iwebbusiness-section4-w iwebbusiness-section4-wmargin">
		<div class="iwebbusiness-section4-a1 iwebanim-fir iweb-hide768">
			<?php if ( has_post_thumbnail() ) :?>
				<a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'full' );?></a>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
		</div>
		<div class="iwebbusiness-section4-b1 iwebbusiness-section4-b1-pad iwebanim-fil">
			<h1 class="iwebbusiness-sectitle"><a href="<?php the_permalink();?>"><?php the_title();?></a></h1>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
					the_excerpt();
				remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
					<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more','iweb-business' );?></a>
		</div><!--
		--><div class="iwebbusiness-section4-a1 iwebanim-fir iweb-show768">
			<?php if ( has_post_thumbnail() ) :?>
				<a href="<?php the_permalink();?>"><?php the_post_thumbnail( 'full' );?></a>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
		</div>
	</div><div style="clear:both"></div>
	<?php endif; ?>      <!-- iwebbusiness_section4=1 -->
		<?php $iwebbusiness_section4++ ;?>
	<?php  endwhile; ?>
	<?php wp_reset_postdata(); ?>
	<?php endif; ?>
	<?php endif; ?>
</div>

<?php endif; ?>

<!-- END - Section 4  -->

<!-- Section 5  -->

<?php if ( get_theme_mod( 'iwebbusiness_section5_display', '0' ) === '1' ) :?>
	<div class="iwebbusiness-section5">
				<div class="iwebbusiness-section5-w">
						<?php
							$iwebbusiness_section5_cat = get_theme_mod( 'iwebbusiness_section5_catg' );

						if ( '0' != $iwebbusiness_section5_cat ) : ?>
						<?php
								$iwebbusiness_section5_args = array(
								'cat' => $iwebbusiness_section5_cat,
								'post_status' => 'publish',
								'posts_per_page' => 4,
								);
								$iwebbusiness_section5 = 1;
								$iwebbusiness_section5_query = new WP_Query( $iwebbusiness_section5_args );
						if ( $iwebbusiness_section5_query->have_posts() ) :
							while ( $iwebbusiness_section5_query->have_posts() ) :
								$iwebbusiness_section5_query->the_post();
								add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
								add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
									$iwebbusiness_section5_a1 = get_the_excerpt();
								remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
								remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length20' );
								$iwebbusiness_section5_a2 = get_the_title();
						?>
						<?php if ( $iwebbusiness_section5 < 5 ) :?>
						<div class="iwebbusiness-section5-a  iwebanim-fil">
								<h1><?php echo esc_html( $iwebbusiness_section5_a1 );?></h1>
								<p><?php echo esc_html( $iwebbusiness_section5_a2 );?></p>
						</div>
						<?php endif; ?>
						<?php $iwebbusiness_section5++;?>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
						<?php endif; ?>
						<?php endif; ?>
				</div>
	</div>
<?php endif; ?><!-- Section display enable -->

<!-- END - Section 5 -->

<!-- Our Projects  -->

<?php if ( get_theme_mod( 'iwebbusiness_display_projects', '0' ) === '1' ) :?>
<div class="iwebbusiness-op">
		<div class="iwebbusiness-op-w">
			<h1 id="iwebbusiness-op-h1" class="iwebbusiness-sectitle bmarg-5"><?php echo esc_html( get_theme_mod( 'iwebbusiness_op_title',__( 'Our Recent Works', 'iweb-business' ) ) );?></h1>
			<p id="iwebbusiness-op-p" class="iwebbusiness-secdesc tmarg-0"><?php echo esc_html( get_theme_mod( 'iwebbusiness_op_desc' ) );?></p>
			<?php
			$iwebbusiness_op_cat = get_theme_mod( 'iwebbusiness_op_catg' );
			if ( '0' != $iwebbusiness_op_cat ) :
				$iwebbusiness_op_args = array(
				'cat' => $iwebbusiness_op_cat,
				'post_status' => 'publish',
				'posts_per_page' => 3,
				);
				$iwebbusiness_op_prw = 1;
				$iwebbusiness_op_query = new WP_Query( $iwebbusiness_op_args );
				if ( $iwebbusiness_op_query->have_posts() ) :
					while ( $iwebbusiness_op_query->have_posts() ) :
						$iwebbusiness_op_query->the_post();
			?>
			<?php if ( $iwebbusiness_op_prw < 4 ) :?> <!--
			--><div class="iwebbusiness-op-a1 iwebanim-zin">
				<a href="<?php the_permalink();?>" title="<?php the_title();?>">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
					<div class="iwebbusiness-op-overlay">
						<i class="fa fa-link" style="visibility: visible;"></i>
					</div></a>
			</div><!--
			--><?php endif; ?>
			<?php $iwebbusiness_op_prw++;?>
			<?php  endwhile; ?>
			<?php wp_reset_postdata(); ?>
			<?php endif; ?>
			<?php endif; ?>
			<?php if ( null != get_theme_mod( 'iwebbusiness_op_btntx' ) ) :?>
				<div class="iwebbusiness-op-btnn">
					<a class="iwebbusiness-button" href="<?php echo esc_url( get_theme_mod( 'iwebbusiness_op_btnlink' ) );?>">
					<?php echo esc_html( get_theme_mod( 'iwebbusiness_op_btntx' ) );?></a>
				</div>
			<?php endif; ?>
		</div>
</div>
<?php endif; ?>

<!-- END - Our Projects  -->

<!-- Our Team Section  -->

<?php if ( get_theme_mod( 'iwebbusiness_ourtim_display', '0' ) === '1' ) :?>
<div class="iwebbusiness-ourtim">
	<div class="iwebbusiness-ourtim-w">
				<div class="iwebbusiness-ourtim-a"><!--
		--><?php
				$iwebbusiness_ot_title = '';
				$iwebbusiness_ot_plink = '';
				$iwebbusiness_ot_excp = '';
		$iwebbusiness_ourtim_cat = get_theme_mod( 'iwebbusiness_ourtim_catg' );
		if ( 0 != $iwebbusiness_ourtim_cat ) :
				$iwebbusiness_ourtim_args = array(
					'cat' => $iwebbusiness_ourtim_cat,
					'post_status' => 'publish',
					'posts_per_page' => 5,
				);
				$iwebbusiness_ourtim_query = new WP_Query( $iwebbusiness_ourtim_args );
				$iwebbusiness_ourtim_lr = 1 ;

			if ( $iwebbusiness_ourtim_query->have_posts() ) :
				while ( $iwebbusiness_ourtim_query->have_posts() ) :
					$iwebbusiness_ourtim_query->the_post();
					$iwebbusiness_ourtim_v1 = 0 ;
					$iwebbusiness_ourtim_title1 = esc_html( get_the_title() );
		?>
						<?php if ( 5 == $iwebbusiness_ourtim_lr ) :
								$iwebbusiness_ot_title = get_the_title();
								$iwebbusiness_ot_plink = get_the_permalink();
							add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
							add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
							$iwebbusiness_ot_excp = get_the_excerpt();
							remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
							remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
						<?php else : ?>
							<div class="iwebbusiness-ourtim-a1 iwebanim-fil">
								<?php if ( has_post_thumbnail() ) :?>
												<?php the_post_thumbnail( 'full' );?>
								<?php else : ?>
										<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
								<?php endif; ?>
								<div class="iwebbusiness-ot-overlay">
									<div class="iwebbusiness-ot-text">
										<span class="iwebbusiness-ot-span1"><?php echo the_title();?></span>
										<?php echo the_excerpt();?>
									</div>
								</div>
							</div>
						<?php endif; ?>
						<?php $iwebbusiness_ourtim_lr++ ;?>
						<?php endwhile; ?>
						<?php wp_reset_postdata(); ?>
						<?php endif; ?>
						<?php endif;?>
				</div><!--
				--><div class="iwebbusiness-ourtim-b iwebanim-fir">
					<h1 class="iwebbusiness-sectitle tmarg-0"><?php echo esc_html( $iwebbusiness_ot_title );?></h1>
					<p><?php echo esc_html( $iwebbusiness_ot_excp );?></p>
					<?php if ( get_theme_mod( 'iwebbusiness_ourtim_display_button', '1' ) === '1' ) :?>
					<a class="iwebbusiness-button" href="<?php echo esc_url( $iwebbusiness_ot_plink );?>">
					<?php echo esc_html__( 'CONTINUE READING', 'iweb-business' );?></a>
					<?php endif;?>
				</div>
	</div>
</div>
<?php endif; ?>

<!-- END - Our Team Section  -->

<!-- Testimonials Section  -->

<?php if ( get_theme_mod( 'iwebbusiness_tmonials_display', '0' ) === '1' ) :?>
<div class="iwebbusiness-tmonials">
	<div class="iwebbusiness-tmonials-w  iwebanim-fil">
		<h1 id="iwebbusiness-tmonials-h1" class="iwebbusiness-sectitle tmarg-0"><span><?php echo esc_html( get_theme_mod( 'iwebbusiness_tmonials_title',__( 'Testimonials','iweb-business' ) ) );?></span></h1>
		<?php
		$iwebbusiness_tmonials_cat = get_theme_mod( 'iwebbusiness_tmonials_catg' );
		if ( 0 != $iwebbusiness_tmonials_cat ) :
				$iwebbusiness_tmonials_args = array(
					'cat' => $iwebbusiness_tmonials_cat,
					'post_status' => 'publish',
					'posts_per_page' => 2,
				);
				$iwebbusiness_tmonials_query = new WP_Query( $iwebbusiness_tmonials_args );

			if ( $iwebbusiness_tmonials_query->have_posts() ) :
				while ( $iwebbusiness_tmonials_query->have_posts() ) :
					$iwebbusiness_tmonials_query->the_post();
					$iwebbusiness_tmonials_v1 = 0 ;
					$iwebbusiness_tmonials_title1 = esc_html( get_the_title() );
					if ( strpos( $iwebbusiness_tmonials_title1, ',' ) !== false ) {
						$iwebbusiness_tmonials_title = explode( ',', $iwebbusiness_tmonials_title1, 2 );
						$iwebbusiness_tmonials_v1 = 1 ;
					}
		?>
		<div class="iwebbusiness-tmonials-a">
			<div class="iwebbusiness-tmonials-a1">
				<?php if ( has_post_thumbnail() ) :?>
					<?php the_post_thumbnail( 'full' );?>
				<?php else : ?>
					<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
				<?php endif; ?>
			</div>
			<div class="iwebbusiness-tmonials-a2 ifontweightn">
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>

				<?php if ( 1 == $iwebbusiness_tmonials_v1 ) : ?>
					<p><?php if ( null != $iwebbusiness_tmonials_title[0] ) : ?>
						<span><?php echo esc_html( $iwebbusiness_tmonials_title[0] );?></span>
					<?php endif; ?>
					<?php if ( null != $iwebbusiness_tmonials_title[1] ) : ?>
						<?php echo ',' . esc_html( $iwebbusiness_tmonials_title[1] );?>
					<?php endif; ?></p>
				<?php else : ?>
					<p><?php echo esc_html( $iwebbusiness_tmonials_title1 );?></p>
				<?php endif; ?>
			</div>
		</div>
		<?php endwhile; ?>
		<?php wp_reset_postdata(); ?>
		<?php endif; ?>
		<?php endif;?>
		</div>
</div>
<?php endif; ?>  <!-- Testimonials section display enable -->

<!-- END - Testimonials Section  -->

<!-- Blog Articles  -->

<?php if ( get_theme_mod( 'iwebbusiness_barticles_display', '0' ) == '1' ) : ?>
<div class="iwebbusiness-barticles">
	<div class="iwebbusiness-barticles-w">
			<h1 class="iwebbusiness-sectitle"><?php echo esc_html( get_theme_mod( 'iwebbusiness_barticles_title',__( 'Blog Articles','iweb-business' ) ) );?></h1>
				<p id="iwebbusiness_lnews-cuslive" class="iwebbusiness-secdesc tmarg-0"><?php echo esc_html( get_theme_mod( 'iwebbusiness_barticles_desc' ) );?></p>
		</div>
		<?php
			$iwebbusiness_barticles_cat = get_theme_mod( 'iwebbusiness_barticles_catg' );

		if ( '0' != $iwebbusiness_barticles_cat ) : ?>
	<?php
			$iwebbusiness_barticles_args = array(
			'cat' => $iwebbusiness_barticles_cat,
			'post_status' => 'publish',
			'posts_per_page' => 2,
			);
			$iwebbusiness_barticles_query = new WP_Query( $iwebbusiness_barticles_args );
			$iwebbusiness_barticles = 0;
	if ( $iwebbusiness_barticles_query->have_posts() ) :
		while ( $iwebbusiness_barticles_query->have_posts() ) :
				$iwebbusiness_barticles_query->the_post();
	?>
	<?php if ( 0 == $iwebbusiness_barticles ) :?>
	<div class="iwebbusiness-barticles-a">
		<div class="iwebbusiness-barticles-a1 iwebanim-fil">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
				</div><!--
		--><div class="iwebbusiness-barticles-b1">
			<h2 class="txtcolfff"><a class="iwebbusiness-temp" href="<?php the_permalink();?>"><?php the_title();?></a></h2>
						<p class="upcase iweb-fontsize13"><?php the_time( 'M j, Y' );?></p>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
				<div class="iwebbusiness-barticles-b2">
					<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more','iweb-business' );?></a>
				</div>
		</div>
	</div>
	<?php endif; ?>      <!-- iwebbusiness_barticles=0 -->

		<?php if ( 1 == $iwebbusiness_barticles ) :?>
		<div class="iwebbusiness-barticles-a">
				<div class="iwebbusiness-barticles-a1 iwebanim-fir iweb-hide">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
				</div><!--
				--><div class="iwebbusiness-barticles-b1">
			<h2 class="txtcolfff"><a class="iwebbusiness-temp" href="<?php the_permalink();?>"><?php the_title();?></a></h2>
						<p class="upcase iweb-fontsize13"><?php the_time( 'M j, Y' );?></p>
				<?php add_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );
				add_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );?>
					<?php the_excerpt();?>
				<?php remove_filter( 'excerpt_more', 'iwebbusiness_change_link_excerpt' );
				remove_filter( 'excerpt_length', 'iwebbusiness_custom_excerpt_length55' );?>
						<div class="iwebbusiness-barticles-b2">
								<a class="iwebbusiness-button" href="<?php the_permalink(); ?>"><?php esc_html_e( 'Read more','iweb-business' );?></a>
						</div>
		</div><!--
		--><div class="iwebbusiness-barticles-a1 iwebanim-fir iweb-show">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
				</div>
		</div>
		<?php endif; ?>             <!-- iwebbusiness_barticles=0 -->
		<div style="clear:both"></div>
		<?php $iwebbusiness_barticles++ ;?>
	<?php  endwhile; ?>
	<?php wp_reset_postdata(); ?>
	<?php endif; ?>
	<?php endif; ?>

</div>
<?php endif; ?>

<!-- END - Blog Articles  -->

<!-- Our Clients Section  -->

<?php if ( get_theme_mod( 'iwebbusiness_oclients_display', '0' ) == '1' ) : ?>
<div class="iwebbusiness-oclinets">
	<div class="iwebbusiness-oclinets-w  iwebanim-fil">
				<div class="iwebbusiness-oclinets-a1">
						<h4 class="iwebbusiness-sectitle ifontweightn"><?php echo esc_html( get_theme_mod( 'iwebbusiness_oclients_title',__( 'Our Clients', 'iweb-business' ) ) );?></h4>
				</div>
		<?php
			$iwebbusiness_oclinets_cat = get_theme_mod( 'iwebbusiness_oclients_catg' );

		if ( '0' != $iwebbusiness_oclinets_cat ) : ?>
			<?php
			$iwebbusiness_oclinets_args = array(
				'cat' => $iwebbusiness_oclinets_cat,
				'post_status' => 'publish',
				'posts_per_page' => 4,
				);
				$iwebbusiness_oclinets_prw = 1;
				$iwebbusiness_oclinets_query = new WP_Query( $iwebbusiness_oclinets_args );
			if ( $iwebbusiness_oclinets_query->have_posts() ) :
				while ( $iwebbusiness_oclinets_query->have_posts() ) :
					$iwebbusiness_oclinets_query->the_post();
			?>
			<?php if ( $iwebbusiness_oclinets_prw < 5 ) :?>
			<div class="iwebbusiness-oclinets-a2">
			<?php if ( has_post_thumbnail() ) :?>
				<?php the_post_thumbnail( 'full' );?>
			<?php else : ?>
				<img src="<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage.jpg" alt="<?php echo esc_attr__( 'No Image Found','iweb-business' ); ?>" />
			<?php endif; ?>
			</div>
			<?php endif; ?>
		<?php $iwebbusiness_oclinets_prw++ ;?>
		<?php endwhile;?>
		<?php wp_reset_postdata(); ?>
		<?php endif;?>
		<?php endif;?>
		</div>
</div>
<?php endif;?>

<!-- END - Our Clients Section  -->

	</main><!-- #main -->
</div><!-- #primary -->

<?php get_footer(); ?>
