/**
 * File customizer.js.
 *
 * Theme Customizer enhancements for a better user experience.
 *
 * Contains handlers to make Theme Customizer preview reload changes asynchronously.
 * @package iwebbusiness
 */

( function( $ ) {

	// Site title and description.
	wp.customize( 'blogname', function( value ) {
		value.bind( function( to ) {
			$( '.site-title a' ).text( to );
		} );
	} );
	wp.customize( 'blogdescription', function( value ) {
		value.bind( function( to ) {
			$( '.site-description' ).text( to );
		} );
	} );

	// Header text color.
	wp.customize( 'header_textcolor', function( value ) {
		value.bind( function( to ) {
			if ( 'blank' === to ) {
				$( '.site-title, .site-description' ).css( {
					'clip': 'rect(1px, 1px, 1px, 1px)',
					'position': 'absolute'
				} );
			} else {
				$( '.site-title, .site-description' ).css( {
					'clip': 'auto',
					'position': 'relative'
				} );
				$( '.site-title a, .site-description' ).css( {
					'color': to
				} );
			}
		} );
	} );

	// Copyright
		wp.customize( 'iweb_copyright_text', function( value ) {
				value.bind( function( to ) {
					$( '#iweb-cuscr' ).text( to );
				} );
		} );

	// Slider

	wp.customize( 'iwebbusiness_slider_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-slider-a h1' ).text( to );
		} );
	} );
	wp.customize( 'iwebbusiness_slider_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-slider-a p' ).text( to );
		} );
	} );

	// Section 1

	wp.customize( 'iwebbusiness_section1_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-section-1-a1 h2' ).text( to );
		} );
	} );
	wp.customize( 'iwebbusiness_section1_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-section-1-a1 p' ).text( to );
		} );
	} );

	// Section 2

	wp.customize( 'iwebbusiness_section2_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebbusiness-s2-h1' ).text( to );
		} );
	} );

	// Our Services

	wp.customize( 'iwebbusiness_os_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebbusiness-os-h1' ).text( to );
		} );
	} );

	// Our Projects

	wp.customize( 'iwebbusiness_op_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebbusiness-op-h1' ).text( to );
		} );
	} );
	wp.customize( 'iwebbusiness_op_desc', function( value ) {
		value.bind( function( to ) {
			$( 'p#iwebbusiness-op-p' ).text( to );
		} );
	} );

	// Testimonials

	wp.customize( 'iwebbusiness_tmonials_title', function( value ) {
		value.bind( function( to ) {
			$( 'h1#iwebbusiness-tmonials-h1' ).text( to );
		} );
	} );

	// Blog/News

	wp.customize( 'iwebbusiness_barticles_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-barticles-w h1' ).text( to );
		} );
	} );
	wp.customize( 'iwebbusiness_barticles_desc', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-barticles-w p' ).text( to );
		} );
	} );

	// Our Clients

	wp.customize( 'iwebbusiness_oclients_title', function( value ) {
		value.bind( function( to ) {
			$( '.iwebbusiness-oclinets-a1 h4' ).text( to );
		} );
	} );

} )( jQuery );
