<?php
/**
 *
 * @package iwebbusiness
 */

// radio box sanitization function.
function iwebbusiness_sanitize_radio( $input ) {
			$valid_keys = array(
				'1' => __( 'Enable','iweb-business' ),
				'0' => __( 'Disable','iweb-business' ),
				);
	if ( array_key_exists( $input, $valid_keys ) ) {
				return $input;
	} else {
				return '';
	}
}

// file input sanitization function.
function iwebbusiness_sanitize_file( $file, $setting ) {

			//allowed file types
			$mimes = array(
				'jpg|jpeg|jpe' => 'image/jpeg',
				'gif'          => 'image/,gif',
				'png'          => 'image/png',
			);

			//check file type from file name
			$file_ext = wp_check_filetype( $file, $mimes );

			//if file has a valid mime type return it, otherwise return default
			return ( $file_ext['ext'] ? $file : $setting->default );
}


if ( ! function_exists( 'iwebbusiness_sanitize_number_range' ) ) :

	/**
	 * Sanitize number range.
	 *
	 */
	function iwebbusiness_sanitize_number_range( $input, $setting ) {

		$input = absint( $input );

		$atts = $setting->manager->get_control( $setting->id )->input_attrs;

		$min = ( isset( $atts['min'] ) ? $atts['min'] : $input );

		$max = ( isset( $atts['max'] ) ? $atts['max'] : $input );

		$step = ( isset( $atts['step'] ) ? $atts['step'] : 1 );

		return ( $min <= $input && $input <= $max && is_int( $input / $step ) ? $input : $setting->default );

	}

endif;
