<?php
/**
 *
 * @package iwebbusiness
 */


function iwebbusiness_bg_custom_css() {
		?>
	<style type="text/css">
		<?php $iweb_header_img = get_header_image();?>
		<?php if ( null != $iweb_header_img ) : ?>
			.fullwidth
			{background: url( <?php echo esc_url( get_theme_mod( header_image() ) );?>) ;}
		<?php else : ?>
			.fullwidth
			{background-color: #fff;}
		<?php endif; ?>

		<?php if ( get_theme_mod( 'iwebbusiness_pheader_bgimg' ) != null ) :?>
			.iwebbusiness-page-header
			{background: url(<?php echo esc_url( get_theme_mod( 'iwebbusiness_pheader_bgimg' ) );?>) center center ;}
		<?php else : ?>
			.iwebbusiness-page-header
			{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/headerimg.jpg) center center ;}
		<?php endif; ?>

		.iwebbusiness-page-header h1:after
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		<?php if ( get_theme_mod( 'iwebbusiness_footer_bgimg' ) != null ) :?>
		 #footer-sidebar-w {
			background-image: linear-gradient( rgba(0,0,0,.8), rgba(0,0,0,.8) ), url(<?php echo esc_url( get_theme_mod( 'iwebbusiness_footer_bgimg' ) ); ?>) ;}
		<?php endif; ?>

		h2.entry-title
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

	</style>
<?php  }
add_action( 'wp_head','iwebbusiness_bg_custom_css' );

function iwebunq_themecolor1_custom_css() {
		?>
	<style type="text/css">
		.post-thumbnail img, #footer-sidebar .widget h2
		{border-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		.fullwidth, .iwebbusiness-uline h1 span::after
		{border-bottom-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		a:hover, .site-title a:hover, .site-info a:hover, .breadcrumb a, .ppost span, .npost span, .iweb-moretag, .iwebbusiness-button:hover
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		.iwebbusiness-button
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

			button,
			input[type="button"],
			input[type="reset"],
			input[type="submit"] {
		background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;
		border-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

	   @media screen and (min-width: 968px) {

		.search-form input[type="submit"], .form-submit input[type="submit"],
		.main-navigation ul li:hover > a, .main-navigation li ul li a:hover, .main-navigation li ul li a:focus
			{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}
		.ppost span, .npost span {
			color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		.main-navigation li > a:after, .main-navigation li li > a:before,
		.main-navigation .current-menu-item > a,
		.main-navigation .current-menu-ancestor > a,
		.main-navigation .current_page_item > a,
		.main-navigation .current_page_ancestor > a {
			color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) );?>;}
		}


	   @media screen and (max-width: 967px) {

		.search-submit, .form-submit input[type="submit"] {
			background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?> ;}
		.main-navigation a:hover, .main-navigation a:focus, .main-navigation li ul li a:hover,
		.main-navigation li ul li a:focus {
			color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?> ;}
	   }
	</style>
<?php  }

add_action( 'wp_head','iwebunq_themecolor1_custom_css' );


function iwebbusiness_themecolor_main_custom_css() {

	function iweb_hex2rgba( $iweb_color, $iweb_opacity = false ) {

		$iwebdefault = 'rgb(51,51,51)';

		//Return default if no color provided
		if ( empty( $iweb_color ) ) {
			return $iwebdefault;
		}

		//Sanitize $iweb_color if "#" is provided
		if ( '#' == $iweb_color[0] ) {
			$iweb_color = substr( $iweb_color, 1 );
		}

		//Check if color has 6 or 3 characters and get values
		if ( strlen( $iweb_color ) == 6 ) {
				$hex = array( $iweb_color[0] . $iweb_color[1], $iweb_color[2] . $iweb_color[3], $iweb_color[4] . $iweb_color[5] );
		} elseif ( strlen( $iweb_color ) == 3 ) {
				$hex = array( $iweb_color[0] . $iweb_color[0], $iweb_color[1] . $iweb_color[1], $iweb_color[2] . $iweb_color[2] );
		} else {
				return $iwebdefault;
		}

		//Convert hexadec to rgb
		$rgb = array_map( 'hexdec', $hex );

		//Check if opacity is set(rgba or rgb)
		if ( $iweb_opacity ) {
			if ( abs( $iweb_opacity ) > 1 ) {
				$iweb_opacity = 1.0;
			}
			$output = 'rgba( ' . implode( ',',$rgb ) . ',' . $iweb_opacity . ' )';
		} else {
			$output = 'rgb( ' . implode( ',',$rgb ) . ' )';
		}

		//Return rgb(a) color string
		return $output;
	}

	$iweb_color = esc_html( get_theme_mod( 'iweb_theme_color','#0080d6' ) );
	$iweb_rgba = iweb_hex2rgba( $iweb_color, 0.7 );
	$iweb_rgba2 = iweb_hex2rgba( $iweb_color, 0.1 );

?>
	<style type="text/css">
		.iwebbusiness-slider {
			background: url(<?php echo esc_url( get_theme_mod( 'iwebbusiness_slider_bgimg' ) );?>) ;}
			.iwebbusiness-slider::after {
			background: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?> ;}
	   .iwebbusiness-op-overlay
			{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?>;}

		<?php if ( get_theme_mod( 'iwebbusiness_slider_bgimg' ) == null ) :?>
			.iwebbusiness-slider
			{background: url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage2.jpg) ;}
		<?php endif; ?>

		body #iwebbusiness-bckgr {
			background: linear-gradient( rgba(0,0,0,0.6), rgba(0,0,0,0.6) ), url(<?php echo esc_url( get_template_directory_uri() ); ?>/img/defaultimage2.jpg) center repeat ;}
		p#iwebbusiness-os-a1p, .iwebbusiness-sectitle, .iwebbusiness_social .fa:hover
		{color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?> ;}

		.iwebbusiness-section4-b1 .iwebbusiness-button:hover
		{background-color: <?php echo esc_attr( get_theme_mod( 'iweb_theme_color','#0080d6' ) ); ?> ;}

		.iwebbusiness-barticles-a, .iwebbusiness-section5
		{background-color: <?php echo esc_attr( $iweb_rgba ); ?> ;}

		.bypostauthor .comment-body, .children .bypostauthor .comment-body
		{background-color: <?php echo esc_attr( $iweb_rgba2 ); ?> ;}

	</style>
<?php  }

add_action( 'wp_head','iwebbusiness_themecolor_main_custom_css' );

