<?php
/**
 * IWeb Business Theme Customizer
 *
 * @package iwebbusiness
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */

	// Load customize sanitize.
	get_template_part( '/inc/active-callback' );

function iwebbusiness_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial( 'blogname', array(
			'selector'        => '.site-title a',
			'render_callback' => 'iwebbusiness_customize_partial_blogname',
		) );
		$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
			'selector'        => '.site-description',
			'render_callback' => 'iwebbusiness_customize_partial_blogdescription',
		) );
	}

	// ----------------------------------------------------------------------
	// Add Theme Options Panel
	$wp_customize->add_panel('iwebbusiness_options_panel',array(
			'priority' => '51',
			'capability' => 'edit_theme_options',
			'theme_supports' => '',
			'title' => esc_html__( 'Theme Options','iweb-business' ),
			'description' => __( 'Visit <a target="_blank" href="http://www.iwebdm.com/wordpress-themes/documentation-business/">Documentation</a> for Theme Options.', 'iweb-business' ),
	));

	// Theme Settings ----------------------------------

		   $wp_customize->add_section('iwebbusiness_themesettings',array(
				'title' => __( 'Theme Settings','iweb-business' ),
				'priority' => '10',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
		   ));

		// add color picker setting
			$wp_customize->add_setting( 'iweb_theme_color', array(
				'default' => '#0080d6',
				'sanitize_callback' => 'sanitize_hex_color',
			) );

			$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'iweb_theme_color', array(
				'label' => 'Select Theme Color',
				'section' => 'iwebbusiness_themesettings',
				'settings' => 'iweb_theme_color',
			) ) );

	// Breadcrumb
					$wp_customize->add_setting('iwebbusiness_display_breadcrumb', array(
						'default' => '1',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_display_breadcrumb',array(
						'type' => 'radio',
						'label' => __( 'Display Breadcrumb', 'iweb-business' ),
						'section' => 'iwebbusiness_themesettings',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	// Post/Page Header Background Image
						$wp_customize->add_setting('iwebbusiness_pheader_bgimg', array(
							'default' => '',
							'capability' => 'edit_theme_options',
							'sanitize_callback' => 'iwebbusiness_sanitize_file',
						));

						$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebbusiness_pheader_bgimg', array(
							'label' => __( 'Page/Post Header Background Image', 'iweb-business' ),
							'description' => __( 'Your theme works best with an image with a header size of 1920 x 400 pixels', 'iweb-business' ),
							'section' => 'iwebbusiness_themesettings',
							'setting' => 'iwebbusiness_pheader_bgimg',
						)));

	// Slider ----------------------------------

			$wp_customize->add_section('iwebbusiness_slider',array(
				'title' => __( 'Slider','iweb-business' ),
				'priority' => '20',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

					  $wp_customize->add_setting('iwebbusiness_display_mslider', array(
						  'default' => '1',
						  'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					  ));

					$wp_customize->add_control('iwebbusiness_display_mslider',array(
						'type' => 'radio',
						'label' => __( 'Display Slider or A Static Image', 'iweb-business' ),
						'description' => __( 'Recommended Size for Featured Image in Post is 1600px x 600px','iweb-business' ),
						'section' => 'iwebbusiness_slider',
						'choices' => array(
							'1' => __( 'A Static Image','iweb-business' ),
							'0' => __( 'Slider','iweb-business' ),
						),
					));
	//  Title
				   $wp_customize->add_setting('iwebbusiness_slider_title', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_slider_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_slider',
						'setting' => 'iwebbusiness_slider_title',
					));
	//  Description
				   $wp_customize->add_setting('iwebbusiness_slider_desc', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_textarea_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_slider_desc',array(
						'type' => 'textarea',
						'label' => __( 'Description','iweb-business' ),
						'section' => 'iwebbusiness_slider',
						'setting' => 'iwebbusiness_slider_desc',
					));
	   // BG Image
				  $wp_customize->add_setting('iwebbusiness_slider_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebbusiness_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebbusiness_slider_bgimg', array(
						'label' => __( 'Background Image for Slider', 'iweb-business' ),
						'description' => __( 'Recommended Size- 1920x800px', 'iweb-business' ),
						'section' => 'iwebbusiness_slider',
						'setting' => 'iwebbusiness_slider_bgimg',
				   )));

		   //select category
					$wp_customize->add_setting('iwebbusiness_slider_category',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_slider_category', array(
						'label' => __( 'Select a category to show in slider','iweb-business' ),
						'section' => 'iwebbusiness_slider',
						'setting' => 'iwebbusiness_slider_category',
					)));

	// ------------------------------- Section 1

			$wp_customize->add_section('iwebbusiness_section1',array(
				'title' => __( 'Section 1','iweb-business' ),
				'priority' => '30',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebbusiness_display_section1', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebbusiness_display_section1',array(
						'type' => 'radio',
						'label' => __( 'Display Section 1', 'iweb-business' ),
						'section' => 'iwebbusiness_section1',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	//select category
					$wp_customize->add_setting('iwebbusiness_section1_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_section1_catg', array(
						'label' => __( 'Select a category','iweb-business' ),
						'section' => 'iwebbusiness_section1',
						'setting' => 'iwebbusiness_section1_catg',
					)));
	//  Button Text
				   $wp_customize->add_setting('iwebbusiness_section1_btntx', array(
						'default' => __( 'Download','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_section1_btntx',array(
						'type' => 'text',
						'label' => __( 'Button Text','iweb-business' ),
						'section' => 'iwebbusiness_section1',
						'setting' => 'iwebbusiness_section1_btntx',
					));
		// Button url
					$wp_customize->add_setting('iwebbusiness_section1_btnlink', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));
					$wp_customize->add_control('iwebbusiness_section1_btnlink',array(
						'type' => 'url',
						'label' => __( 'Button Url', 'iweb-business' ),
						'section' => 'iwebbusiness_section1',
						'setting' => 'iwebbusiness_section1_btnlink',
					));

	// ------------------------------- Section 2

			$wp_customize->add_section('iwebbusiness_section2',array(
				'title' => __( 'Section 2','iweb-business' ),
				'priority' => '35',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebbusiness_display_section2', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebbusiness_display_section2',array(
						'type' => 'radio',
						'label' => __( 'Display Section 2', 'iweb-business' ),
						'section' => 'iwebbusiness_section2',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	//  Title
				   $wp_customize->add_setting('iwebbusiness_section2_title', array(
						'default' => __( 'Section 2','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_section2_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_section2',
						'setting' => 'iwebbusiness_section2_title',
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_section2_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_section2_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_section2',
						'setting' => 'iwebbusiness_section2_catg',
					)));

	// ------------------------------- Section 3

			$wp_customize->add_section('iwebbusiness_section3',array(
				'title' => __( 'Section 3','iweb-business' ),
				 'description' => __( 'Required minimum 4 posts in a category. Featured image of oldest post will be displayed with title.', 'iweb-business' ),
				'priority' => '40',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebbusiness_display_section3', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebbusiness_display_section3',array(
						'type' => 'radio',
						'label' => __( 'Display Section 3', 'iweb-business' ),
						'section' => 'iwebbusiness_section3',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_section3_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_section3_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_section3',
						'setting' => 'iwebbusiness_section3_catg',
					)));

	// ------------------------------- Our Services

			$wp_customize->add_section('iwebbusiness_ourservice',array(
				'title' => __( 'Our Services','iweb-business' ),
				'priority' => '45',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

	// Display
					 $wp_customize->add_setting('iwebbusiness_display_ourservices', array(
						 'default' => '0',
						 'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					 ));

					$wp_customize->add_control('iwebbusiness_display_ourservices',array(
						'type' => 'radio',
						'label' => __( 'Display Our Services Section', 'iweb-business' ),
						'section' => 'iwebbusiness_ourservice',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	// No of Rows
					 $wp_customize->add_setting('iwebbusiness_os_rows', array(
						 'default' => '1',
						 'capability'        => 'edit_theme_options',
						 'sanitize_callback' => 'iwebbusiness_sanitize_number_range',
					 ));

					$wp_customize->add_control('iwebbusiness_os_rows',array(
						'label' => __( 'No. of Rows', 'iweb-business' ),
						'section' => 'iwebbusiness_ourservice',
						'type'        => 'number',
						'input_attrs' => array(
								'min'	=> 1,
								'max'	=> 2,
								'step'	=> 1,
							),
					));
	//  Title
				   $wp_customize->add_setting('iwebbusiness_os_title', array(
						'default' => __( 'Services We Offer', 'iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_os_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_ourservice',
						'setting' => 'iwebbusiness_os_title',
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_os_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_os_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_ourservice',
						'setting' => 'iwebbusiness_os_catg',
					)));

	// Section 4 -------------------------------

			 $wp_customize->add_section('iwebbusiness_section4',array(
				 'title' => __( 'Section 4','iweb-business' ),
				 'priority' => '50',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));
		// Display
					$wp_customize->add_setting('iwebbusiness_display_section4', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_display_section4',array(
						'type' => 'radio',
						'label' => __( 'Display Section 4', 'iweb-business' ),
						'section' => 'iwebbusiness_section4',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_section4_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_section4_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_section4',
						'setting' => 'iwebbusiness_section4_catg',
					)));

	// Section 5 --------------------------------

			 $wp_customize->add_section('iwebbusiness_section5',array(
				 'title' => __( 'Section 5','iweb-business' ),
				 'description' => __( 'This section is specially designed, so please visit <a target="_blank" href="http://www.iwebdm.com/wordpress-themes/documentation-business/">Documentation</a> for creating this section.', 'iweb-business' ),
				 'priority' => '55',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebbusiness_section5_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_section5_display',array(
						'type' => 'radio',
						'label' => __( 'Display Section 5', 'iweb-business' ),
						'section' => 'iwebbusiness_section5',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	   //select category
					$wp_customize->add_setting('iwebbusiness_section5_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_section5_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_section5',
						'setting' => 'iwebbusiness_section5_catg',
					)));

	// Our Projects --------------------------------

			$wp_customize->add_section('iwebbusiness_projects',array(
				'title' => __( 'Our Projects','iweb-business' ),
				 'description' => __( 'Minimum 3 posts required for better look.', 'iweb-business' ),
				'priority' => '60',
				'capability' => 'edit_theme_options',
				'panel' => 'iwebbusiness_options_panel',
			));

					  $wp_customize->add_setting('iwebbusiness_display_projects', array(
						  'default' => '0',
						  'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					  ));

					$wp_customize->add_control('iwebbusiness_display_projects',array(
						'type' => 'radio',
						'label' => __( 'Display Our Projects', 'iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	//  Title
				   $wp_customize->add_setting('iwebbusiness_op_title', array(
						'default' => __( 'Our Recent Works','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_op_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'setting' => 'iwebbusiness_op_title',
					));
	//  Description
				   $wp_customize->add_setting('iwebbusiness_op_desc', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_textarea_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_op_desc',array(
						'type' => 'textarea',
						'label' => __( 'Description','iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'setting' => 'iwebbusiness_op_desc',
					));
		   //select category
					$wp_customize->add_setting('iwebbusiness_op_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_op_catg', array(
						'label' => __( 'Select a category','iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'setting' => 'iwebbusiness_op_catg',
					)));
	//  Button Text
				   $wp_customize->add_setting('iwebbusiness_op_btntx', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_op_btntx',array(
						'type' => 'text',
						'label' => __( 'Button Text','iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'setting' => 'iwebbusiness_op_btntx',
					));
		// Button url
					$wp_customize->add_setting('iwebbusiness_op_btnlink', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'transport' => 'postMessage',
						'sanitize_callback' => 'esc_url_raw',
					));
					$wp_customize->add_control('iwebbusiness_op_btnlink',array(
						'type' => 'url',
						'label' => __( 'Button Url', 'iweb-business' ),
						'section' => 'iwebbusiness_projects',
						'setting' => 'iwebbusiness_op_btnlink',
					));

	// Our Team --------------------------------

			 $wp_customize->add_section('iwebbusiness_ourtim',array(
				 'title' => __( 'Our Team','iweb-business' ),
				 'description' => __( 'Minimum 5 posts required in a category for this section. Recommended Featured Image Size - 600x400px.', 'iweb-business' ),
				 'priority' => '65',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebbusiness_ourtim_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_ourtim_display',array(
						'type' => 'radio',
						'label' => __( 'Display Our Team Section', 'iweb-business' ),
						'section' => 'iwebbusiness_ourtim',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	//select category
					$wp_customize->add_setting('iwebbusiness_ourtim_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_ourtim_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_ourtim',
						'setting' => 'iwebbusiness_ourtim_catg',
					)));
		// Display Button
					$wp_customize->add_setting('iwebbusiness_ourtim_display_button', array(
						'default' => '1',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_ourtim_display_button',array(
						'type' => 'radio',
						'label' => __( 'Display Button', 'iweb-business' ),
						'section' => 'iwebbusiness_ourtim',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));

	// Testimonials --------------------------------

			 $wp_customize->add_section('iwebbusiness_tmonials',array(
				 'title' => __( 'Testimonials','iweb-business' ),
				 'priority' => '70',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebbusiness_tmonials_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_tmonials_display',array(
						'type' => 'radio',
						'label' => __( 'Display Testimonials Section', 'iweb-business' ),
						'section' => 'iwebbusiness_tmonials',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	//  Title
				   $wp_customize->add_setting('iwebbusiness_tmonials_title', array(
						'default' => __( 'Testimonials','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_tmonials_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_tmonials',
						'setting' => 'iwebbusiness_tmonials_title',
					));
	//select category
					$wp_customize->add_setting('iwebbusiness_tmonials_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_tmonials_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_tmonials',
						'setting' => 'iwebbusiness_tmonials_catg',
					)));

	// Blog Articles --------------------------------

			 $wp_customize->add_section('iwebbusiness_barticles',array(
				 'title' => __( 'Blog Articles','iweb-business' ),
				 'priority' => '75',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebbusiness_barticles_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_barticles_display',array(
						'type' => 'radio',
						'label' => __( 'Display Blog Articles Section', 'iweb-business' ),
						'section' => 'iwebbusiness_barticles',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	   //  Title
				   $wp_customize->add_setting('iwebbusiness_barticles_title', array(
						'default' => __( 'Blog Articles','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_barticles_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_barticles',
						'setting' => 'iwebbusiness_barticles_title',
					));
		// Description
				  $wp_customize->add_setting('iwebbusiness_barticles_desc', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_textarea_field',
				  ));
					$wp_customize->add_control( 'iwebbusiness_barticles_desc',array(
						'type' => 'textarea',
						'label' => __( 'Description','iweb-business' ),
						'section' => 'iwebbusiness_barticles',
						'setting' => 'iwebbusiness_barticles_desc',
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_barticles_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_barticles_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_barticles',
						'setting' => 'iwebbusiness_barticles_catg',
					)));

	// Our Clients --------------------------------

			 $wp_customize->add_section('iwebbusiness_oclients',array(
				 'title' => __( 'Our Clients','iweb-business' ),
				 'description' => __( 'Recommended Featured Image size of a post is 200x100px', 'iweb-business' ),
				 'priority' => '80',
				 'capability' => 'edit_theme_options',
				 'panel' => 'iwebbusiness_options_panel',
			 ));

		// Display
					$wp_customize->add_setting('iwebbusiness_oclients_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_oclients_display',array(
						'type' => 'radio',
						'label' => __( 'Display Our Clients Section', 'iweb-business' ),
						'section' => 'iwebbusiness_oclients',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
	   //  Title
				   $wp_customize->add_setting('iwebbusiness_oclients_title', array(
						'default' => __( 'Our Clients','iweb-business' ),
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				   ));
					$wp_customize->add_control( 'iwebbusiness_oclients_title',array(
						'type' => 'text',
						'label' => __( 'Title','iweb-business' ),
						'section' => 'iwebbusiness_oclients',
						'setting' => 'iwebbusiness_oclients_title',
					));
		//select category
					$wp_customize->add_setting('iwebbusiness_oclients_catg',array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'absint',
					));

					$wp_customize->add_control( new Iwebbusiness_WP_Customize_Category_Control( $wp_customize,'iwebbusiness_oclients_catg', array(
						'label' => __( 'Select a Category','iweb-business' ),
						'section' => 'iwebbusiness_oclients',
						'setting' => 'iwebbusiness_oclients_catg',
					)));

	// Footer Section ------------------------------------------

			   $wp_customize->add_section('iwebbusiness_footer_bg',array(
				   'title' => __( 'Footer Section','iweb-business' ),
				   'priority' => '85',
				   'capability' => 'edit_theme_options',
				   'panel' => 'iwebbusiness_options_panel',
			   ));

	   // Copyright Text
				$wp_customize->add_setting('iweb_copyright_text', array(
						'default' => '',
						'transport' => 'postMessage',
						'sanitize_callback' => 'sanitize_text_field',
				));

				$wp_customize->add_control('iweb_copyright_text',array(
						'type' => 'text',
						'label' => __( 'Footer Copyright Text','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iweb_copyright_text',
				));

	   // BG Image
				  $wp_customize->add_setting('iwebbusiness_footer_bgimg', array(
						'default' => '',
						'capability' => 'edit_theme_options',
						'sanitize_callback' => 'iwebbusiness_sanitize_file',
				  ));

				   $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'iwebbusiness_footer_bgimg', array(
						'label' => __( 'Background Image for Footer Widgets', 'iweb-business' ),
						'description' => __( 'Recommended Size- 1600x600px', 'iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_footer_bgimg',
				   )));

		// Display Social Icons
					$wp_customize->add_setting('iwebbusiness_social_display', array(
						'default' => '0',
						'sanitize_callback' => 'iwebbusiness_sanitize_radio',
					));

					$wp_customize->add_control('iwebbusiness_social_display',array(
						'type' => 'radio',
						'label' => __( 'Display Social Icons', 'iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'choices' => array(
							'1' => __( 'Enable','iweb-business' ),
							'0' => __( 'Disable','iweb-business' ),
							),
					));
		  // Facebook - Social Icon #1 URL
					$wp_customize->add_setting('iwebbusiness_social1_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebbusiness_social1_url',array(
						'type' => 'url',
						'description' => __( 'Facebook URL','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_social1_url',
						'active_callback' => 'iwebbusiness_footer_social',
					));
		  // Twitter - Social Icon #2 URL
					$wp_customize->add_setting('iwebbusiness_social2_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebbusiness_social2_url',array(
						'type' => 'url',
						'description' => __( 'Twitter URL','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_social2_url',
						'active_callback' => 'iwebbusiness_footer_social',
					));
		  // Instagram - Social Icon #3 URL
					$wp_customize->add_setting('iwebbusiness_social3_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebbusiness_social3_url',array(
						'type' => 'url',
						'description' => __( 'Instagram URL','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_social3_url',
						'active_callback' => 'iwebbusiness_footer_social',
					));
		  // Linkedin - Social Icon #4 URL
					$wp_customize->add_setting('iwebbusiness_social4_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebbusiness_social4_url',array(
						'type' => 'url',
						'description' => __( 'Linkedin URL','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_social4_url',
						'active_callback' => 'iwebbusiness_footer_social',
					));
		  // Youtube - Social Icon #4 URL
					$wp_customize->add_setting('iwebbusiness_social5_url', array(
						'default' => '',
						'sanitize_callback' => 'esc_url_raw',
					));

					$wp_customize->add_control('iwebbusiness_social5_url',array(
						'type' => 'url',
						'description' => __( 'Youtube URL','iweb-business' ),
						'section' => 'iwebbusiness_footer_bg',
						'setting' => 'iwebbusiness_social5_url',
						'active_callback' => 'iwebbusiness_footer_social',
					));

	// ----------------------------------------------------------------------
}
add_action( 'customize_register', 'iwebbusiness_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function iwebbusiness_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function iwebbusiness_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function iwebbusiness_customize_preview_js() {
	wp_enqueue_script( 'iwebbusiness-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'iwebbusiness_customize_preview_js' );



function iwebbusiness_sanitize_dropdown_pages( $page_id, $setting ) {
	// Ensure $input is an absolute integer.
	$page_id = absint( $page_id );

	// If $page_id is an ID of a published page, return it; otherwise, return the default.
	return ( 'publish' == get_post_status( $page_id ) ? $page_id : $setting->default );
}
