<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package IT_Zone
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog__card' ); ?> itemscope itemtype="https://schema.org/Blog">
	<figure class="blog__img">
		<a href="<?php echo esc_url( get_permalink() ); ?>" class="post-thumbnail">
			<?php
			if ( has_post_thumbnail() ) {
				the_post_thumbnail( 'blog_card_image' );
			} else {
				it_zone_get_fallback_svg( 'blog_card_image' );
			}
			?>
		</a>
		<?php it_zone_posted_on(); ?>
	</figure>
	<div class="blog__info">
		<?php it_zone_category(); ?>
		<h4>
			<a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>">
				<?php the_title(); ?>
			</a>
		</h4>
	</div>
</article>
