// Initial Listener
window.addEventListener('load', function () {

  let mediEvent = {};
  let focusableElements = null
  let lastElement = null;
  let firstElement = null;
  let isFocusInsideSidebar = false;

  const sidebar = document.querySelector('#mobileSideMenu');
  const hamBarEl = document.querySelector('#sideMenuOpener')
  const mobileSideMenuClose = document.querySelector('#mobileSidebarClose')

  document.addEventListener('keydown', function (e) {
    mediEvent = e;

    /**
     * Open the sidebar when the hamburger button is focused and the enter or space key is pressed.
     */
    if (document.activeElement === hamBarEl && (mediEvent.code.toLowerCase() === "enter" || mediEvent.code.toLowerCase() === "space")) {
      getInsideSidebar()
    }

    /**
     * Focus the first link after the sidebar is open and the tab key is pressed.
     */
    if (sidebar.classList.contains('is-open') && mediEvent.key === "Tab" && !isFocusInsideSidebar) {
      getInsideSidebar()
      isFocusInsideSidebar = true;
    }

    function getInsideSidebar() {
      // open the sidebar
      hamBarEl.click();

      const firstLink = sidebar.querySelector('a');

      let targetElement;
      if (firstLink && firstLink.closest('.sidebar-top-wrap')) {
        targetElement = firstLink;
      } else {
        targetElement = document.querySelector('#mobileSidebarClose');
      }
      setTimeout(() => {
        if (targetElement) {
          targetElement.focus();
        }
      }, 0)
    }

    /**
     * Focus the next link after the sidebar when the tab key is pressed.
     */
    if (document.activeElement === hamBarEl && mediEvent.key === "Tab" && !mediEvent.shiftKey && !isFocusInsideSidebar) {
      e.preventDefault();
      const nextLink = getNextAnchorAfterSidebar();
      if (nextLink) {
        nextLink.focus();
      }
    }

    /**
     * Focus the hamburger button when Shift + Tab is pressed.
     */
    if (getNextAnchorAfterSidebar() == document.activeElement && mediEvent.key === "Tab" && mediEvent.shiftKey && !isFocusInsideSidebar) {
      const headerEl = hamBarEl.closest('.mobile-header');
      const isMobileHidden = getComputedStyle(headerEl).display === 'none';

      if (isMobileHidden) {
        const links = document.querySelectorAll('.desktop-header .menu-container a');
        if (links.length > 0) {
          const lastLink = links[links.length - 1];
          lastLink.focus();
        }
      } else {
        e.preventDefault();
        hamBarEl.focus();
      }
    }

    /**
     * Get the next anchor after the sidebar.
     * @returns {Element} The next anchor after the sidebar.
     */
    function getNextAnchorAfterSidebar() {
      const sidebar = document.querySelector('#mobileSideMenu');
      const allLinks = Array.from(document.querySelectorAll('a'));

      for (const link of allLinks) {
        if (!sidebar.contains(link)) {
          if (sidebar.compareDocumentPosition(link) & Node.DOCUMENT_POSITION_FOLLOWING) {
            return link;
          }
        }
      }

      return null;
    }
    /**
     * First focus only
     */
    if (mediEvent.key === "Tab" && !mediEvent.shiftKey && !isFocusInsideSidebar) {
      focusableElements = document.querySelectorAll('a, button');
      lastElement = focusableElements[focusableElements.length - 1];
      firstElement = focusableElements[0];


      if (document.activeElement === lastElement && !mediEvent.shiftKey) {
        mediEvent.preventDefault();
        setTimeout(() => {
          firstElement.focus();
        }, 0);
      }
    }

    /**
     * Last foucs only
     */
    if (mediEvent.shiftKey && mediEvent.key === "Tab") {
      focusableElements = document.querySelectorAll('a, button');
      lastElement = focusableElements[focusableElements.length - 1];
      firstElement = focusableElements[0];
      if (document.activeElement === firstElement && mediEvent.shiftKey && !isFocusInsideSidebar) {
        e.preventDefault()
        setTimeout(() => {
          lastElement.focus();
        }, 0);
      }
    }

    if (isFocusInsideSidebar) {
      focusableElements = sidebar.querySelectorAll('a, button');
      lastElement = focusableElements[focusableElements.length - 1];
      firstElement = focusableElements[0];
      const dropDownNotActive = document.activeElement.matches('.angle-down:not(.active)');

      /**
       * First focus inside sidebar when the last element is focused
       */
      if (document.activeElement === lastElement && !e.shiftKey) {
        e.preventDefault();
        setTimeout(() => {
          firstElement.focus();
        }, 0);
      }

      /**
       * Last focus inside sidebar when the first element is focused
       */
      if (document.activeElement === firstElement && e.shiftKey) {
        e.preventDefault()
        setTimeout(() => {
          lastElement.focus();
        }, 0);
      }

      /**
       * Close the sidebar when the close button is focused and the enter or space key is pressed.
       */
      if (document.activeElement === mobileSideMenuClose && (e.code.toLowerCase() === "enter" || e.code.toLowerCase() === "space")) {
        mobileSidebarClose.click();
        setTimeout(() => {
          hamBarEl.focus()
        }, 0)
      }

      /**
       * Focus the next link after the sidebar when the tab key is pressed.
       */
      if (mediEvent.key === "Tab" && !mediEvent.shiftKey) {
        const isDropdownToggle = document.activeElement.matches('.angle-down');
        const isInactive = document.activeElement.matches('.angle-down:not(.active)');

        if (isDropdownToggle) {
          const subMenu = document.activeElement
            .closest('li')
            ?.querySelector('.sub-menu');

          if (subMenu) {
            subMenu.querySelectorAll('a').forEach(el => {
              el.setAttribute('tabindex', isInactive ? '-1' : '0');
            });
          }
        }
      }

      /**
       * Focus the previous link after the sidebar when the shift + tab key is pressed.
       */
      if (mediEvent.key === "Tab" && mediEvent.shiftKey && dropDownNotActive) {
        const currentLi = document.activeElement.closest('li');
        const previousSibling = currentLi?.previousElementSibling;
        if (previousSibling && previousSibling.classList.contains('menu-item-has-children')) {
          e.preventDefault();
          previousSibling.querySelector('button').focus();
        }
      }
    }
  });
  sidebar.addEventListener('focusin', function (event) {
    focusableElements = sidebar.querySelectorAll('a, button');
    lastElement = focusableElements[focusableElements.length - 1];
    firstElement = focusableElements[0];
    isFocusInsideSidebar = true;
  });

  sidebar.addEventListener('focusout', function (event) {
    isFocusInsideSidebar = false;
  });

  // accessibility submenu - desktop
  let allowTrigger = true;
  const hasChilds = document.querySelectorAll('.desktop-header .menu-container > .menu.nav-menu > .menu-item-has-children')

  hasChilds.forEach((hasChild) => {
    const allSubMenu = hasChild.querySelectorAll('.sub-menu');
    let allSubMenuItems = [];

    const parentDropDown = hasChild.querySelectorAll(':scope > .sub-menu')

    if (parentDropDown && parentDropDown.length > 0) {
      parentDropDown.forEach(submenu => {
        const items = submenu.querySelectorAll('li');
        allSubMenuItems.push(...items);
      });
    }
    const lastLink = allSubMenuItems[allSubMenuItems.length - 1];

    hasChild.addEventListener('focusin', function (e) {
      e.preventDefault();
      allSubMenu.forEach((submenu) => {
        submenu.style.visibility = 'visible';
        submenu.style.opacity = 1;
      });
      if (mediEvent.shiftKey && mediEvent.key === "Tab" && allowTrigger) {
        e.preventDefault();
        allowTrigger = false
        setTimeout(() => {
          const myLastLink = lastLink.querySelector('a')
          myLastLink.focus();
          myLastLink.classList.add('focus');
        }, 100);
      }
    });

    hasChild.addEventListener('focusout', function (e) {
      allSubMenu.forEach((submenu) => {
        submenu.style.visibility = 'hidden';
        submenu.style.opacity = 0;
      })
    });

    hasChild.addEventListener('keydown', function (event) {
      if (event.key === "Tab" && event.shiftKey && !allowTrigger) {
        const focusableEls = hasChild.querySelectorAll('a')
        const activeElement = document.activeElement;
        if (hasChild.contains(activeElement)) {
          if (focusableEls[0] === activeElement) {
            allowTrigger = true
          }
        }
      }
    });
  })

  document.querySelector('.desktop-header .menu-container').addEventListener('mouseover', (e) => {
    const li = e.target.closest('.menu-item-has-children');
    if (li) {
      const subMenu = li.querySelector(':scope > .sub-menu');
      if (subMenu) {
        subMenu.style.visibility = 'visible';
        subMenu.style.opacity = 1;
      }
    }
  });

  document.querySelector('.desktop-header .menu-container').addEventListener('mouseout', (e) => {
    const li = e.target.closest('.menu-item-has-children');
    if (li) {
      const subMenu = li.querySelector(':scope > .sub-menu');
      if (subMenu) {
        subMenu.style.visibility = 'hidden';
        subMenu.style.opacity = 0;
      }
    }
  });

})