<?php
/**
 * IT Zone Typography Related Functions
 *
 * @package IT_Zone
 */

if ( ! function_exists( 'it_zone_google_fonts_url' ) ) :
	/**
	 * Get Google Fonts URL for the theme.
	 *
	 * @since 1.0.0
	 * @return string Google Fonts URL.
	 */
	function it_zone_google_fonts_url() {
		$fonts_url = '';
		// Ignore any non-Google fonts.

		$opensans_font = _x( 'on', 'Open Sans font: on or off', 'it-zone' );

		if ( 'off' !== $opensans_font ) {
			$font_families[] = 'Plus Jakarta Sans:400,400i,500,500i,600,600i,700,700i';

			$query_args = array(
				'family'  => urlencode( implode( '|', $font_families ) ),
				'subset'  => urlencode( 'latin,latin-ext' ),
				'display' => urlencode( 'fallback' ),
			);

			$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );

			$toggle_localgoogle_fonts = get_theme_mod( 'toggle_localgoogle_fonts', true );

			if ( $toggle_localgoogle_fonts ) {
				$font_families = array(
					'Plus+Jakarta+Sans:ital,wght@0,400;0,500;0,600;0,700;1,400;1,500;1,600;1,700',
				);

				$fonts_url = add_query_arg(
					array(
						'family'  => implode( '&family=', $font_families ),
						'display' => 'swap',
					),
					'https://fonts.googleapis.com/css2'
				);

				$fonts_url = it_zone_get_webfont_url( esc_url_raw( $fonts_url ) );
			} else {
				$fonts_url = $fonts_url;
			}
		}
		return esc_url( $fonts_url );
	}
endif;
