<?php
/**
 * Servie Icon uploader JS conditional rendering
 *
 * @return void
 */

/**
 * IT_Zone Metabox for Sidebar Layout
 *
 * @package IT_Zone
 */
function it_zone_add_sidebar_layout_box() {
	add_meta_box(
		'it_zone_sidebar_layout',
		__( 'Sidebar Layout', 'it-zone' ),
		'it_zone_sidebar_layout_callback',
		array( 'page', 'post' ),
		'normal',
		'high'
	);
}
add_action( 'add_meta_boxes', 'it_zone_add_sidebar_layout_box' );

function it_zone_sidebar_layout_callback( $post ) {
	$sidebar_layout = array(
		'default'       => array(
			'value'     => 'default',
			'label'     => __( 'Default Sidebar', 'it-zone' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/default.png',
		),
		'full-width'    => array(
			'value'     => 'full-width',
			'label'     => __( 'Full Sidebar', 'it-zone' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/full-width.jpg',
		),
		'left-sidebar'  => array(
			'value'     => 'left-sidebar',
			'label'     => __( 'Left Sidebar', 'it-zone' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/left.jpg',
		),
		'right-sidebar' => array(
			'value'     => 'right-sidebar',
			'label'     => __( 'Right Sidebar', 'it-zone' ),
			'thumbnail' => get_template_directory_uri() . '/assets/images/sidebar/right.jpg',
		),
	);
	// Output the nonce field
	wp_nonce_field( 'it_zone_sidebar_nonce', 'it_zone_sidebar_nonce' );
	?>     
	<div>
		<h4>
			<?php esc_html_e( 'Choose Sidebar Template', 'it-zone' ); ?>
		</h4>

		<div class="sidebar-layout" >
			<?php
			foreach ( $sidebar_layout as $layout ) {
				$value = get_post_meta( $post->ID, 'it_zone_sidebar_layout', true );
				?>
					<div class="sidebar-option">
						<input 
							id="<?php echo esc_attr( $layout['value'] ); ?>" 
							type="radio" 
							name="mp_sidebar_layout" 
							value="<?php echo esc_attr( $layout['value'] ); ?>" 
							<?php
							checked( $layout['value'], $value );
							if ( empty( $value ) ) {
								checked( $layout['value'], 'default' );
							}
							?>
						/>
						<label class="description" for="<?php echo esc_attr( $layout['value'] ); ?>">
							<img src="<?php echo esc_url( $layout['thumbnail'] ); ?>" />                               
						</label>
					</div>
				<?php
			}
			?>
		</div>
	</div>
	<?php
}

function it_zone_save_sidebar_layout( $post_id ) {
	// Verify the nonce before proceeding.
	if ( ! isset( $_POST['it_zone_sidebar_nonce'] ) || ! wp_verify_nonce( $_POST['it_zone_sidebar_nonce'], 'it_zone_sidebar_nonce' ) ) {
		return;
	}

	// Check if the user has permission to edit the post
	if ( ! current_user_can( 'edit_post', $post_id ) ) {
		return $post_id;
	}

	if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
		return;
	}

	if ( isset( $_POST['mp_sidebar_layout'] ) ) {
		$selected_layout = sanitize_key( $_POST['mp_sidebar_layout'] );

		$valid_layouts = array(
			'default',
			'full-width',
			'left-sidebar',
			'right-sidebar',
		);

		if ( in_array( $selected_layout, $valid_layouts ) ) {
			update_post_meta( $post_id, 'it_zone_sidebar_layout', $selected_layout );
		} else {
			// If the selected layout is not valid, default to 'full-width' or handle the error appropriately
			update_post_meta( $post_id, 'it_zone_sidebar_layout', 'full-width' );
		}
	}
}
add_action( 'save_post', 'it_zone_save_sidebar_layout' );
