<?php

if ( ! function_exists( 'it_zone_customize_register_typography_body' ) ) :
	/**
	 * Typography Body Settings
	 *
	 * @package IT Zone Pro
	 */
	function it_zone_customize_register_typography_body( $wp_customize ) {
		$wp_customize->add_section(
			'typography_settings',
			array(
				'title'    => __( 'Typography Settings', 'it-zone' ),
				'priority' => 50,
				'panel'    => 'appearance_settings',
			)
		);

		$wp_customize->add_setting(
			'toggle_localgoogle_fonts',
			array(
				'default'           => false,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'toggle_localgoogle_fonts',
				array(
					'label'   => __( 'Enable to load the google fonts locally.', 'it-zone' ),
					'section' => 'typography_settings',
					'type'    => 'checkbox',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_typography_body' );
