<?php
/**
 * IT Zone Theme Information Link Section
 *
 * @package IT_Zone
 */

if ( ! function_exists( 'it_zone_theme_info' ) ) :
	/**
	 * Add theme information and pro upgrade sections to customizer.
	 *
	 * @since 1.0.0
	 * @param WP_Customize_Manager $customizer_manager The customizer manager object.
	 * @return void
	 */
	function it_zone_theme_info( $customizer_manager ) {
		// Add theme info section
		$customizer_manager->add_section(
			'theme_info',
			array(
				'title'    => esc_html__( 'Information Links', 'it-zone' ),
				'priority' => 6,
			)
		);

		/** Important Links */
		$customizer_manager->add_setting(
			'theme_info_theme',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$theme_info  = '<ul>';
		$theme_info .= sprintf( __( '<li>View documentation: %1$sClick here.%2$s</li>', 'it-zone' ), '<a href="' . esc_url( 'https://glthemes.com/documentation/it-zone/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>Theme info: %1$sClick here.%2$s</li>', 'it-zone' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/it-zone/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>Support ticket: %1$sClick here.%2$s</li>', 'it-zone' ), '<a href="' . esc_url( 'https://glthemes.com/support/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= sprintf( __( '<li>More WordPress Themes: %1$sClick here.%2$s</li>', 'it-zone' ), '<a href="' . esc_url( 'https://glthemes.com/wordpress-theme/' ) . '" target="_blank" rel="nofollow">', '</a>' );
		$theme_info .= '</ul>';

		$customizer_manager->add_control(
			new IT_Zone_Note_Control(
				$customizer_manager,
				'theme_info_theme',
				array(
					'label'       => esc_html__( 'Important Links', 'it-zone' ),
					'section'     => 'theme_info',
					'description' => $theme_info,
				)
			)
		);

		// Add pro upgrade section using the proper View Pro control
		$customizer_manager->add_section(
			new IT_Zone_View_Pro_Control(
				$customizer_manager,
				'it_zone_view_pro',
				array(
					'title'    => esc_html__( 'Pro Available', 'it-zone' ),
					'priority' => 5,
					'pro_text' => esc_html__( 'VIEW PRO THEME', 'it-zone' ),
					'pro_url'  => 'https://glthemes.com/wordpress-theme/it-zone-pro/',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_theme_info', 9999 );
