<?php

if ( ! function_exists( 'it_zone_customize_register_postpage' ) ) :
	/**
	 * Posts(Blog) & Pages Settings
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function it_zone_customize_register_postpage( $wp_customize ) {
		/** Posts(Blog) & Pages Settings */
		$wp_customize->add_section(
			'post_page_settings',
			array(
				'title'    => __( 'Post & Pages Settings', 'it-zone' ),
				'priority' => 40,
				'panel'    => 'general_settings_panel',
			)
		);

		/** Single Page Posted Date */
		$wp_customize->add_setting(
			'ed_single_posted_date',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_single_posted_date',
				array(
					'label'       => __( 'Show/Hide Posted Date', 'it-zone' ),
					'description' => __( 'Enable to show posted date or disable to hide posted date', 'it-zone' ),
					'section'     => 'post_page_settings',
					'type'        => 'checkbox',
				)
			)
		);

		$wp_customize->add_setting(
			'ed_single_posted_author',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_single_posted_author',
				array(
					'label'       => __( 'Show/Hide Author Name', 'it-zone' ),
					'description' => __( 'Enable to show author name or disable to hide author name', 'it-zone' ),
					'section'     => 'post_page_settings',
					'type'        => 'checkbox',
				)
			)
		);

		// Reading Time Toggle
		$wp_customize->add_setting(
			'ed_single_meta_reading_time',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
				'transport'         => 'refresh',
			)
		);
		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_single_meta_reading_time',
				array(
					'label'   => __( 'Show Reading Time', 'it-zone' ),
					'section' => 'post_page_settings',
					'type'    => 'checkbox',
				)
			)
		);
		// Add the toggle control to the section
		$wp_customize->add_setting(
			'mp_author',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'mp_author',
				array(
					'label'       => __( 'Show/Hide Author Section', 'it-zone' ),
					'description' => __( 'Enable to show author section in the post.', 'it-zone' ),
					'section'     => 'post_page_settings',
					'type'        => 'checkbox',
				)
			)
		);

		/** Line break for post and page settings */
		$wp_customize->add_setting(
			'single_note',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Note_Control(
				$wp_customize,
				'single_note',
				array(
					'section' => 'post_page_settings',
				)
			)
		);

		/** Show/hide Related post in single */
		$wp_customize->add_setting(
			'toggle_related_post',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'toggle_related_post',
				array(
					'label'       => __( 'Show/Hide Related Post', 'it-zone' ),
					'description' => __( 'Enable to show related post in single page.', 'it-zone' ),
					'section'     => 'post_page_settings',
					'type'        => 'checkbox',
				)
			)
		);

		// add settings and control for Related Post subheading settings
		$wp_customize->add_setting(
			'related_post_heading',
			array(
				'default'           => __( 'You May Also Like', 'it-zone' ),
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'related_post_heading',
			array(
				'selector'        => '.related-post .section-header__title',
				'render_callback' => function () {
					return esc_html( get_theme_mod( 'related_post_heading', __( 'You May Also Like', 'it-zone' ) ) );
				},
			)
		);
		$wp_customize->add_control(
			'related_post_heading',
			array(
				'label'           => __( 'Heading', 'it-zone' ),
				'section'         => 'post_page_settings',
				'type'            => 'text',
				'active_callback' => 'it_zone_ed_related_post_active_callback',
			)
		);
		/** Posts(Blog) & Pages Settings Ends */
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_postpage' );

function it_zone_ed_related_post_active_callback( $control ) {
	$toggle_related_post = $control->manager->get_setting( 'toggle_related_post' )->value();

	$id = $control->id;

	if ( $id == 'related_post_heading' && $toggle_related_post ) {
		return true;
	}

	return false;
}
