<?php

if ( ! function_exists( 'it_zone_customize_register_post_archive' ) ) :
	/**
	 * Servive single post and archive
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function it_zone_customize_register_post_archive( $wp_customize ) {
		$wp_customize->add_section(
			'post_archive',
			array(
				'title'    => __( 'Blog, Search and Archive Settings', 'it-zone' ),
				'panel'    => 'general_settings_panel',
				'priority' => 30,
			)
		);

		$wp_customize->add_setting(
			'itz_archive_prefix',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'itz_archive_prefix',
				array(
					'label'       => __( 'Show/Hide Prefix', 'it-zone' ),
					'description' => __( 'Enable to hide prefix in archive page.', 'it-zone' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Archive Posted Date */
		$wp_customize->add_setting(
			'ed_archive_posted_date',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'ed_archive_posted_date',
			array(
				'selector'        => '.blog__posted-on',
				'render_callback' => function () {
					return get_theme_mod( 'ed_archive_posted_date', true );
				},
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_archive_posted_date',
				array(
					'label'       => __( 'Show/Hide Posted Date', 'it-zone' ),
					'description' => __( 'Enable to show posted date or disable to hide posted date', 'it-zone' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Archive Posted Date */
		$wp_customize->add_setting(
			'ed_archive_post_category',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'ed_archive_post_category',
			array(
				'selector'        => '.blog__info',
				'render_callback' => function () {
					return get_theme_mod( 'ed_archive_post_category', true );
				},
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_archive_post_category',
				array(
					'label'       => __( 'Show/Hide Post Category', 'it-zone' ),
					'description' => __( 'Enable to show post category or disable to hide post category', 'it-zone' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		/** Line break for post and page settings */
		$wp_customize->add_setting(
			'search_page_note',
			array(
				'default'           => '',
				'sanitize_callback' => 'wp_kses_post',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Note_Control(
				$wp_customize,
				'search_page_note',
				array(
					'section' => 'post_archive',
				)
			)
		);

		$wp_customize->add_setting(
			'post_archive_search_notice',
			array(
				'sanitize_callback' => 'sanitize_text_field',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Notice_Control(
				$wp_customize,
				'post_archive_search_notice',
				array(
					'label'   => __( 'Search Page Settings', 'it-zone' ),
					'section' => 'post_archive',
				)
			)
		);

		// Toggle to enable/disable entire search block
		$wp_customize->add_setting(
			'ed_search_block',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'ed_search_block',
				array(
					'label'       => __( 'Show/Hide Search block', 'it-zone' ),
					'description' => __( 'Enable to show post search form or disable to hide search form', 'it-zone' ),
					'section'     => 'post_archive',
					'type'        => 'checkbox',
				)
			)
		);

		// Search Heading Text
		$wp_customize->add_setting(
			'search_heading_text',
			array(
				'default'           => __( 'New Search:', 'it-zone' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'search_heading_text',
			array(
				'selector'        => '.search-heading',
				'render_callback' => function () {
					return '<h4 class="search-heading">' . esc_html( get_theme_mod( 'search_heading_text', __( 'New Search:', 'it-zone' ) ) ) . '</h4>';
				},
			)
		);

		$wp_customize->add_control(
			'search_heading_text',
			array(
				'label'   => __( 'Search Heading', 'it-zone' ),
				'section' => 'post_archive',
				'type'    => 'text',
			)
		);

		// Search Description Textarea
		$wp_customize->add_setting(
			'search_description_text',
			array(
				'default'           => __( 'Please conduct another search if you are not satisfied with the outcomes below.', 'it-zone' ),
				'sanitize_callback' => 'wp_kses_post',
				'transport'         => 'postMessage',
			)
		);

		$wp_customize->selective_refresh->add_partial(
			'search_description_text',
			array(
				'selector'        => '.description',
				'render_callback' => function () {
					return '<p class="description">' . esc_html( get_theme_mod( 'search_description_text', __( 'Please conduct another search if you are not satisfied with the outcomes below.', 'it-zone' ) ) ) . '</p>';
				},
			)
		);

		$wp_customize->add_control(
			'search_description_text',
			array(
				'label'   => __( 'Search Description', 'it-zone' ),
				'section' => 'post_archive',
				'type'    => 'textarea',
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_post_archive' );
