<?php

if ( ! function_exists( 'it_zone_customize_register_pagination_settings' ) ) :
	/**
	 * Pagination Settings
	 *
	 * @package IT_Zone
	 */
	function it_zone_customize_register_pagination_settings( $wp_customize ) {
		/** Pagination Settings */
		$wp_customize->add_section(
			'pagination_settings',
			array(
				'title'    => __( 'Pagination Settings', 'it-zone' ),
				'panel'    => 'general_settings_panel',
				'priority' => 80,
			)
		);

		/** Pagination Type */
		$wp_customize->add_setting(
			'pagination_type',
			array(
				'default'           => 'numbered',
				'sanitize_callback' => 'it_zone_radio_sanitization_header',
			)
		);

		$wp_customize->add_control(
			'pagination_type',
			array(
				'type'        => 'radio',
				'section'     => 'pagination_settings',
				'label'       => __( 'Pagination Type', 'it-zone' ),
				'description' => __( 'Select pagination of your choice.', 'it-zone' ),
				'choices'     => array(
					'default'  => __( 'Default (Older / Newer)', 'it-zone' ),
					'numbered' => __( 'Numbered (1 2 3 4...)', 'it-zone' ),
				),
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_pagination_settings' );
