<?php

if ( ! function_exists( 'it_zone_customize_register_socialmedia' ) ) :
	/**
	 * Headers Socialmedia
	 *
	 * @param [type] $wp_customize
	 * @return void
	 */
	function it_zone_customize_register_socialmedia( $wp_customize ) {
		// Create a new section top bar settings----------
		$wp_customize->add_section(
			'social_media_section',
			array(
				'title'    => __( 'Social Media Settings', 'it-zone' ),
				'priority' => 20,
				'panel'    => 'general_settings_panel',
			)
		);

		// Add the toggle control to the section
		$wp_customize->add_setting(
			'socialmedia_toggle',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'socialmedia_toggle',
				array(
					'label'       => __( 'Show/Hide Social Media', 'it-zone' ),
					'description' => __( 'Enable to show the social media.', 'it-zone' ),
					'section'     => 'social_media_section',
					'type'        => 'checkbox',
				)
			)
		);

		$wp_customize->add_setting(
			'socialmedia_heading',
			array(
				'default'           => __( 'Follow Us:', 'it-zone' ),
				'sanitize_callback' => 'sanitize_text_field',
				'transport'         => 'postMessage',
			)
		);

		// Facebook Link
		$wp_customize->add_setting(
			'social_facebook_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_facebook_link',
			array(
				'label'           => esc_html__( 'Facebook Link', 'it-zone' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_social_media_active_callback',
			)
		);

		// Instagram Link
		$wp_customize->add_setting(
			'social_instagram_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_instagram_link',
			array(
				'label'           => esc_html__( 'Instagram Link', 'it-zone' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_social_media_active_callback',
			)
		);

		// LinkedIn Link
		$wp_customize->add_setting(
			'social_linkedin_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_linkedin_link',
			array(
				'label'           => esc_html__( 'LinkedIn Link', 'it-zone' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_social_media_active_callback',
			)
		);

		// Pinterest Link
		$wp_customize->add_setting(
			'social_pinterest_link',
			array(
				'default'           => '#',
				'sanitize_callback' => 'esc_url_raw',
			)
		);

		$wp_customize->add_control(
			'social_pinterest_link',
			array(
				'label'           => esc_html__( 'Pinterest Link', 'it-zone' ),
				'section'         => 'social_media_section',
				'type'            => 'url',
				'active_callback' => 'it_zone_social_media_active_callback',
			)
		);

		// Open in new tab toggle
		$wp_customize->add_setting(
			'md_social_checkbox',
			array(
				'default'           => true,
				'sanitize_callback' => 'it_zone_sanitize_checkbox',
			)
		);

		$wp_customize->add_control(
			new IT_Zone_Toggle_Control(
				$wp_customize,
				'md_social_checkbox',
				array(
					'label'           => esc_html__( 'Enable to open in new tab.', 'it-zone' ),
					'section'         => 'social_media_section',
					'type'            => 'checkbox',
					'active_callback' => 'it_zone_social_media_active_callback',
				)
			)
		);
	}
endif;
add_action( 'customize_register', 'it_zone_customize_register_socialmedia' );

function it_zone_social_media_active_callback( $control ) {
	$toggle_social_media = $control->manager->get_setting( 'socialmedia_toggle' )->value();

	$id = $control->id;

	// Check if social media toggle is enabled
	if ( ! $toggle_social_media ) {
		return false;
	}

	// List of all social media related control IDs
	$social_media_controls = array(
		'socials_media_repeater',
		'socialmedia_heading',
		'social_facebook_link',
		'social_instagram_link',
		'social_linkedin_link',
		'social_pinterest_link',
		'md_social_checkbox',
	);

	// Return true if the current control is in our social media controls list
	return in_array( $id, $social_media_controls );
}
